package restcontroller.sysmanage.develop.dataimport;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.ExcelFactory;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import common.data.db.SQLiteMemory;
import common.data.db.SQLiteTable;
import common.data.db.SQLiteTableData;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import restcontroller.R;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

@API(title = "数据导入")
public class dataimport extends Controller {

    public dataimport(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "数据导入列表查询", apiversion = R.ID10009501.v1.class)
    public String querydataimport() throws YosException {
        /**
         * 过滤条件设置
         */
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("t1.table_name like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t2.table_comment like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.remarks like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
            if (whereObject.containsKey("siteid") && !"".equals(whereObject.getString("siteid"))) {
                where.append(" and(");
                where.append("t1.siteid ='").append(whereObject.getString("siteid")).append("'");
                where.append(")");
            }
        }
        Rows rows = dbConnect.runSqlQuery("select t1.sys_dataimportid,t1.siteid,t1.table_name,t2.table_comment,t1.remarks,t1.uniquecolumnname,t1.autouniqueid,t1.importmode,t1.status,t1.changeuserid,t1.type,t1.sequence from sys_dataimport t1 inner join sys_object t2 on t1.table_name=t2.table_name where " + where + " order by t1.sequence");
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "数据导入详情查询", apiversion = R.ID10009601.v1.class)
    public String querydataimportmx() throws YosException {
        long sys_dataimportid = content.getLong("sys_dataimportid");
        boolean isautomapping = content.getBooleanValue("isautomapping");
        Rows rows = dbConnect.runSqlQuery("select * from sys_dataimport where sys_dataimportid=" + sys_dataimportid);
        for (Row row : rows) {
            String table_name = row.getString("table_name");
            JSONArray table_columnArray = row.getJSONArray("table_column");
            Rows objectcolRows = dbConnect.runSqlQuery("select column_name,column_title,column_type,numeric_precision,numeric_scale,is_nullable,column_default from sys_objectcols where table_name='" + table_name + "' order by sequence");
            for (Row objectcolRow : objectcolRows) {
                objectcolRow.put("mapping", "");
                objectcolRow.put("linkmapping", new JSONObject());
                objectcolRow.put("isuniquecolumn", getuniquecolumnname(table_name).equalsIgnoreCase(objectcolRow.getString("column_name")));
                if (isautomapping) {
                    if (!objectcolRow.getBoolean("isuniquecolumn")) {
                        objectcolRow.put("mapping", objectcolRow.getString("column_title"));
                    }
                } else {
                    for (Object o : table_columnArray) {
                        JSONObject table_columnObject = (JSONObject) o;
                        if (objectcolRow.getString("column_name").equalsIgnoreCase(table_columnObject.getString("column_name"))) {
                            objectcolRow.put("mapping", table_columnObject.getStringValue("mapping"));
                            objectcolRow.put("linkmapping", table_columnObject.getJSONObject("linkmapping"));
                            objectcolRow.put("keyfield", table_columnObject.getIntValue("keyfield"));
                        }
                    }
                }
                objectcolRow.put("keyfield", objectcolRow.getString("column_name").equalsIgnoreCase("siteid") || objectcolRow.getBoolean("keyfield") ? 1 : 0);
            }
            Rows sys_objectRows = dbConnect.runSqlQuery("select table_comment from sys_object where table_name='" + row.getString("table_name") + "'");
            row.put("table_column", objectcolRows.toJsonArray());
            row.put("table_comment", sys_objectRows.get(0).getString("table_comment"));
            if (isautomapping) {
                dbConnect.runSqlUpdate("update sys_dataimport set table_column='" + objectcolRows.toJsonArray() + "',changeuserid=" + userid + " where sys_dataimportid=" + sys_dataimportid);
            }
        }
        Row row = rows.get(0);
        {
            JSONArray pageArray = new JSONArray();
            JSONArray datarows = row.getJSONArray("datarows");
            for (int i = (pageNumber - 1) * pageSize; i < pageNumber * pageSize && i < datarows.size(); i++) {
                pageArray.add(datarows.get(i));
            }
            row.put("datarows", pageArray);

            JSONObject datarowspagemsg = new JSONObject();
            datarowspagemsg.put("pageNumber", pageNumber);
            datarowspagemsg.put("pageSize", pageSize);
            datarowspagemsg.put("total", datarows.size());
            datarowspagemsg.put("pageTotal", new Double(Math.ceil((double) datarows.size() / (double) pageSize)).longValue());
            row.put("datarowspagemsg", datarowspagemsg);
        }
        {
            int errpageNumber = this.content.getIntValue("errpageNumber", 1);
            int errpageSize = this.content.getIntValue("errpageSize", 20);
            JSONArray pageArray = new JSONArray();
            JSONArray errdatarows = row.getJSONArray("errdatarows");
            for (int i = (errpageNumber - 1) * errpageSize; i < errpageNumber * errpageSize && i < errdatarows.size(); i++) {
                pageArray.add(errdatarows.get(i));
            }
            row.put("errdatarows", pageArray);

            JSONObject datarowspagemsg = new JSONObject();
            datarowspagemsg.put("pageNumber", errpageNumber);
            datarowspagemsg.put("pageSize", errpageSize);
            datarowspagemsg.put("total", errdatarows.size());
            datarowspagemsg.put("pageTotal", new Double(Math.ceil((double) errdatarows.size() / (double) errpageSize)).longValue());
            row.put("errdatarowspagemsg", datarowspagemsg);
        }

        return getSucReturnObject().setData(row).toString();
    }

    @API(title = "数据导入新建或修改", apiversion = R.ID10009701.v1.class)
    public String insertormidifydataimport() throws YosException {
        long sys_dataimportid = content.getLong("sys_dataimportid");
        String siteid = content.getString("siteid");
        String table_name = content.getString("table_name");
        String importmode = content.getString("importmode");
        String datakey = "";
        if (importmode.equalsIgnoreCase("dataquery")) {
            datakey = content.getString("datakey");
        }
        boolean autouniqueid = content.getBooleanValue("autouniqueid");
        if (table_name.equals("")) {
            return getErrReturnObject().setErrMsg("导入表不可为空").toString();
        }
        String remarks = content.getString("remarks");
        String type = content.getString("type");
        if (type.equals("")) {
            return getErrReturnObject().setErrMsg("导入类型不可为空").toString();
        }
        int sequence = content.getIntValue("sequence");

        Rows rows = dbConnect.runSqlQuery("select * from sys_dataimport where sys_dataimportid=" + sys_dataimportid);
        if (sys_dataimportid <= 0 || rows.isEmpty()) {
            SQLFactory sqlFactory = new SQLFactory(this, "新建数据导入");
            sys_dataimportid = createTableID("sys_dataimport");
            sqlFactory.addParameter("sys_dataimportid", sys_dataimportid);
            sqlFactory.addParameter("siteid", siteid);
            sqlFactory.addParameter("table_name", table_name);
            sqlFactory.addParameter("uniquecolumnname", getuniquecolumnname(table_name));
            sqlFactory.addParameter("type", type);
            sqlFactory.addParameter("sequence", sequence);
            sqlFactory.addParameter("importmode", importmode);
            sqlFactory.addParameter("datakey", datakey);
            sqlFactory.addParameter("autouniqueid", autouniqueid ? 1 : 0);

            sqlFactory.addParameter("datarows", new JSONArray());
            sqlFactory.addParameter("data_column", new JSONArray());
            sqlFactory.addParameter("table_column", new JSONArray());
            sqlFactory.addParameter("changeuserid", userid);
            sqlFactory.addParameter("remarks", remarks);
            dbConnect.runSqlUpdate(sqlFactory.getSQL());
            content.put("sys_dataimportid", sys_dataimportid);
            return querydataimportmx();
        } else {
            String sqlstr = content.getString("sqlstr", true);
            JSONArray data_column = content.getJSONArray("data_column");
            if (!sqlstr.equals("") && !sqlstr.equals(rows.get(0).getString("sqlstr"))) {
                sqlstr = sqlstr.replaceAll("(?i)delete", "delete").replaceAll("(?i)update", "update").replaceAll("(?i)insert", "insert");
                if (sqlstr.contains("delete ") || sqlstr.contains("update ") || sqlstr.contains("insert ")) {
                    return getErrReturnObject().setErrMsg("只允许进行查询操作").toString();
                }
                try {
                    String x = sqlstr.replaceAll("(?i)where ", "where 1=2 and ");
                    data_column = (JSONArray) JSONArray.toJSON(dbConnect.runSqlQuery(x).getFieldList());
                } catch (Exception ignored) {
                }
            }
            JSONArray table_column = content.getJSONArray("table_column");
            dbConnect.runSqlUpdate("update sys_dataimport set sequence='" + sequence + "', datakey='" + datakey + "', sqlstr='" + sqlstr + "',data_column='" + data_column + "',table_column='" + table_column.toString() + "',changeuserid=" + userid + ",remarks='" + remarks + "' where sys_dataimportid=" + sys_dataimportid);
            return getSucReturnObject().toString();
        }
    }

    @API(title = "数据清除", apiversion = R.ID10009801.v1.class)
    public String dataclean() throws YosException {
        long sys_dataimportid = content.getLong("sys_dataimportid");
        dbConnect.runSqlUpdate("update sys_dataimport set  datarows='" + new JSONArray() + "',errdatarows='" + new JSONArray() + "' where sys_dataimportid=" + sys_dataimportid);
        return getSucReturnObject().toString();
    }

    @API(title = "数据导入校验", apiversion = R.ID10009901.v1.class)
    public String dataimportvalidate() throws YosException {
        long sys_dataimportid = content.getLong("sys_dataimportid");
        boolean justcheckerrdata = content.getBooleanValue("justcheckerrdata");//是否仅校验错误数据
        Rows rows = dbConnect.runSqlQuery("select siteid,table_name,datarows,errdatarows,data_column,table_column,type,uniquecolumnname,importmode from sys_dataimport where sys_dataimportid=" + sys_dataimportid);
        if (!rows.isEmpty()) {
            String siteid = rows.get(0).getString("siteid");//数据导入的站点
            String table_name = rows.get(0).getString("table_name");//数据导入表
            String type = rows.get(0).getString("type");//数据导入类型
            String uniquecolumnname = rows.get(0).getString("uniquecolumnname");
            JSONArray datarows = rows.get(0).getJSONArray("datarows");//导入数据
            JSONArray errdatarows = rows.get(0).getJSONArray("errdatarows");//导入的错误数据
            datarows.addAll(errdatarows);
            errdatarows = new JSONArray();
            JSONArray table_column = rows.get(0).getJSONArray("table_column");//导入数据

            if (datarows.isEmpty()) {
                String importmode = rows.get(0).getString("importmode");
                if (importmode.equalsIgnoreCase("excel")) {
                    return getErrReturnObject().setErrMsg("请先进行Excel读取").toString();
                } else {
                    return getErrReturnObject().setErrMsg("请先进行数据读取").toString();
                }
            }
            //获取table_column中关联表的字段信息
            HashMap<String, LinkedList<String>> linktablecolumn = new HashMap<>();
            for (Object o : table_column) {
                JSONObject table_columnObject = (JSONObject) o;
                String mapping = table_columnObject.getStringValue("mapping");
                if (mapping.equals("关联取值")) {
                    JSONObject linkmappingObject = table_columnObject.getJSONObject("linkmapping");

                    LinkedList<String> columnlist;
                    if (linktablecolumn.containsKey(linkmappingObject.getString("table_name"))) {
                        columnlist = linktablecolumn.get(linkmappingObject.getString("table_name"));
                    } else {
                        columnlist = new LinkedList<>();
                    }
                    columnlist.add(linkmappingObject.getString("column_name"));
                    JSONArray conditionArray = linkmappingObject.getJSONArray("condition");
                    for (Object condition : conditionArray) {
                        columnlist.add(((JSONObject) condition).getString("column_name"));
                    }
                    linktablecolumn.put(linkmappingObject.getString("table_name"), columnlist);
                }
            }

            HashMap<String, JSONObject> mappingtable_columnmap = new HashMap<>();//导入的字段
            HashMap<String, JSONObject> linkmappingtable_columnmap = new HashMap<>();//导入需要关联映射的字段
            HashMap<String, Rows> linkDataRowsMap = new HashMap<>();//关联映射的数据

            HashMap<String, String> keyfieldValaueMap = new HashMap<>();//key字段值
            for (Object o : table_column) {
                JSONObject table_columnObject = (JSONObject) o;
                String column_name = table_columnObject.getString("column_name");//数据库字段名称
                String column_title = table_columnObject.getString("column_title");//数据库字段标题
                String mapping = table_columnObject.getStringValue("mapping");
                String column_default = table_columnObject.getStringValue("column_default");
                boolean keyfield = table_columnObject.getBooleanValue("keyfield");//是否为key字段
                boolean is_nullable = table_columnObject.getBooleanValue("is_nullable");//是否允许为空
                if (keyfield) {
                    keyfieldValaueMap.put(column_name, "");
                }
                if (!mapping.equals("")) {
                    if (mapping.equals("关联取值")) {
                        linkmappingtable_columnmap.put(column_name, table_columnObject);
                        /*
                        获取关联取值的规则，及查询关联取值表数据
                         */
                        JSONObject linkmappingObject = table_columnObject.getJSONObject("linkmapping");
                        String link_table_name = linkmappingObject.getString("table_name");
                        if (!linkDataRowsMap.containsKey(link_table_name) && linktablecolumn.containsKey(link_table_name)) {
                            //如果数据已经查询过则不再进行查询

                            if (getTableColumns(link_table_name).containsKey("siteid")) {
                                linkDataRowsMap.put(link_table_name, dbConnect.runSqlQuery("select " + linktablecolumn.get(link_table_name).toString().replace("[", "").replace("]", "") + " from " + link_table_name + " where siteid='" + siteid + "'"));
                            } else {
                                linkDataRowsMap.put(link_table_name, dbConnect.runSqlQuery("select " + linktablecolumn.get(link_table_name).toString().replace("[", "").replace("]", "") + " from " + link_table_name + " where 1=1 "));
                            }
                        }
                    } else {
                        mappingtable_columnmap.put(mapping, table_columnObject);
                    }
                } else if (keyfield) {
                    return getErrReturnObject().setErrMsg("【" + column_title + "】 为关键字段，必须进行字段映射设置").toString();
                } else if (!is_nullable && column_default.equalsIgnoreCase("") && type.equalsIgnoreCase("insert")) {
                    if (!table_columnObject.getBooleanValue("isuniquecolumn") && !column_name.equalsIgnoreCase("createdate")
                            && !column_name.equalsIgnoreCase("createuserid") && !column_name.equalsIgnoreCase("createby") &&
                            !column_name.equalsIgnoreCase("changeuserid") && !column_name.equalsIgnoreCase("changedate") && !column_name.equalsIgnoreCase("changeby")) {
                        return getErrReturnObject().setErrMsg("【" + column_title + "】 字段为必填项，必须进行字段映射设置").toString();
                    }
                }
            }
            //为关联映射的数据创建临时缓存表
            for (String tablename : linkDataRowsMap.keySet()) {
                SQLiteTable sqLiteTable = SQLiteTable.getTable(tablename + "_dataimport");
                if (!sqLiteTable.dosNotExist()) {
                    sqLiteTable.dropTable();
                }
                for (String column_name : linktablecolumn.get(tablename)) {
                    sqLiteTable.addColumn(column_name, SQLiteTable.FieldType.VARCHAR);
                }
                sqLiteTable.create();
                for (Row linkdatarows : linkDataRowsMap.get(tablename)) {
                    SQLiteTableData sqLiteTableData = sqLiteTable.makeData();
                    for (String column_name : linktablecolumn.get(tablename)) {
                        sqLiteTableData.set(column_name, linkdatarows.getString(column_name));
                    }
                    sqLiteTableData.insert();
                }
            }
            {
                SQLiteTable sqLiteTable = SQLiteTable.getTable(table_name + "__dataimport");
                if (!sqLiteTable.dosNotExist()) {
                    sqLiteTable.dropTable();
                }
                sqLiteTable.addColumn(uniquecolumnname, SQLiteTable.FieldType.VARCHAR);

                LinkedList<String> fieldlist = new LinkedList<>();
                fieldlist.add(uniquecolumnname);
                for (String column_name : keyfieldValaueMap.keySet()) {
                    sqLiteTable.addColumn(column_name, SQLiteTable.FieldType.VARCHAR);
                    fieldlist.add(column_name);
                }
                sqLiteTable.create();
                Rows rows_;
                if (getTableColumns(table_name).containsKey("siteid")) {
                    rows = dbConnect.runSqlQuery("select " + fieldlist.toString().replace("[", "").replace("]", "") + " from " + table_name + " where siteid='" + siteid + "'");
                } else {
                    rows = dbConnect.runSqlQuery("select " + fieldlist.toString().replace("[", "").replace("]", "") + " from " + table_name + " where 1=1 ");
                }
                for (Row table_datarows : rows) {
                    SQLiteTableData sqLiteTableData = sqLiteTable.makeData();
                    for (String column_name : fieldlist) {
                        sqLiteTableData.set(column_name, table_datarows.getString(column_name));
                    }
                    sqLiteTableData.insert();
                }
            }

            boolean hassiteid = getTableColumns(table_name).containsKey("siteid");
            /*
             *遍历导入的数据，进行校验
             */
            //JSONArray errdatarows = new JSONArray();
            for (Object o : datarows) {
                JSONObject datarow = (JSONObject) o;
                if (justcheckerrdata) {
                    if (!((datarow.containsKey("errmsg") && !datarow.getJSONObject("errmsg").isEmpty()) || (datarow.containsKey("linkdata") && datarow.getJSONObject("linkdata").containsKey("errmsg") && !datarow.getJSONObject("linkdata").getJSONObject("errmsg").isEmpty()))) {
                        continue;
                    }
                }

                JSONObject errmsgObject = new JSONObject();
                /*
                遍历每行的字段数据，进行校验
                 */
                for (String datarow_column : datarow.keySet()) {
                    /*
                    非关联取值的字段内容校验
                     */
                    if (mappingtable_columnmap.containsKey(datarow_column)) {
                        JSONObject table_columnObject = mappingtable_columnmap.get(datarow_column);
                        String column_name = table_columnObject.getString("column_name");//数据库字段名称
                        String column_title = table_columnObject.getString("column_title");//数据库字段标题
                        boolean is_nullable = table_columnObject.getBooleanValue("is_nullable");//是否允许为空
                        String column_type = table_columnObject.getString("column_type").toLowerCase();//字段类型
                        /**
                         * 校验是否必填、字段类型、长度
                         */
                        if (!is_nullable && datarow.getStringValue(datarow_column).equals("") && type.equalsIgnoreCase("insert")) {
                            errmsgObject.put(datarow_column, "必填项");
                            continue;
                        }
                        if (column_name.equalsIgnoreCase("siteid") && !datarow.getStringValue(datarow_column).equals(siteid)) {
                            errmsgObject.put(datarow_column, "站点错误");
                            continue;
                        }
                        Object value = datarow.get(datarow_column);
                        if (keyfieldValaueMap.containsKey(column_name)) {
                            keyfieldValaueMap.put(column_name, String.valueOf(value));
                        }

                        switch (column_type) {
                            case "int": {
                                try {
                                    datarow.getIntValue(datarow_column);
                                } catch (Exception e) {
                                    errmsgObject.put(datarow_column, "不是有效的" + column_type + "类型");
                                }
                                continue;
                            }
                            case "bigint": {
                                try {
                                    datarow.getLongValue(datarow_column);
                                } catch (Exception e) {
                                    errmsgObject.put(datarow_column, "不是有效的" + column_type + "类型");
                                }
                                continue;
                            }
                            case "smallint": {
                                try {
                                    datarow.getBooleanValue(datarow_column);
                                } catch (Exception e) {
                                    errmsgObject.put(datarow_column, "不是有效的Boolean类型");
                                }
                                continue;
                            }
                            case "decimal": {
                                try {
                                    datarow.getBigDecimal(datarow_column);
                                } catch (Exception e) {
                                    errmsgObject.put(datarow_column, "不是有效的" + column_type + "类型");
                                }
                                continue;
                            }
                            case "date":
                            case "datetime": {
                                try {
                                    datarow.getDate(datarow_column);
                                } catch (Exception e) {
                                    errmsgObject.put(datarow_column, "不是有效的" + column_type + "类型");
                                }
                                continue;
                            }
                            default:
                        }
                    }
                }
                /*
                对关联映射的字段内容进行校验，并获取关联字段值
                 */
                boolean islinkdataerr = false;
                if (!linkmappingtable_columnmap.isEmpty()) {
                    JSONObject linkdataObject = new JSONObject();
                    JSONObject linkdataerrmsgObject = new JSONObject();
                    /*
                    遍历关联映射字段，并逐个获取关联映射值
                     */
                    for (String column_name : linkmappingtable_columnmap.keySet()) {
                        JSONObject table_columnObject = linkmappingtable_columnmap.get(column_name);
                        boolean is_nullable = table_columnObject.getBooleanValue("is_nullable");//是否允许为空
                        String value = "";
                        JSONObject linkmappingObject = table_columnObject.getJSONObject("linkmapping");
                        if (linkmappingObject.containsKey("table_name") && linkDataRowsMap.containsKey(linkmappingObject.getString("table_name"))) {
                            String link_table_name = linkmappingObject.getString("table_name");//关联取值表
                            String link_column_name = linkmappingObject.getString("column_name");//关联取值字段
                            JSONArray link_fieldsArray = linkmappingObject.getJSONArray("condition");//关联取值条件
                            String linkdataquerywhere = " 1=1 ";
                            for (Object link_field : link_fieldsArray) {
                                JSONObject link_fieldObject = (JSONObject) link_field;
                                String condition_column_name = link_fieldObject.getString("column_name");
                                String condition_mapping = link_fieldObject.getString("mapping");
                                switch (getColumnType(link_table_name, condition_column_name)) {
                                    case "int":
                                    case "smallint":
                                    case "bigint": {
                                        long condition_mapping_value = 0L;
                                        if (datarow.containsKey(condition_mapping)) {
                                            condition_mapping_value = datarow.getLongValue(condition_mapping);
                                        }
                                        linkdataquerywhere = linkdataquerywhere + " and " + condition_column_name + "='" + condition_mapping_value + "'";
                                        break;
                                    }
                                    case "decimal": {
                                        float condition_mapping_value = 0L;
                                        if (datarow.containsKey(condition_mapping)) {
                                            condition_mapping_value = datarow.getFloatValue(condition_mapping);
                                        }
                                        linkdataquerywhere = linkdataquerywhere + " and " + condition_column_name + "='" + condition_mapping_value + "'";
                                        break;
                                    }
                                    default: {
                                        String condition_mapping_value = "";
                                        if (datarow.containsKey(condition_mapping)) {
                                            condition_mapping_value = datarow.getString(condition_mapping);
                                        }
                                        linkdataquerywhere = linkdataquerywhere + " and " + condition_column_name + "='" + condition_mapping_value + "'";
                                        break;
                                    }
                                }
                            }
                            Rows linkdataRows = SQLiteMemory.runSqlQuery("select " + link_column_name + " from " + link_table_name + "_dataimport" + " where " + linkdataquerywhere);
                            if (!is_nullable && linkdataRows.size() == 0) {
                                linkdataerrmsgObject.put(column_name, "找不到关联项");
                                continue;
                            }
                            if (linkdataRows.size() > 1) {
                                linkdataerrmsgObject.put(column_name, "找不到唯一的关联项");
                                continue;
                            }
                            if (linkdataRows.size() == 1) {
                                value = linkdataRows.get(0).getString(link_column_name);
                            }
                        }
                        if (!is_nullable && value.equals("")) {
                            linkdataerrmsgObject.put(column_name, "必填项");
                        }
                        if (keyfieldValaueMap.containsKey(column_name)) {
                            keyfieldValaueMap.put(column_name, value);
                        }
                        linkdataObject.put(column_name, value);
                    }
                    linkdataObject.put("errmsg", linkdataerrmsgObject);
                    if (!linkdataerrmsgObject.isEmpty()) {
                        islinkdataerr = true;
                    }
                    datarow.put("linkdata", linkdataObject);
                }
                if (!keyfieldValaueMap.isEmpty()) {
                    StringBuilder sqlBuffer;
                    if (hassiteid) {
                        sqlBuffer = new StringBuilder("select " + uniquecolumnname + " from " + table_name + "__dataimport" + " where siteid='" + siteid + "'");
                    } else {
                        sqlBuffer = new StringBuilder("select " + uniquecolumnname + " from " + table_name + "__dataimport" + " where 1=1 ");
                    }
                    for (String key : keyfieldValaueMap.keySet()) {
                        String value = keyfieldValaueMap.get(key);
                        switch (getColumnType(table_name, key)) {
                            case "int":
                            case "smallint":
                            case "bigint": {
                                if (value.equals("")) {
                                    sqlBuffer.append(" and ").append(key).append("='").append(value).append("'");
                                } else {
                                    sqlBuffer.append(" and ").append(key).append("='").append(new BigDecimal(value).longValue()).append("'");
                                }
                                break;
                            }
                            case "decimal": {
                                if (value.equals("")) {
                                    sqlBuffer.append(" and ").append(key).append("='").append(value).append("'");
                                } else {
                                    sqlBuffer.append(" and ").append(key).append("='").append(new BigDecimal(value).floatValue()).append("'");
                                }
                                break;
                            }
                            default: {
                                sqlBuffer.append(" and ").append(key).append("='").append(value).append("'");
                                break;
                            }
                        }
                    }
                    Rows checkrows = SQLiteMemory.runSqlQuery(sqlBuffer.toString());
                    if (type.equalsIgnoreCase("insert")) {
                        if (!checkrows.isEmpty()) {
                            errmsgObject.put("datarow_errmsg", "数据已存在");
                        }
                    } else if (type.equalsIgnoreCase("update")) {
                        if (checkrows.isEmpty()) {
                            errmsgObject.put("datarow_errmsg", "更新的数据不存在");
                        } else if (checkrows.size() != 1) {
                            errmsgObject.put("datarow_errmsg", "更新的数据不唯一");
                        }
                    }
                } else if (type.equalsIgnoreCase("update")) {
                    errmsgObject.put("datarow_errmsg", "没有设置key字段");
                }
                datarow.put("errmsg", errmsgObject);
                if (!errmsgObject.isEmpty() || islinkdataerr) {
                    errdatarows.add(datarow);
                }
            }
            for (Object o : errdatarows) {
                datarows.remove(o);
            }
            dbConnect.runSqlUpdate("update sys_dataimport set datarows='" + datarows + "',errdatarows='" + errdatarows + "' where sys_dataimportid=" + sys_dataimportid);
            for (String tablename : linkDataRowsMap.keySet()) {
                SQLiteTable sqLiteTable = SQLiteTable.getTable(tablename + "_dataimport");
                if (!sqLiteTable.dosNotExist()) {
                    sqLiteTable.dropTable();
                }
            }
            SQLiteTable sqLiteTable = SQLiteTable.getTable(table_name + "__dataimport");
            if (!sqLiteTable.dosNotExist()) {
                sqLiteTable.dropTable();
            }
        }
        return getSucReturnObject().toString();
    }

    @API(title = "数据导入", apiversion = R.ID10010001.v1.class)
    public String importdata() throws YosException {
        //导入前进行数据校验
        long sys_dataimportid = content.getLong("sys_dataimportid");
        boolean excepterrdata = content.getBooleanValue("excepterrdata");//是否排除错误数据
        Rows rows = dbConnect.runSqlQuery("select siteid,table_name,datarows,errdatarows,table_column,type from sys_dataimport where sys_dataimportid=" + sys_dataimportid);
        if (!rows.isEmpty()) {
            String siteid = rows.get(0).getString("siteid");//数据导入的站点
            String table_name = rows.get(0).getString("table_name");//表格数据
            String type = rows.get(0).getString("type");
            JSONArray datarows = rows.get(0).getJSONArray("datarows");//导入数据
            JSONArray errdatarows = rows.get(0).getJSONArray("errdatarows");//导入数据
            if (!excepterrdata && !errdatarows.isEmpty()) {
                return getErrReturnObject().setErrMsg("存在错误数据，导入不成功！").toString();
            }
            JSONArray table_columns = rows.get(0).getJSONArray("table_column");//数据表结构
            ArrayList<String> column_nameList = new ArrayList<>();
            for (Object table_column : table_columns) {
                JSONObject table_columnObject = (JSONObject) table_column;
                column_nameList.add(table_columnObject.getString("column_name"));
            }

            if (type.equalsIgnoreCase("insert")) {
                StringBuffer sqlBuffer = new StringBuffer();

                SQLFactory insertSQL = new SQLFactory("sql:insert into " + table_name + " $table_columns$");
                insertSQL.addParameter_SQL_in("table_columns", column_nameList);

                sqlBuffer.append(insertSQL.getSQL() + "\n");
                sqlBuffer.append("values \n");

                long[] ids = createTableID(table_name, datarows.size() + 10);
                int idindex = 0;
                for (Object o : datarows) {
                    JSONObject datarow = (JSONObject) o;
                    SQLFactory valueSQl = new SQLFactory("sql:$columns_values$");
                    ArrayList<String> valueList = new ArrayList<>();
                    for (Object table_column : table_columns) {
                        String value = "null";
                        JSONObject table_columnObject = (JSONObject) table_column;
                    /*
                    获取字段值
                     */
                        boolean isuniquecolumn = table_columnObject.getBooleanValue("isuniquecolumn");
                        String mapping = table_columnObject.getString("mapping");

                        String column_name = table_columnObject.getString("column_name");
                        String column_default = table_columnObject.getString("column_default");
                        if (mapping.equals("关联取值")) {
                            JSONObject linkdataObject = datarow.getJSONObject("linkdata");
                            value = (String) linkdataObject.getOrDefault(column_name, "null");
                            if (value.equals("")) {
                                value = "null";
                            }
                        } else if (!mapping.equals("")) {
                            value = datarow.getStringValue(mapping);
                            if (value.equals("")) {
                                value = "null";
                            }
                        } else if (isuniquecolumn) {
                            value = String.valueOf(ids[idindex++]);
                        } else if (column_name.equalsIgnoreCase("siteid")) {
                            value = siteid;
                        } else if (column_name.equalsIgnoreCase("createdate")) {
                            value = getDateTime_Str();
                        } else if (column_name.equalsIgnoreCase("createby")) {
                            value = username;
                        } else if (column_name.equalsIgnoreCase("createuserid")) {
                            value = String.valueOf(userid);
                        } else if (column_name.equalsIgnoreCase("changedate")) {
                            value = getDateTime_Str();
                        } else if (column_name.equalsIgnoreCase("changeby")) {
                            value = username;
                        } else if (column_name.equalsIgnoreCase("changeuserid")) {
                            value = String.valueOf(userid);
                        } else if (!column_default.equals("")) {
                            value = table_columnObject.getString("column_default");
                        }
                        valueList.add(value);
                    }
                    valueSQl.addParameter_in("columns_values", valueList);
                    sqlBuffer.append(valueSQl.getSQL()).append(",\n");
                }
                sqlBuffer = sqlBuffer.replace(sqlBuffer.length() - 2, sqlBuffer.length(), "");
                dbConnect.runSqlUpdate(sqlBuffer.toString());
            } else if (type.equalsIgnoreCase("update")) {

                String uniquecolumnname = getuniquecolumnname(table_name);
                boolean hassiteid = getTableColumns(table_name).containsKey("siteid");

                ArrayList<String> SQLlist = new ArrayList<>();
                for (Object datarow : datarows) {
                    StringBuffer updatesqlBuffer;
                    StringBuffer wheresqlBuffer;

                    if (hassiteid) {
                        updatesqlBuffer = new StringBuffer("update " + table_name + " set siteid='" + siteid + "'");
                        wheresqlBuffer = new StringBuffer("where siteid='" + siteid + "'");
                    } else {
                        updatesqlBuffer = new StringBuffer("update " + table_name + " set " + uniquecolumnname + "=" + uniquecolumnname);
                        wheresqlBuffer = new StringBuffer("where 1=1 ");
                    }

                    JSONObject datarowObject = (JSONObject) datarow;

                    for (Object table_column : table_columns) {
                        String value = "null";
                        boolean ismodify = false;

                        JSONObject table_columnObject = (JSONObject) table_column;
                        String mapping = table_columnObject.getString("mapping");
                        String column_name = table_columnObject.getString("column_name");
                        boolean iskeyfield = table_columnObject.getBooleanValue("keyfield");
                        if (mapping.equals("关联取值")) {
                            JSONObject linkdataObject = datarowObject.getJSONObject("linkdata");
                            value = (String) linkdataObject.getOrDefault(column_name, "null");
                            ismodify = true;
                        } else if (!mapping.equals("")) {
                            value = datarowObject.getStringValue(mapping);
                            ismodify = true;
                        } else if (column_name.equalsIgnoreCase("changedate")) {
                            value = getDateTime_Str();
                            ismodify = true;
                        } else if (column_name.equalsIgnoreCase("changeby")) {
                            value = username;
                            ismodify = true;
                        } else if (column_name.equalsIgnoreCase("changeuserid")) {
                            value = String.valueOf(userid);
                            ismodify = true;
                        }
                        if (iskeyfield) {
                            wheresqlBuffer.append(" and ").append(column_name).append("='").append(value).append("'");
                        } else if (ismodify) {
                            if (value.equalsIgnoreCase("null") || value.equals("")) {
                                updatesqlBuffer.append(",").append(column_name).append("=null");
                            } else {
                                updatesqlBuffer.append(",").append(column_name).append("='").append(value).append("'");
                            }
                        }
                    }
                    SQLlist.add(updatesqlBuffer.append(wheresqlBuffer).toString());
                }
                dbConnect.runSqlUpdate(SQLlist);
            }
        }
        return getSucReturnObject().toString();
    }

    @API(title = "导入删除", apiversion = R.ID10010101.v1.class)
    public String deletedataimport() throws YosException {
        long sys_dataimportid = content.getLong("sys_dataimportid");
        dbConnect.runSqlUpdate("delete from sys_dataimport where sys_dataimportid=" + sys_dataimportid);
        return getSucReturnObject().toString();
    }

    @API(title = "导入复制", apiversion = R.ID10010201.v1.class)
    public String duplicatedataimport() throws YosException {
        long sys_dataimportid_old = content.getLong("sys_dataimportid");
        long sys_dataimportid = createTableID("sys_dataimport");

        String siteid = content.getString("siteid");
        String remarks = content.getString("remarks");

        Rows rows = dbConnect.runSqlQuery("select * from sys_dataimport where sys_dataimportid=" + sys_dataimportid_old);
        if (rows.isEmpty()) {
            return getErrReturnObject().setErrMsg("找不到当前导入模板").toString();
        }
        String table_name = rows.get(0).getString("table_name");
        String type = rows.get(0).getString("type");
        String importmode = rows.get(0).getString("importmode");
        String datakey = rows.get(0).getString("datakey");
        long sequence = rows.get(0).getLong("sequence");
        int autouniqueid = rows.get(0).getInteger("autouniqueid");
        JSONArray table_column = rows.get(0).getJSONArray("table_column");
        JSONArray data_column = rows.get(0).getJSONArray("data_column");

        SQLFactory sqlFactory = new SQLFactory(this, "新建数据导入");
        sqlFactory.addParameter("sys_dataimportid", sys_dataimportid);
        sqlFactory.addParameter("siteid", siteid);
        sqlFactory.addParameter("table_name", table_name);
        sqlFactory.addParameter("uniquecolumnname", getuniquecolumnname(table_name));
        sqlFactory.addParameter("type", type);
        sqlFactory.addParameter("autouniqueid", autouniqueid);
        sqlFactory.addParameter("importmode", importmode);
        sqlFactory.addParameter("sequence", sequence);
        sqlFactory.addParameter("datakey", datakey);


        sqlFactory.addParameter("datarows", new JSONArray());
        sqlFactory.addParameter("data_column", data_column);
        sqlFactory.addParameter("table_column", table_column);

        sqlFactory.addParameter("changeuserid", userid);
        sqlFactory.addParameter("remarks", remarks);
        dbConnect.runSqlUpdate(sqlFactory.getSQL());
        content.put("sys_dataimportid", sys_dataimportid);
        return querydataimportmx();
    }

    @API(title = "数据上传", apiversion = R.ID10010301.v1.class)
    public String uploaddata() throws YosException {
        long sys_dataimportid = content.getLong("sys_dataimportid");
        Rows sys_dataimportRow = dbConnect.runSqlQuery("select table_name,datarows,data_column,table_column,siteid,importmode,datakey,sqlstr from sys_dataimport where sys_dataimportid=" + sys_dataimportid);
        if (sys_dataimportRow.isEmpty()) {
            return getErrReturnObject().setErrMsg("找不到id为" + sys_dataimportid + "的导入模板").toString();
        }
        String table_name = sys_dataimportRow.get(0).getString("table_name");
        String table_comment = getTableName(table_name);
        String siteid = sys_dataimportRow.get(0).getString("siteid");
        String importmode = sys_dataimportRow.get(0).getString("importmode");
        try {
            ArrayList<String> fieldlist = new ArrayList<>();
            ExcelFactory excelFactory;
            if (importmode.equalsIgnoreCase("excel")) {
                excelFactory = getPostExcelFactory();
            } else {
                excelFactory = new ExcelFactory(table_name + "导入");
                String datakey = sys_dataimportRow.get(0).getString("datakey");
                String sqlstr = sys_dataimportRow.get(0).getString("sqlstr");
                DBConnect dbConnect = new DBConnect(datakey);
                Rows rows = dbConnect.runSqlQuery(sqlstr);
                excelFactory.addSheet(table_name, rows);
            }
            excelFactory.write();
            if (!siteid.equals("")) {
                this.siteid = siteid;
                Rows attRows = uploadExcelToObs(excelFactory);
                for (Row row : attRows) {
                    long attachmentid = row.getLong("attachmentid");
                    createFileLink("sys_dataimport", sys_dataimportid, "default", attachmentid);
                }
            }
            int sheetindex = -1;
            XSSFWorkbook xssfWorkbook = excelFactory.getXssfWorkbook();
            for (int i = 0; i < xssfWorkbook.getNumberOfSheets(); i++) {
                if (xssfWorkbook.getSheetName(i).equalsIgnoreCase(table_name) || xssfWorkbook.getSheetName(i).equalsIgnoreCase(table_comment)) {
                    sheetindex = i;
                    break;
                }
            }
            if (sheetindex < 0) {
                return getErrReturnObject().setErrMsg("找不到对应的sheet数据集，sheet名称可以为【" + table_name + "】或【" + table_comment + "】").toString();
            }

            XSSFRow head = excelFactory.getSheet(sheetindex).getRow(0);
            int columncount = head.getLastCellNum();
            for (int n = 0; n < columncount; n++) {
                XSSFCell cell = head.getCell(n);
                fieldlist.add(cell.getStringCellValue());
            }
            Rows datarows = excelFactory.getSheetRows(sheetindex, fieldlist, 1);
            for (Row datarow : datarows) {
                JSONObject errmsg = new JSONObject();
                errmsg.put("datarow_errmsg", "");
                datarow.put("errmsg", errmsg);
            }

            JSONArray table_columnArray = sys_dataimportRow.get(0).getJSONArray("table_column");
            for (Object o : table_columnArray) {
                JSONObject table_columnObject = (JSONObject) o;
                String column_title = table_columnObject.getString("column_title");
                if (fieldlist.contains(column_title)) {
                    table_columnObject.put("mapping", column_title);
                }
            }

            dbConnect.runSqlUpdate("update sys_dataimport set datarows='" + datarows.toJsonArray() + "',errdatarows='" + new JSONArray() + "' ,data_column='" + JSONArray.toJSON(fieldlist) + "',table_column='" + table_columnArray + "',changeuserid=" + userid + " where sys_dataimportid=" + sys_dataimportid);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return getSucReturnObject().toString();
    }
}
