package restcontroller.sysmanage.develop.appregistry;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Rows;
import common.data.SQLFactory;
import restcontroller.R;

public class system extends Controller {
    public system(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "开发端-系统应用注册-系统列表查询", apiversion = R.ID10007301.v1.class)
    public String querySystemList() throws YosException {
        Rows rows = dbConnect.runSqlQuery("select systemid,`system`,systemname,isused,sequence from sys_system order by sequence");
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "开发端-系统应用注册-系统信息新增修改", apiversion = R.ID10007401.v1.class)
    public String insertormodifySystem() throws YosException {
        if (content.getBooleanValue("isasync")) {
            long systemid = content.getLong("systemid");
            String system = content.getString("system");
            String systemname = content.getString("systemname");
            int isused = content.getIntValue("isused");
            if (dbConnect.runSqlQuery("select * from sys_system where `system`='" + system + "'").isEmpty()) {
                SQLFactory sqlFactory = new SQLFactory(this, "系统新增");
                sqlFactory.addParameter("systemid", createTableID("sys_system"));
                sqlFactory.addParameter("system", system);
                sqlFactory.addParameter("systemname", systemname);
                sqlFactory.addParameter("sequence", 10);
                sqlFactory.addParameter("iconurl", "");
                sqlFactory.addParameter("isused", isused);
                dbConnect.runSqlUpdate(sqlFactory.getSQL());
            } else {
                dbConnect.runSqlUpdate("update sys_system set `system`='" + system + "', systemname='" + systemname + "',isused=" + isused + " where `system`='" + system + "'");
            }
        } else {
            int sequence = content.getIntValue("sequence");
            String system = content.getString("system");
            String systemname = content.getString("systemname");
            int isused = content.getIntValue("isused");
            if (dbConnect.runSqlQuery("select * from sys_system where `system`='" + system + "'").isEmpty()) {
                SQLFactory sqlFactory = new SQLFactory(this, "系统新增");
                sqlFactory.addParameter("systemid", createTableID("sys_system"));
                sqlFactory.addParameter("system", system);
                sqlFactory.addParameter("systemname", systemname);
                sqlFactory.addParameter("sequence", 10);
                sqlFactory.addParameter("iconurl", "");
                sqlFactory.addParameter("isused", isused);
                dbConnect.runSqlUpdate(sqlFactory.getSQL());
            } else {
                dbConnect.runSqlUpdate("update sys_system set systemname='" + systemname + "',isused=" + isused + ",sequence=" + sequence + " where `system`='" + system + "'");
            }
        }
        return getSucReturnObject().toString();
    }

    @API(title = "开发端-系统应用注册-系统信息删除", apiversion = R.ID10007501.v1.class)
    public String deleteSystem() throws YosException {
        long systemid = content.getLong("systemid");
        if (systemid == 0) {
            return getErrReturnObject().setErrMsg("该系统不可删除").toString();
        }
        if (dbConnect.runSqlQuery("select * from sys_systemclient where systemid=" + systemid).isNotEmpty()) {
            return getErrReturnObject().setErrMsg("系统已被使用不可删除").toString();
        }
        dbConnect.runSqlUpdate("delete from sys_system where systemid=" + systemid);
        return getSucReturnObject().toString();
    }

    @API(title = "开发端-系统应用注册-系统端口列表查询", apiversion = R.ID10007601.v1.class)
    public String querySystemClientList() throws YosException {
        long systemid = content.getLong("systemid");
        Rows rows = dbConnect.runSqlQuery("select systemid,systemclientid,systemclient,systemclientname,isused from sys_systemclient where systemid=" + systemid);
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "开发端-系统应用注册-系统操作端信息新增修改", apiversion = R.ID10007701.v1.class)
    public String insertormodifySystemClient() throws YosException {
        if (content.getBooleanValue("isasync")) {
            long systemid = content.getLong("systemid");
            long systemclientid = content.getLong("systemclientid");
            String systemclient = content.getString("systemclient");
            String systemclientname = content.getString("systemclientname");
            int isused = content.getIntValue("isused");

            if (dbConnect.runSqlQuery("select *from sys_system where systemid=" + systemid).isEmpty()) {
                return getErrReturnObject().setErrMsg("系统不存在").toString();
            }
            if (dbConnect.runSqlQuery("select * from sys_systemclient where systemid=" + systemid + " and systemclient='" + systemclient + "'").isEmpty()) {
                SQLFactory sqlFactory = new SQLFactory(this, "系统操作端新增");
                sqlFactory.addParameter("systemid", systemid);
                sqlFactory.addParameter("systemclientid", createTableID("sys_systemclient"));
                sqlFactory.addParameter("systemclient", systemclient);
                sqlFactory.addParameter("systemclientname", systemclientname);
                sqlFactory.addParameter("iconurl", "");
                sqlFactory.addParameter("isused", isused);
                dbConnect.runSqlUpdate(sqlFactory.getSQL());
            } else {
                dbConnect.runSqlUpdate("update sys_systemclient set systemid='" + systemid + "', systemclient='" + systemclient + "',systemclientname='" + systemclientname + "',isused=" + isused + " where systemid=" + systemid + " and systemclient='" + systemclient + "'");
            }
        } else {
            long systemid = content.getLong("systemid");
            long systemclientid = content.getLong("systemclientid");
            String systemclient = content.getString("systemclient");
            String systemclientname = content.getString("systemclientname");
            int isused = content.getIntValue("isused");

            if (dbConnect.runSqlQuery("select *from sys_system where systemid=" + systemid).isEmpty()) {
                return getErrReturnObject().setErrMsg("系统不存在").toString();
            }
            if (dbConnect.runSqlQuery("select * from sys_systemclient where systemid=" + systemid + " and systemclient='" + systemclient + "'").isEmpty()) {
                SQLFactory sqlFactory = new SQLFactory(this, "系统操作端新增");
                sqlFactory.addParameter("systemid", systemid);
                sqlFactory.addParameter("systemclientid", createTableID("sys_systemclient"));
                sqlFactory.addParameter("systemclient", systemclient);
                sqlFactory.addParameter("systemclientname", systemclientname);
                sqlFactory.addParameter("iconurl", "");
                sqlFactory.addParameter("isused", isused);
                dbConnect.runSqlUpdate(sqlFactory.getSQL());
            } else {
                dbConnect.runSqlUpdate("update sys_systemclient set systemid='" + systemid + "', systemclient='" + systemclient + "',systemclientname='" + systemclientname + "',isused=" + isused + " where systemid=" + systemid + " and systemclient='" + systemclient + "'");
            }
        }
        return getSucReturnObject().toString();
    }

    @API(title = "开发端-系统应用注册-操作端删除", apiversion = R.ID10007801.v1.class)
    public String deleteSystemClient() throws YosException {
        long systemclientid = content.getLong("systemclientid");

        if (dbConnect.runSqlQuery("select * from sys_systemmodule where systemclientid=" + systemclientid).isNotEmpty()) {
            return getErrReturnObject().setErrMsg("操作端已被使用不可删除").toString();
        }
        dbConnect.runSqlUpdate("delete from sys_systemclient where systemclientid=" + systemclientid);
        return getSucReturnObject().toString();
    }


    @API(title = "开发端-系统应用注册-系统模块信息列表查询", apiversion = R.ID10007901.v1.class)
    public String querySystemModuleList() throws YosException {
        long systemclientid = content.getLong("systemclientid");
        Rows rows = dbConnect.runSqlQuery("select * from sys_systemmodule where systemclientid=" + systemclientid);
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "开发端-系统应用注册-系统模块信息新增修改", apiversion = R.ID10008001.v1.class)
    public String insertormodifySystemmodule() throws YosException {
        if (content.getBooleanValue("isasync")) {
            long systemclientid = content.getLong("systemclientid");
            long systemmoduleid = content.getLong("systemmoduleid");
            String systemmodule = content.getString("systemmodule");
            String systemmodulename = content.getString("systemmodulename");
            int isused = content.getIntValue("isused");

            if (dbConnect.runSqlQuery("select *from sys_systemclient where systemclientid=" + systemclientid).isEmpty()) {
                return getErrReturnObject().setErrMsg("操作端不存在").toString();
            }
            if (dbConnect.runSqlQuery("select * from sys_systemmodule where systemclientid=" + systemclientid + " and systemmodule='" + systemmodule + "'").isEmpty()) {
                SQLFactory sqlFactory = new SQLFactory(this, "系统模块新增");
                sqlFactory.addParameter("systemclientid", systemclientid);
                sqlFactory.addParameter("systemmoduleid", createTableID("sys_systemmodule"));
                sqlFactory.addParameter("systemmodule", systemmodule);
                sqlFactory.addParameter("systemmodulename", systemmodulename);
                sqlFactory.addParameter("isused", isused);
                dbConnect.runSqlUpdate(sqlFactory.getSQL());
            } else {
                dbConnect.runSqlUpdate("update sys_systemmodule set systemclientid='" + systemclientid + "', systemmodule='" + systemmodule + "',systemmodulename='" + systemmodulename + "',isused=" + isused + " where systemclientid=" + systemclientid + " and  systemmodule='" + systemmodule + "'");
            }
        } else {
            long systemclientid = content.getLong("systemclientid");
            long systemmoduleid = content.getLong("systemmoduleid");
            String systemmodule = content.getString("systemmodule");
            String systemmodulename = content.getString("systemmodulename");
            int isused = content.getIntValue("isused");

            if (dbConnect.runSqlQuery("select *from sys_systemclient where systemclientid=" + systemclientid).isEmpty()) {
                return getErrReturnObject().setErrMsg("操作端不存在").toString();
            }
            if (dbConnect.runSqlQuery("select * from sys_systemmodule where systemclientid=" + systemclientid + " and systemmodule='" + systemmodule + "'").isEmpty()) {
                SQLFactory sqlFactory = new SQLFactory(this, "系统模块新增");
                sqlFactory.addParameter("systemclientid", systemclientid);
                sqlFactory.addParameter("systemmoduleid", createTableID("sys_systemmodule"));
                sqlFactory.addParameter("systemmodule", systemmodule);
                sqlFactory.addParameter("systemmodulename", systemmodulename);
                sqlFactory.addParameter("isused", isused);
                dbConnect.runSqlUpdate(sqlFactory.getSQL());
            } else {
                dbConnect.runSqlUpdate("update sys_systemmodule set systemclientid='" + systemclientid + "', systemmodule='" + systemmodule + "',systemmodulename='" + systemmodulename + "',isused=" + isused + " where systemclientid=" + systemclientid + " and  systemmodule='" + systemmodule + "'");
            }
        }
        return getSucReturnObject().toString();
    }

    @API(title = "开发端-系统应用注册-模块删除", apiversion = R.ID10008101.v1.class)
    public String deleteSystemModule() throws YosException {
        long systemmoduleid = content.getLong("systemmoduleid");
        if (dbConnect.runSqlQuery("select * from sys_systemapp where systemmoduleid=" + systemmoduleid).isNotEmpty()) {
            return getErrReturnObject().setErrMsg("模块已被使用不可删除").toString();
        }
        dbConnect.runSqlUpdate("delete from sys_systemmodule where systemmoduleid=" + systemmoduleid);
        return getSucReturnObject().toString();
    }
}
