package beans.attachment;

import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.Controller;
import common.YosException;
import common.data.*;

import java.util.ArrayList;
import java.util.HashMap;

public class Attachment {

    /**
     * 获取指定表id的附件
     *
     * @param controller
     * @param ownertable
     * @param ownerid
     * @return
     * @throws YosException
     */
    public static Rows get(Controller controller, String ownertable, Long ownerid) throws YosException {
        return get(controller, ownertable, ownerid, null);
    }

    /**
     * 获取指定表多个id的附件
     *
     * @param controller
     * @param ownertable
     * @param ownerids
     * @return
     * @throws YosException
     */
    public static RowsMap get(Controller controller, String ownertable, ArrayList<Long> ownerids) throws YosException {
        return get(controller, ownertable, ownerids, null);
    }

    /**
     * 获取指定表id 且指定类型的附件
     *
     * @param controller
     * @param ownertable
     * @param ownerid
     * @param usetype
     * @return
     * @throws YosException
     */
    public static Rows get(Controller controller, String ownertable, Long ownerid, String usetype) throws YosException {
        ArrayList<Long> id = new ArrayList<>();
        id.add(ownerid);
        return get(controller, ownertable, id, usetype).getOrDefault(String.valueOf(ownerid), new Rows());
    }


    /**
     * 获取指定表多个id且指定类型的附件
     *
     * @param controller
     * @param ownertable
     * @param ownerids
     * @param usetype
     * @return
     * @throws YosException
     */
    public static RowsMap get(Controller controller, String ownertable, ArrayList<Long> ownerids, String usetype) throws YosException {
        QuerySQL querySQL = SQLFactory.createQuerySQL(controller, "sys_attachment_links", "linksid", "siteid", "ownerid", "ownertable", "usetype", "createdate", "attachmentid");
        querySQL.addJoinTable(BaseClass.JOINTYPE.inner, "sys_attachment", "sys_attachment", "siteid=:siteid and attachmentid=:attachmentid", "document", "postfix", "serialnumber", "url", "contentlength", "isfolder", "parentid");
        querySQL.setWhere("ownertable", ownertable);
        querySQL.setWhere("ownerid", ownerids);
        if (usetype != null) {
            querySQL.setWhere("usetype", usetype);
        }
        querySQL.setOrderBy("linksid");
        Rows rows = querySQL.query();

        if (rows.isNotEmpty()) {
            RowsMap subrowsmap = getSub(controller, rows.toArrayList("attachmentid", new ArrayList<>()));
            for (Row row : rows) {
                row.put("subfiles", subrowsmap.get(row.getString("attachmentid")));
            }
        }
        return rows.toRowsMap("ownerid");
    }

    /**
     * 获取指定的id的附件
     *
     * @param controller
     * @param attachmentid
     * @return
     * @throws YosException
     */
    public static Rows get(Controller controller, Long attachmentid) throws YosException {
        ArrayList<Long> id = new ArrayList<>();
        id.add(attachmentid);
        return get(controller, id);
    }

    /**
     * 获取指定的多个id的附件
     *
     * @param controller
     * @param attachmentids
     * @return
     * @throws YosException
     */
    public static Rows get(Controller controller, ArrayList<Long> attachmentids) throws YosException {
        QuerySQL querySQL = SQLFactory.createQuerySQL(controller, "sys_attachment_links", "linksid", "siteid", "ownerid", "ownertable", "usetype", "createdate", "attachmentid");
        querySQL.addJoinTable(BaseClass.JOINTYPE.inner, "sys_attachment", "sys_attachment", "siteid=:siteid and attachmentid=:attachmentid", "document", "postfix", "serialnumber", "url", "contentlength", "isfolder", "parentid");
        querySQL.setWhere("attachmentid", attachmentids);
        querySQL.setOrderBy("linksid");
        Rows rows = querySQL.query();
        if (rows.isNotEmpty()) {
            RowsMap subrowsmap = getSub(controller, attachmentids);
            for (Row row : rows) {
                row.put("subfiles", subrowsmap.get(row.getString("attachmentid")));
            }
        }
        return rows;
    }

    /**
     * 获取指定附件id的下级附件
     *
     * @param controller
     * @param attachmentid
     * @return
     * @throws YosException
     */
    public static Rows getSub(Controller controller, Long attachmentid) throws YosException {
        ArrayList<Long> id = new ArrayList<>();
        id.add(attachmentid);
        return getSub(controller, id).getOrDefault(String.valueOf(attachmentid), new Rows());
    }

    /**
     * 获取指定多个附件id的下级附件
     *
     * @param controller
     * @param attachmentids
     * @return
     * @throws YosException
     */
    public static RowsMap getSub(Controller controller, ArrayList<Long> attachmentids) throws YosException {
        QuerySQL querySQL = SQLFactory.createQuerySQL(controller, "sys_attachment", "attachmentid", "serialnumber", "url", "type", "contentlength", "parentid", "isfolder", "postfix", "document");
        querySQL.setWhere("parentid", attachmentids);
        querySQL.setOrderBy("attachmentid");
        Rows rows = querySQL.query();
        if (rows.isNotEmpty()) {
            RowsMap subrowsmap = getSub(controller, rows.toArrayList("attachmentid", new ArrayList<>()));
            for (Row row : rows) {
                row.put("subfiles", subrowsmap.get(row.getString("attachmentid")));
            }
        }
        return rows.toRowsMap("parentid");
    }

    public static void main(String[] args)throws YosException {
        System.err.println( Attachment.get(new Controller(new JSONObject()),38197L).toJsonArray());
    }

    /**
     * 获取指定表及id的附件数量
     *
     * @param controller
     * @param ownertable
     * @param ownerid
     * @return
     * @throws YosException
     */
    public static long getCount(Controller controller, String ownertable, Long ownerid) throws YosException {
        return getCount(controller, ownertable, ownerid, null);
    }

    /**
     * 获取指定表及id且指定类型的附件数量
     *
     * @param controller
     * @param ownertable
     * @param ownerid
     * @param usetype
     * @return
     * @throws YosException
     */
    public static long getCount(Controller controller, String ownertable, Long ownerid, String usetype) throws YosException {
        ArrayList<Long> id = new ArrayList<>();
        id.add(ownerid);
        return getCount(controller, ownertable, id, usetype).getOrDefault(ownerid, 0L);
    }

    /**
     * 获取指定表多个id的附件数量
     *
     * @param controller
     * @param ownertable
     * @param ownerid
     * @return
     * @throws YosException
     */
    public static HashMap<Long, Long> getCount(Controller controller, String ownertable, ArrayList<Long> ownerid) throws YosException {
        return getCount(controller, ownertable, ownerid, null);
    }

    /**
     * 获取指定表多个id且指定类型的附件数量
     *
     * @param controller
     * @param ownertable
     * @param ownerid
     * @param usetype
     * @return
     * @throws YosException
     */
    public static HashMap<Long, Long> getCount(Controller controller, String ownertable, ArrayList<Long> ownerid, String usetype) throws YosException {
        QuerySQL querySQL = SQLFactory.createQuerySQL(controller, "sys_attachment_links", "ownerid");
        querySQL.addQueryFields(" attachmentcount", "count(0)");
        querySQL.setWhere("ownertable", ownertable);
        querySQL.setWhere("ownerid", ownerid);
        if (usetype != null) {
            querySQL.setWhere("usetype", usetype);
        }
        querySQL.addGroupBy("ownerid");
        Rows rows = querySQL.query();
        HashMap<Long, Long> map = new HashMap<>();
        for (Row row : rows) {
            map.put(row.getLong("ownerid"), row.getLong("attachmentcount"));
        }
        return map;
    }

}
