package beans.remind;

import beans.parameter.Parameter;
import beans.user.User;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.Controller;
import common.YosException;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import common.parameter.parameter;
import common.websocket.WebSocket;
import utility.email.Email;
import utility.email.EmailContent;
import utility.sms.Sms;

import java.util.ArrayList;
import java.util.LinkedHashSet;

/**
 * 系统提醒公共方法，包括弹窗、短信、邮件等相关功能
 */
public class Remind {


    /**
     * 发送一个系统提醒,系统将自动判断发送的方式及自动生成发送的内容
     */
    public static void autoRemind(Controller controller, String remindname, long dataid) throws YosException {
        Rows sys_remind_configsRows = controller.dbConnect.runSqlQuery("select t2.ownertable,t1.remindtitle,t1.remindmode,t1.content,t1.isrole,t1.roleids,t1.isuser,t1.userids,t1.issql,t1.sqlstr from sys_remind_configs t1 " +
                "inner join sys_remind_config t2 on t1.sys_remind_configid=t2.sys_remind_configid where siteid='" + controller.siteid + "' and t2.remindname='" + remindname + "'");
        if (sys_remind_configsRows.isNotEmpty()) {
            String ownertable = sys_remind_configsRows.get(0).getString("ownertable");
            String remindtitle = sys_remind_configsRows.get(0).getString("remindtitle");
            JSONArray remindmodeArray = sys_remind_configsRows.get(0).getJSONArray("remindmode");
            String content = sys_remind_configsRows.get(0).getString("content");
            boolean isrole = sys_remind_configsRows.get(0).getBoolean("isrole");
            boolean isuser = sys_remind_configsRows.get(0).getBoolean("isuser");
            boolean issql = sys_remind_configsRows.get(0).getBoolean("issql");

            LinkedHashSet<Long> useridList = new LinkedHashSet<>();
            if (isrole) {
                JSONArray roleids = sys_remind_configsRows.get(0).getJSONArray("roleids");
                for (Object o : roleids) {
                    useridList.addAll(controller.dbConnect.runSqlQuery("select userid from sys_userrole where siteid='" + controller.siteid + "' and roleid=" + o).toArrayList("userid", new ArrayList<>()));
                }
            }
            if (isuser) {
                JSONArray userids = sys_remind_configsRows.get(0).getJSONArray("userids");
                for (Object o : userids) {
                    useridList.add(Long.parseLong(o.toString()));
                }
            }
            if (issql) {
                String sqlstr = sys_remind_configsRows.get(0).getString("sqlstr");
                if (sqlstr.contains(":")) {
                    Rows datarows = controller.dbConnect.runSqlQuery("select * from " + ownertable + " where " + controller.getuniquecolumnname(ownertable) + "=" + dataid);
                    if (datarows.isNotEmpty()) {
                        for (String key : datarows.get(0).keySet()) {
                            if (sqlstr.contains(":" + key)) {
                                sqlstr = sqlstr.replace(":" + key, "'" + datarows.get(0).getString(key) + "'");
                            }
                        }
                    }
                }
                try {
                    useridList.addAll(controller.dbConnect.runSqlQuery(sqlstr).toArrayList("userid", new ArrayList<>()));
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

            if (content.contains(":")) {
                Rows datarows = controller.dbConnect.runSqlQuery("select * from " + ownertable + " where " + controller.getuniquecolumnname(ownertable) + "=" + dataid);
                if (datarows.isNotEmpty()) {
                    for (String key : datarows.get(0).keySet()) {
                        if (content.contains(":" + key)) {
                            content = content.replace(":" + key, "'" + datarows.get(0).getString(key) + "'");
                        }
                    }
                }
            }
            int max = 10;
            while (content.contains("{") && content.contains("}")) {
                int start = content.indexOf("{");
                int end = content.indexOf("}");
                String parm = content.substring(start, end + 1);
                String sql = parm.replace("{", "").replace("}", "");
                Rows rows = controller.dbConnect.runSqlQuery(sql);
                if (rows.size() != 1 || rows.getFieldList().size() != 1) {
                    break;
                } else {
                    String value = rows.get(0).getString(rows.getFieldList().get(0));
                    content = content.replace(parm, value);
                }
                if (max-- == 0) {
                    break;
                }
            }

            for (Object o : remindmodeArray) {
                String remindmode = (String) o;
                switch (remindmode) {
                    case "邮件": {
                        for (Long userid : useridList) {
                            try {
                                EmailContent emailContent = new EmailContent();
                                emailContent.addText(content);
                                Remind remind = new Remind(controller);
                                remind.setTitle(remindtitle);
                                remind.setToemail(User.getUserMailAddress(controller, userid));
                                remind.setContent(emailContent);
                                remind.sendByMail();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        break;
                    }
                    case "短信": {
                        for (Long userid : useridList) {
                            try {
                                Remind remind = new Remind(controller);
                                remind.setContent(content);
                                remind.setTophonenumber(User.getUserPhonenumber(controller, userid));
                                remind.sendBySms();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        break;
                    }
                    case "弹框": {
                        for (Long userid : useridList) {
                            try {
                                Remind remind = new Remind(controller);
                                remind.setTitle(remindtitle);
                                remind.setContent(content);
                                remind.setTouserid(userid);
                                remind.setTophonenumber(User.getUserPhonenumber(controller, userid));
                                remind.sendByDialogMsg();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        break;
                    }
                }
            }
        }
    }


    /**
     * 发送一个提醒规则绑定在数据上的系统提醒
     */
    public static void autoDataRemind(String remindname, String ownertable, long dataid) throws YosException {
        DBConnect dbConnect = new DBConnect();
        Rows sys_remind_configsRows = dbConnect.runSqlQuery("select t2.ownertable,t1.remindtitle,t1.remindmode,t1.content,t1.isrole,t1.roleids,t1.isuser,t1.userids,t1.issql,t1.sqlstr,t1.siteid from sys_remind_configs t1 " +
                "inner join sys_remind_config t2 on t1.sys_remind_configid=t2.sys_remind_configid where t2.remindname='" + remindname + "' and t2.ownertable='" + ownertable + "' and t1.ownerid='" + dataid + "'");
        if (sys_remind_configsRows.isNotEmpty()) {
            String remindtitle = sys_remind_configsRows.get(0).getString("remindtitle");
            JSONArray remindmodeArray = sys_remind_configsRows.get(0).getJSONArray("remindmode");
            String content = sys_remind_configsRows.get(0).getString("content");
            String siteid = sys_remind_configsRows.get(0).getString("siteid");
            boolean isrole = sys_remind_configsRows.get(0).getBoolean("isrole");
            boolean isuser = sys_remind_configsRows.get(0).getBoolean("isuser");
            boolean issql = sys_remind_configsRows.get(0).getBoolean("issql");

            LinkedHashSet<Long> useridList = new LinkedHashSet<>();
            if (isrole) {
                JSONArray roleids = sys_remind_configsRows.get(0).getJSONArray("roleids");
                for (Object o : roleids) {
                    useridList.addAll(dbConnect.runSqlQuery("select userid from sys_userrole where siteid='" + siteid + "' and roleid=" + o).toArrayList("userid", new ArrayList<>()));
                }
            }
            if (isuser) {
                JSONArray userids = sys_remind_configsRows.get(0).getJSONArray("userids");
                for (Object o : userids) {
                    useridList.add(Long.parseLong(o.toString()));
                }
            }
            if (issql) {
                String sqlstr = sys_remind_configsRows.get(0).getString("sqlstr");
                if (sqlstr.contains(":")) {
                    Rows datarows = dbConnect.runSqlQuery("select * from " + ownertable + " where " + new BaseClass().getuniquecolumnname(ownertable) + "=" + dataid);
                    if (datarows.isNotEmpty()) {
                        for (String key : datarows.get(0).keySet()) {
                            if (sqlstr.contains(":" + key)) {
                                sqlstr = sqlstr.replace(":" + key, "'" + datarows.get(0).getString(key) + "'");
                            }
                        }
                    }
                }
                try {
                    useridList.addAll(dbConnect.runSqlQuery(sqlstr).toArrayList("userid", new ArrayList<>()));
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

            if (content.contains(":")) {
                Rows datarows = dbConnect.runSqlQuery("select * from " + ownertable + " where " + new BaseClass().getuniquecolumnname(ownertable) + "=" + dataid);
                if (datarows.isNotEmpty()) {
                    for (String key : datarows.get(0).keySet()) {
                        if (content.contains(":" + key)) {
                            content = content.replace(":" + key, "'" + datarows.get(0).getString(key) + "'");
                        }
                    }
                }
            }
            int max = 10;
            while (content.contains("{") && content.contains("}")) {
                int start = content.indexOf("{");
                int end = content.indexOf("}");
                String parm = content.substring(start, end + 1);
                String sql = parm.replace("{", "").replace("}", "");
                Rows rows = dbConnect.runSqlQuery(sql);
                if (rows.size() != 1 || rows.getFieldList().size() != 1) {
                    break;
                } else {
                    String value = rows.get(0).getString(rows.getFieldList().get(0));
                    content = content.replace(parm, value);
                }
                if (max-- == 0) {
                    break;
                }
            }

            for (Object o : remindmodeArray) {
                String remindmode = (String) o;
                switch (remindmode) {
                    case "邮件": {
                        for (Long userid : useridList) {
                            try {
                                EmailContent emailContent = new EmailContent();
                                emailContent.addText(content);
                                Remind remind = new Remind(siteid);
                                remind.setTitle(remindtitle);
                                remind.setToemail(User.getUserMailAddress(dbConnect, siteid, userid));
                                remind.setContent(emailContent);
                                remind.sendByMail();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        break;
                    }
                    case "短信": {
                        for (Long userid : useridList) {
                            try {
                                Remind remind = new Remind(siteid);
                                remind.setContent(content);
                                remind.setTophonenumber(User.getUserPhonenumber(dbConnect, userid));
                                remind.sendBySms();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        break;
                    }
                    case "弹框": {
                        for (Long userid : useridList) {
                            try {
                                Remind remind = new Remind(siteid);
                                remind.setTitle(remindtitle);
                                remind.setContent(content);
                                remind.setTouserid(userid);
                                remind.setTophonenumber(User.getUserPhonenumber(dbConnect, userid));
                                remind.sendByDialogMsg();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    private String type = "";
    private String title = "";
    private String content = "";
    private ArrayList<String> tophonenumber = new ArrayList<>();
    private ArrayList<String> toemail = new ArrayList<>();
    private String objectname = "null";
    private Long objectid = 0L;
    private Controller controller;
    private String siteid = "";
    private ArrayList<Long> touserid = new ArrayList<>();
    private EmailContent emailContent = null;

    public Remind(Controller controller) {
        this.controller = controller;
        this.siteid = this.controller.siteid;
    }

    public Remind(String siteid) throws YosException {
        this.siteid = siteid;
        JSONObject object = new JSONObject();
        object.put("siteid", siteid);
        this.controller = new Controller(object);
        this.controller.siteid = this.siteid;
    }

    /**
     * 提醒标题，必填
     *
     * @param title
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * 提醒内容，非邮件提醒时必填。
     *
     * @param content
     */
    public void setContent(String content) {
        this.content = content;
    }

    /**
     * 邮件提醒内容。content和EmailContent 必填其一
     *
     * @param emailContent
     */
    public void setContent(EmailContent emailContent) {
        this.emailContent = emailContent;
    }

    /**
     * 短信发送对象。短信方式发送时必填
     *
     * @param phonenumber
     */
    public void setTophonenumber(String phonenumber) {
        this.tophonenumber.add(phonenumber);
    }

    /**
     * 短信发送对象。短信方式发送时必填
     *
     * @param tophonenumber
     */
    public void setTophonenumber(ArrayList<String> tophonenumber) {
        this.tophonenumber = tophonenumber;
    }

    /**
     * 邮件发送对象。邮件发送时必填
     *
     * @param toemail
     */
    public void setToemail(String toemail) {
        this.toemail.add(toemail);
    }

    /**
     * 邮件发送对象。邮件发送时必填
     *
     * @param toemail
     */
    public void setToemail(ArrayList<String> toemail) {
        this.toemail = toemail;
    }

    /**
     * 邮件发送对象。邮件发送时必填
     *
     * @param userid
     */
    public void setToemail(Long userid) throws YosException {
        this.toemail = User.getUserMailAddress(controller, userid);
    }

    public void setObjectname(String objectname) {
        this.objectname = objectname;
    }

    public void setObjectid(Long objectid) {
        this.objectid = objectid;
    }

    /**
     * 弹框发送对象
     *
     * @param userid
     */
    public void setTouserid(ArrayList<Long> userid) {
        this.touserid = userid;
    }

    /**
     * 弹框发送对象
     *
     * @param userid
     */
    public void setTouserid(long userid) {
        this.touserid.add(userid);
    }


    /**
     * 消息类型 应用、系统
     *
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * 邮件发送
     *
     * @throws YosException
     */
    public Remind sendByMail() throws YosException {
        if (!Parameter.get(siteid, "remind_mail").equalsIgnoreCase("1")) {
            return this;
        }
        if (siteid.equals("") || title.equals("") || toemail.size() == 0 || (emailContent == null && content.equals(""))) {
            return this;
        }
        try {
            Email email = new Email(siteid, title, toemail);
            if (emailContent == null) {
                EmailContent content = new EmailContent();
                content.addText(title);
                content.addBr();
                content.addText(this.content);
                email.send(siteid, content);
            } else {
                email.send(siteid, emailContent);
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new YosException(e.toString());
        }
        return this;
    }

    /**
     * 短信发送
     */
    public Remind sendBySms() throws YosException {
        if (siteid.equals("") || content.equals("") || tophonenumber.size() == 0) {
            return this;
        }
        for (String phonenumber : tophonenumber) {
            Sms sms = new Sms();
            sms.sendout(siteid, phonenumber, content);
        }
        return this;
    }

    /**
     * 弹窗发送
     *
     * @return
     * @throws YosException
     */
    public Remind sendByDialogMsg() throws YosException {
        if (type.equals("") || title.equals("") || content.equals("") || touserid.size() == 0) {
            return this;
        }

        for (Long userid : touserid) {
            for (long usersiteid : User.getUserSiteid(controller, userid)) {
                if (parameter.websocketClients.containsKey(usersiteid)) {
                    JSONObject methodobject = new JSONObject();
                    methodobject.put("class", "remind");//提醒
                    methodobject.put("type", type);//消息类型
                    methodobject.put("title", title);
                    methodobject.put("text", content);
                    for (WebSocket webClientSocket : parameter.websocketClients.get(usersiteid).values()) {
                        webClientSocket.sendSystemMessage(methodobject);
                    }
                }
            }
        }
        return this;
    }

    /**
     * 系统消息生成
     *
     * @throws YosException
     */
    public void createSys_message() throws YosException {
        if (siteid.equals("") || type.equals("") || title.equals("") || content.equals("") || touserid.size() == 0) {
            return;
        }
        for (Long userid : touserid) {
            SQLFactory factory = new SQLFactory("系统消息插入");
            factory.addParameter("siteid", siteid);
            factory.addParameter("type", type);
            factory.addParameter("title", title);
            factory.addParameter("message", content);
            factory.addParameter("userid", userid);
            factory.addParameter("objectid", objectid == 0 ? "null" : objectid);
            factory.addParameter("objectname", objectname);
            controller.dbConnect.runSqlUpdate(factory.getSQL());
        }
    }
}
