/**
 *
 */
package common.data.db;

import common.BaseClass;
import common.api.YOSAPI;
import common.data.Row;
import common.data.Rows;

import java.util.Calendar;
import java.util.Hashtable;

/**
 * @author Administrator
 *
 */
public class DataPool extends BaseClass {
    // 数据缓存池
    //请求体，返回体<datakey,data>
    public static Hashtable<String, Object> datapool = new Hashtable<>();

    /**
     * 从缓存中获取数据
     * @param datakey
     * @return
     */
    public static Object get(String datakey) {
        Object data = null;
        Rows rows = SQLiteMemory.runSqlQuery("select endtimeinmillis from apidatapool where datakey='" + datakey + "'");
        if (rows.isNotEmpty()) {
            if (rows.get(0).getLong("endtimeinmillis") > Calendar.getInstance().getTimeInMillis() && DataPool.datapool.containsKey(datakey)) {
                data = DataPool.datapool.get(datakey);
            } else {
                remove(datakey);
            }
        }
        DataClean();
        return data;
    }

    /**
     * 从缓存中获取数据
     * @param yosRequest
     * @return
     */
    public static Object get(YOSAPI.YosRequest yosRequest) {
        return get(yosRequest.getRequestKey());
    }

    /**
     * 将接口响应数据添加到缓存中
     * @param yosRequest
     * @param result
     */
    public static void put(YOSAPI.YosRequest yosRequest, Object result, int datalife) {
        //将数据加入缓存
        DataPool.datapool.put(yosRequest.getRequestKey(), result);
        //奖缓存信息存入缓存数据库
        SQLiteTableData sqLiteTableData = new SQLiteTableData(SQLiteTable.getTable("apidatapool"));
        sqLiteTableData.set("datakey", yosRequest.getRequestKey());
        sqLiteTableData.set("accesstoken", yosRequest.getAccesstoken());
        Row userRow = yosRequest.getUserRow();
        if (userRow != null) {
            sqLiteTableData.set("userid", userRow.getLong("userid"));
            sqLiteTableData.set("siteid", userRow.getString("siteid"));
        } else {
            sqLiteTableData.set("userid", 0);
            sqLiteTableData.set("siteid", "");
        }
        sqLiteTableData.set("endtimeinmillis", Calendar.getInstance().getTimeInMillis() + ((long) datalife * 60000));
        sqLiteTableData.set("classpath", yosRequest.getClasspath());
        sqLiteTableData.set("method", yosRequest.getMethodname());
        sqLiteTableData.insert();
    }

    /**
     * 将指定的数据添加到缓存中，仅通过datakey进行获取
     * @param datakey
     * @param data
     */
    public static void put(String datakey, Object data, int datalife) {
        //将数据加入缓存
        DataPool.datapool.put(datakey, data);
        //奖缓存信息存入缓存数据库
        SQLiteTableData sqLiteTableData = new SQLiteTableData(SQLiteTable.getTable("apidatapool"));
        sqLiteTableData.set("datakey", datakey);
        sqLiteTableData.set("accesstoken", "");
        sqLiteTableData.set("userid", 0);
        sqLiteTableData.set("siteid", "");
        sqLiteTableData.set("endtimeinmillis", Calendar.getInstance().getTimeInMillis() + ((long) datalife * 60000));
        sqLiteTableData.set("classpath", "");
        sqLiteTableData.set("method", "");
        sqLiteTableData.insert();
    }

    /**
     * 移除指定的缓存
     * @param datakey
     */
    public static void remove(String datakey) {
        synchronized (DataPool.class) {
            SQLiteMemory.runSqlUpdate("delete from apidatapool where datakey='" + datakey + "' or endtimeinmillis<" + Calendar.getInstance().getTimeInMillis());
            DataPool.datapool.remove(datakey);
        }
    }

    /**
     * 移除指定token下 指定接口的缓存
     * @param accesstoken
     * @param classpath
     * @param method
     */
    public static void remove(String accesstoken, String classpath, String method) {
        synchronized (DataPool.class) {
            Rows rows = SQLiteMemory.runSqlQuery("select datakey from apidatapool where (accesstoken='" + accesstoken + "' and classpath='" + classpath + "' and method='" + method + "') or endtimeinmillis<" + Calendar.getInstance().getTimeInMillis());
            for (Row row : rows) {
                String datakey = row.getString("datakey");
                SQLiteMemory.runSqlUpdate("delete from apidatapool where datakey='" + datakey + "'");
                DataPool.datapool.remove(datakey);
            }
        }
    }

    /**
     * 移除指定token下 指定接口的缓存
     * @param userid
     * @param classpath
     * @param method
     */
    public static void remove(long userid, String classpath, String method) {
        synchronized (DataPool.class) {
            Rows rows = SQLiteMemory.runSqlQuery("select datakey from apidatapool where (userid='" + userid + "' and classpath='" + classpath + "' and method='" + method + "') or endtimeinmillis<" + Calendar.getInstance().getTimeInMillis());
            for (Row row : rows) {
                String datakey = row.getString("datakey");
                SQLiteMemory.runSqlUpdate("delete from apidatapool where datakey='" + datakey + "'");
                DataPool.datapool.remove(datakey);
            }
        }
    }

    /**
     * 移除指定token下 指定类的缓存
     * @param accesstoken
     * @param classpath
     */
    public static void remove(String accesstoken, String classpath) {
        synchronized (DataPool.class) {
            Rows rows = SQLiteMemory.runSqlQuery("select datakey from apidatapool where (accesstoken='" + accesstoken + "' and classpath='" + classpath + "') or endtimeinmillis<" + Calendar.getInstance().getTimeInMillis());
            for (Row row : rows) {
                String datakey = row.getString("datakey");
                SQLiteMemory.runSqlUpdate("delete from apidatapool where datakey='" + datakey + "'");
                DataPool.datapool.remove(datakey);
            }
        }
    }

    /**
     * 移除指定token下 指定类的缓存
     * @param userid
     * @param classpath
     */
    public static void remove(long userid, String classpath) {
        synchronized (DataPool.class) {
            Rows rows = SQLiteMemory.runSqlQuery("select datakey from apidatapool where (userid='" + userid + "' and classpath='" + classpath + "') or endtimeinmillis<" + Calendar.getInstance().getTimeInMillis());
            for (Row row : rows) {
                String datakey = row.getString("datakey");
                SQLiteMemory.runSqlUpdate("delete from apidatapool where datakey='" + datakey + "'");
                DataPool.datapool.remove(datakey);
            }
        }
    }

    /**
     * 移除指定站点下的所有缓存
     * @param siteid
     */
    public static void removeBySiteid(String siteid) {
        synchronized (DataPool.class) {
            SQLiteMemory.runSqlUpdate("delete from apidatapool where siteid='" + siteid + "' or endtimeinmillis<" + Calendar.getInstance().getTimeInMillis());
            DataPool.datapool.remove(siteid);
        }
    }

    /**
     * 移除指定站点类下的所有缓存
     * @param classpath
     */
    public static void removeByClassPath(String siteid, String classpath) {
        synchronized (DataPool.class) {
            Rows rows = SQLiteMemory.runSqlQuery("select datakey from apidatapool where (siteid='" + siteid + "' and classpath='" + classpath + "') or endtimeinmillis<" + Calendar.getInstance().getTimeInMillis());
            for (Row row : rows) {
                String datakey = row.getString("datakey");
                SQLiteMemory.runSqlUpdate("delete from apidatapool where datakey='" + datakey + "'");
                DataPool.datapool.remove(datakey);
            }
        }
    }

    /**
     * 移除指定类下的所有缓存
     * @param classpath
     */
    public static void removeByClassPath(String classpath) {
        synchronized (DataPool.class) {
            Rows rows = SQLiteMemory.runSqlQuery("select datakey from apidatapool where  classpath='" + classpath + "' or endtimeinmillis<" + Calendar.getInstance().getTimeInMillis());
            for (Row row : rows) {
                String datakey = row.getString("datakey");
                SQLiteMemory.runSqlUpdate("delete from apidatapool where datakey='" + datakey + "'");
                DataPool.datapool.remove(datakey);
            }
        }
    }

    /**
     * 移除指定token下所有的缓存
     * @param accesstoken
     */
    public static void removeByAccesstoken(String accesstoken) {
        synchronized (DataPool.class) {
            Rows rows = SQLiteMemory.runSqlQuery("select datakey from apidatapool where accesstoken='" + accesstoken + "' or endtimeinmillis<" + Calendar.getInstance().getTimeInMillis());
            for (Row row : rows) {
                String datakey = row.getString("datakey");
                SQLiteMemory.runSqlUpdate("delete from apidatapool where datakey='" + datakey + "'");
                DataPool.datapool.remove(datakey);
            }
        }
    }

    /**
     * 清除指定账号下的所有的缓存
     * @param userid
     */
    public static void removeByUserid(long userid) {
        synchronized (DataPool.class) {
            Rows rows = SQLiteMemory.runSqlQuery("select datakey from apidatapool where userid='" + userid + "' or endtimeinmillis<" + Calendar.getInstance().getTimeInMillis());
            for (Row row : rows) {
                String datakey = row.getString("datakey");
                SQLiteMemory.runSqlUpdate("delete from apidatapool where datakey='" + datakey + "'");
                DataPool.datapool.remove(datakey);
            }
        }
    }

    private static int cleanday = Calendar.getInstance().get(Calendar.DATE);

    /**
     * 每天全清一次缓存信息
     */
    private static void DataClean() {
        synchronized (DataPool.class) {
            int today = Calendar.getInstance().get(Calendar.DATE);
            if (cleanday != today) {
                DataPool.datapool.clear();
                SQLiteMemory.runSqlUpdate("delete from apidatapool");
                cleanday = today;
            }
        }
    }
}
