package common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.api.YOSAPI;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.db.DataPool;

public class Sorting extends BaseClass {
    JSONArray sortArray;
    long sortedid = 0;
    boolean sorted_reversed = false;
    boolean isinit = false;

    String classname = "";
    String method = "";
    String datakey = "";

    Rows sortrows;
    Controller controller;

    public Sorting(Controller controller, YOSAPI yosapi) throws YosException {
        this.controller = controller;
        if (this.controller.content.containsKey("sort")) {
            this.sortArray = this.controller.content.getJSONArray("sort");
        } else {
            this.sortArray = new JSONArray();
        }
        this.classname = yosapi.getClazz().getName();
        this.method = yosapi.getMethod().getName();
        datakey = "sort:" + this.classname + "." + method;
    }

    private void init() throws YosException {
        if (!isinit) {
//            StackTraceElement[] stackTrace = new Exception().getStackTrace();
//            String classname = stackTrace[2].getClassName();
//            String methodname = stackTrace[2].getMethodName();
            Object object = DataPool.get(datakey);
            if (object == null) {
                sortrows = dbConnect.runSqlQuery("select t2.sortid,t2.sortname,t2.sortsql,t2.sorted from sys_listsortscheme t1 " +
                        "inner join sys_listsortschememx t2 on t1.sys_listsortschemeid=t2.sys_listsortschemeid " +
                        "where t1.methodpath='" + classname + "." + method + "'");
                DataPool.put(datakey, sortrows, 1440);
            } else {
                sortrows = (Rows) object;
            }
            isinit = true;
        }
    }


    /**
     * 获取本次排序方案
     */
    public String getOrderBy() throws YosException {
        init();
        RowsMap sortrowsmap = sortrows.toRowsMap("sortid");
        for (Object o : sortArray) {
            JSONObject sortObject = (JSONObject) o;
            long sortid = sortObject.getLong("sortid");
            boolean sorted = sortObject.getBooleanValue("sorted");
            boolean reversed = sortObject.getBoolean("reversed");
            if (sorted && sortid > 0 && sortrowsmap.containsKey(String.valueOf(sortid))) {
                sortedid = sortid;
                String sortsql = sortrowsmap.get(String.valueOf(sortid)).get(0).getString("sortsql");
                if (reversed) {
                    sorted_reversed = true;
                    sortsql = reversed(sortsql);
                }
                return sortsql;
            }
        }
        //如果前端没有指定在，则按照默认排序进行
        RowsMap defaultsortrowsmap = sortrows.toRowsMap("sorted");
        if (defaultsortrowsmap.containsKey("1")) {
            sortedid = defaultsortrowsmap.get("1").get(0).getLong("sortid");
            return defaultsortrowsmap.get("1").get(0).getString("sortsql");
        }
        return "''";
    }


    /**
     * 获取所有排序方案
     */
    public JSONArray getSorts() {
        JSONArray array = new JSONArray();
        for (Row sortrow : sortrows) {
            JSONObject sortObject = new JSONObject();
            sortObject.put("sortname", sortrow.getString("sortname"));
            sortObject.put("sortid", sortrow.getLong("sortid"));
            sortObject.put("sorted", sortrow.getLong("sortid") == sortedid ? 1 : 0);
            sortObject.put("reversed", sortrow.getLong("sortid") == sortedid ? (sorted_reversed ? 1 : 0) : 0);
            array.add(sortObject);
        }
        if (array.isEmpty()) {
            JSONObject sortObject = new JSONObject();
            sortObject.put("sortname", "默认");
            sortObject.put("sortid", 0);
            sortObject.put("sorted", 1);
            sortObject.put("reversed", 0);
            array.add(sortObject);
        }
        return array;
    }

    private String reversed(String orderbysql) {
        orderbysql = orderbysql.replace("asc", "$a$");
        orderbysql = orderbysql.replace("desc", "$d$");
        orderbysql = orderbysql.replace("$a$", "desc");
        orderbysql = orderbysql.replace("$d$", "asc");
        return orderbysql;
    }
}
