/*
 * Decompiled with CFR 0.152.
 */
package common.data;

import common.Controller;
import common.YosException;
import common.data.BaseSQL;
import common.data.QuerySQL;
import common.data.Row;
import common.data.Rows;
import common.data.db.DBConnect;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;

public class InsertSQL
extends BaseSQL<InsertSQL> {
    private HashMap<String, Object> keyvaluemap;
    private int effectrows = -1;
    private Row row = null;

    protected InsertSQL(Controller controller, String tablename) throws YosException {
        super(controller, tablename);
    }

    protected InsertSQL(DBConnect dbConnect, String tablename) throws YosException {
        super(dbConnect, tablename);
    }

    @Override
    public InsertSQL setSiteid(String siteid) {
        this.setValue("siteid", siteid);
        return this;
    }

    @Override
    public InsertSQL setUniqueid(long uniqueid) {
        this.setValue(this.uniquecolumnname, uniqueid);
        return this;
    }

    public InsertSQL setValue(String key, Object value) {
        if (this.keyvaluemap == null) {
            this.keyvaluemap = new HashMap();
        }
        this.keyvaluemap.put(key.toLowerCase(), value);
        return this;
    }

    public InsertSQL setValue(String key, StringBuffer value) {
        if (this.keyvaluemap == null) {
            this.keyvaluemap = new HashMap();
        }
        this.keyvaluemap.put(key.toLowerCase(), value.toString());
        return this;
    }

    public InsertSQL setValue(String key, boolean value) {
        if (this.keyvaluemap == null) {
            this.keyvaluemap = new HashMap();
        }
        this.keyvaluemap.put(key.toLowerCase(), value ? 1 : 0);
        return this;
    }

    public InsertSQL setDateValue(String key) {
        if (this.keyvaluemap == null) {
            this.keyvaluemap = new HashMap();
        }
        this.keyvaluemap.put(key.toLowerCase(), Date.class);
        return this;
    }

    public InsertSQL copy(long sourceid, String ... excludeFields) throws YosException {
        QuerySQL querySQL = new QuerySQL(this.dbConnect, this.tablename);
        querySQL.setUniqueid(sourceid);
        Rows rows = querySQL.query();
        if (rows.isNotEmpty()) {
            ArrayList<String> excludeFieldList = new ArrayList<String>(Arrays.asList(excludeFields));
            excludeFieldList.add(this.uniquecolumnname);
            excludeFieldList.add("createby");
            excludeFieldList.add("createdate");
            excludeFieldList.add("createuserid");
            excludeFieldList.add("changeby");
            excludeFieldList.add("changedate");
            excludeFieldList.add("changeuserid");
            excludeFieldList.add("rowindex");
            Row row = rows.getRow(0);
            for (String fieldname : row.keySet()) {
                if (excludeFieldList.contains(fieldname)) continue;
                this.setValue(fieldname, row.get(fieldname));
            }
        }
        return this;
    }

    public InsertSQL copy(String sourceobject, long sourceid, String ... copyfields) throws YosException {
        QuerySQL querySQL = new QuerySQL(this.dbConnect, sourceobject);
        querySQL.setUniqueid(sourceid);
        Rows sourceRows = querySQL.query();
        if (sourceRows.isNotEmpty()) {
            Row sourceRow = sourceRows.getRow(0);
            Set rowketSet = sourceRow.keySet();
            for (String fieldname : copyfields) {
                if (fieldname.contains(":")) {
                    String[] fs = fieldname.split(":");
                    this.setValue(fs[1], sourceRow.get(fs[0]));
                    continue;
                }
                if (!rowketSet.contains(fieldname)) continue;
                this.setValue(fieldname, sourceRow.get(fieldname));
            }
        }
        return this;
    }

    public String getSQL() throws YosException {
        this.addDefaultField();
        StringBuilder headsql = new StringBuilder("insert into ").append(this.tablename).append("(");
        StringBuilder valuesql = new StringBuilder("select ");
        boolean isfirstfield = true;
        if (!this.keyvaluemap.containsKey(this.uniquecolumnname)) {
            this.keyvaluemap.put(this.uniquecolumnname, this.createTableID(this.tablename));
        }
        for (String fieldname : this.keyvaluemap.keySet()) {
            Object value = this.keyvaluemap.get(fieldname);
            if (value == null || "null".equalsIgnoreCase(value.toString())) {
                headsql.append(isfirstfield ? "" : ",").append(fieldname);
                valuesql.append(isfirstfield ? "" : ",").append("NULL");
            } else {
                headsql.append(isfirstfield ? "" : ",").append(fieldname);
                if (value == Date.class) {
                    valuesql.append(isfirstfield ? "now()" : ",now()");
                } else if (value instanceof Date || value instanceof Calendar) {
                    Date date;
                    Date date2 = date = value instanceof Date ? (Date)value : ((Calendar)value).getTime();
                    if ("date".equals(this.getColumnType(this.tablename, fieldname))) {
                        valuesql.append(isfirstfield ? "" : ",").append("'").append(InsertSQL.getDate_Str(date)).append("'");
                    } else {
                        valuesql.append(isfirstfield ? "" : ",").append("'").append(InsertSQL.getDateTime_Str(date)).append("'");
                    }
                } else {
                    valuesql.append(isfirstfield ? "" : ",").append("'").append(value).append("'");
                }
            }
            isfirstfield = false;
        }
        headsql.append(")\r\n").append((CharSequence)valuesql);
        if (!this.wherelist.isEmpty()) {
            headsql.append("\r\nwhere ");
            boolean isfirstwhere = true;
            for (String where : this.wherelist) {
                headsql.append(isfirstwhere ? "(" : " and (").append(this.parameterDo(where)).append(")");
                isfirstwhere = false;
            }
        }
        return headsql.toString();
    }

    private void addDefaultField() throws YosException {
        ArrayList<String> list = this.getTableColumnNames(this.tablename);
        if (this.controller != null) {
            if (list.contains("changeuserid") && !this.keyvaluemap.containsKey("changeuserid")) {
                this.setValue("changeuserid", this.controller.userid);
            }
            if (list.contains("createuserid") && !this.keyvaluemap.containsKey("createuserid")) {
                this.setValue("createuserid", this.controller.userid);
            }
            if (list.contains("createby") && !this.keyvaluemap.containsKey("createby")) {
                this.setValue("createby", this.controller.username);
            }
            if (list.contains("changeby") && !this.keyvaluemap.containsKey("changeby")) {
                this.setValue("changeby", this.controller.username);
            }
            if (list.contains("siteid") && !this.keyvaluemap.containsKey("siteid")) {
                this.setValue("siteid", this.controller.siteid);
            }
        }
        if (list.contains("changedate") && !this.keyvaluemap.containsKey("changedate")) {
            this.setDateValue("changedate");
        }
        if (list.contains("createdate") && !this.keyvaluemap.containsKey("createdate")) {
            this.setDateValue("createdate");
        }
    }

    public int insert() throws YosException {
        if (this.effectrows == -1) {
            this.effectrows = this.dbConnect.runSqlUpdate(this.getSQL());
        }
        return this.effectrows;
    }

    public long getUniqueid() {
        return (Long)this.keyvaluemap.getOrDefault(this.uniquecolumnname, 0L);
    }

    public Row getRow() throws YosException {
        if (this.row == null) {
            if (this.effectrows == -1) {
                this.insert();
            }
            StringBuilder querySql = new StringBuilder("select * from ").append(this.tablename).append(" where ( 1=1 ) ");
            if (this.keyvaluemap.containsKey(this.uniquecolumnname)) {
                Rows rows;
                querySql.append(" and ").append(this.uniquecolumnname).append("=").append(this.keyvaluemap.get(this.uniquecolumnname));
                if (this.keyvaluemap.containsKey("siteid")) {
                    querySql.append(" and siteid='").append(this.keyvaluemap.get("siteid")).append("'");
                }
                if ((rows = this.dbConnect.runSqlQuery(querySql.toString())).size() == 1) {
                    this.row = rows.get(0);
                }
            }
        }
        return this.row == null ? new Row() : this.row;
    }
}

