/*
 * Decompiled with CFR 0.152.
 */
package utility.nuonuo;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.YosException;
import java.util.List;
import java.util.UUID;
import nuonuo.open.sdk.NNOpenSDK;
import utility.nuonuo.pojo.BlueInvoiceMsg;
import utility.nuonuo.pojo.InvoiceDetailMsg;
import utility.nuonuo.pojo.RedInvoiceMsg;

public class OpenApi
extends BaseClass {
    private boolean isused(String siteid) throws YosException {
        String bank_bbc_used = Parameter.get(siteid, "nuonuo_invoice_used");
        return bank_bbc_used.equals("1");
    }

    public JSONObject queryInvoiceResult(String siteid, String serialNo) throws YosException {
        JSONObject contentObject = new JSONObject();
        contentObject.put("isOfferInvoiceDetail", (Object)"1");
        JSONArray serialNosArray = new JSONArray();
        serialNosArray.add((Object)serialNo);
        contentObject.put("serialNos", (Object)serialNosArray);
        JSONObject resultObject = this.requestApi(siteid, "nuonuo.ElectronInvoice.queryInvoiceResult", contentObject.toString());
        System.out.println("\u53d1\u7968\u67e5\u8be2\u7ed3\u679c\uff1a" + resultObject);
        if (resultObject.getString("code").equalsIgnoreCase("E0000")) {
            JSONArray resultJsonArray = resultObject.getJSONArray("result");
            for (Object o : resultJsonArray) {
                JSONObject resultJsonObject = (JSONObject)o;
                String status = resultJsonObject.getString("status");
                if (!status.equals("2")) continue;
                String pdfUrl = resultJsonObject.getString("pdfUrl");
                String paperPdfUrl = resultJsonObject.getString("paperPdfUrl");
                String invoiceCode = resultObject.getString("invoiceCode");
                String invoiceNo = resultObject.getString("invoiceNo");
                System.out.println("\u53d1\u7968\u5730\u5740" + pdfUrl);
                System.out.println("?\u7eb8\u8d28\u53d1\u7968\u5730\u5740?" + paperPdfUrl);
                System.out.println(invoiceCode);
                System.out.println(invoiceNo);
            }
        }
        return resultObject;
    }

    public void createBlueInvoice(String siteid, BlueInvoiceMsg blueInvoiceMsg) throws YosException {
        JSONObject orderObject = new JSONObject();
        orderObject.put("buyerName", (Object)blueInvoiceMsg.getBuyerName());
        orderObject.put("buyerTaxNum", (Object)blueInvoiceMsg.getBuyerTaxNum());
        orderObject.put("buyerTel", (Object)blueInvoiceMsg.getBuyerTel());
        orderObject.put("buyerAddress", (Object)blueInvoiceMsg.getBuyerAddress());
        orderObject.put("buyerAccount", (Object)blueInvoiceMsg.getBuyerAccount());
        orderObject.put("salerTaxNum", (Object)Parameter.get(siteid, "nuonuo_invoice_taxnum"));
        orderObject.put("salerTel", (Object)Parameter.get(siteid, "nuonuo_invoice_salertel"));
        orderObject.put("salerAddress", (Object)Parameter.get(siteid, "nuonuo_invoice_saleraddress"));
        orderObject.put("salerAccount", (Object)Parameter.get(siteid, "nuonuo_invoice_saleraccount"));
        orderObject.put("orderNo", (Object)blueInvoiceMsg.getOrderNo());
        orderObject.put("invoiceDate", (Object)OpenApi.getDateTime_Str());
        orderObject.put("remark", (Object)blueInvoiceMsg.getRemark());
        orderObject.put("invoiceType", (Object)"1");
        orderObject.put("invoiceLine", (Object)blueInvoiceMsg.getInvoiceLine());
        orderObject.put("checker", (Object)blueInvoiceMsg.getChecker());
        orderObject.put("payee", (Object)blueInvoiceMsg.getPayee());
        orderObject.put("clerk", (Object)blueInvoiceMsg.getClerk());
        orderObject.put("pushMode", (Object)"-1");
        orderObject.put("buyerPhone", (Object)"");
        orderObject.put("email", (Object)"");
        JSONArray invoiceDetailArray = new JSONArray();
        List<InvoiceDetailMsg> invoiceDetailMsgList = blueInvoiceMsg.getBlueInvoiceDetailMsgList();
        for (InvoiceDetailMsg invoiceDetailMsg : invoiceDetailMsgList) {
            JSONObject invoiceDetailObject = new JSONObject();
            invoiceDetailObject.put("goodsName", (Object)invoiceDetailMsg.getGoodsName());
            invoiceDetailObject.put("withTaxFlag", (Object)"1");
            invoiceDetailObject.put("price", (Object)invoiceDetailMsg.getPrice());
            invoiceDetailObject.put("num", (Object)invoiceDetailMsg.getNum());
            invoiceDetailObject.put("unit", (Object)invoiceDetailMsg.getUnit());
            invoiceDetailObject.put("specType", (Object)invoiceDetailMsg.getSpecType());
            invoiceDetailObject.put("taxRate", (Object)invoiceDetailMsg.getTaxRate());
            invoiceDetailArray.add((Object)invoiceDetailObject);
        }
        orderObject.put("invoiceDetail", (Object)invoiceDetailArray);
        JSONObject contentObject = new JSONObject();
        contentObject.put("order", (Object)orderObject);
        JSONObject result = this.requestApi(siteid, "nuonuo.ElectronInvoice.requestBillingNew", contentObject.toString());
        if (result.containsKey("code") && result.getString("code").equalsIgnoreCase("E0000")) {
            String invoiceSerialNum = result.getJSONObject("result").getString("invoiceSerialNum");
            System.out.println(invoiceSerialNum);
        }
        if (result.containsKey("describe")) {
            String describe = result.getString("describe");
            System.out.println(describe);
        }
    }

    public void createRedInvoice(String siteid, RedInvoiceMsg redInvoiceMsg) throws YosException {
        JSONObject orderObject = new JSONObject();
        orderObject.put("buyerName", (Object)redInvoiceMsg.getBuyerName());
        orderObject.put("buyerTaxNum", (Object)redInvoiceMsg.getBuyerTaxNum());
        orderObject.put("buyerTel", (Object)redInvoiceMsg.getBuyerTel());
        orderObject.put("buyerAddress", (Object)redInvoiceMsg.getBuyerAddress());
        orderObject.put("buyerAccount", (Object)redInvoiceMsg.getBuyerAccount());
        orderObject.put("salerTaxNum", (Object)Parameter.get(siteid, "nuonuo_invoice_taxnum"));
        orderObject.put("salerTel", (Object)Parameter.get(siteid, "nuonuo_invoice_salertel"));
        orderObject.put("salerAddress", (Object)Parameter.get(siteid, "nuonuo_invoice_saleraddress"));
        orderObject.put("salerAccount", (Object)Parameter.get(siteid, "nuonuo_invoice_saleraccount"));
        orderObject.put("orderNo", (Object)redInvoiceMsg.getOrderNo());
        orderObject.put("invoiceDate", (Object)OpenApi.getDateTime_Str());
        orderObject.put("invoiceType", (Object)"2");
        orderObject.put("invoiceLine", (Object)redInvoiceMsg.getInvoiceLine());
        orderObject.put("invoiceCode", (Object)redInvoiceMsg.getBlueinvoiceCode());
        orderObject.put("invoiceNum", (Object)redInvoiceMsg.getBlueinvoiceNum());
        if (redInvoiceMsg.getInvoiceLine().equals("s") || redInvoiceMsg.getInvoiceLine().equals("b")) {
            orderObject.put("billInfoNo", (Object)redInvoiceMsg.getBillInfoNo());
            orderObject.put("remark", (Object)("?????????????\u00f7?????????" + redInvoiceMsg.getBillInfoNo()));
        }
        orderObject.put("checker", (Object)redInvoiceMsg.getChecker());
        orderObject.put("payee", (Object)redInvoiceMsg.getPayee());
        orderObject.put("clerk", (Object)redInvoiceMsg.getClerk());
        orderObject.put("pushMode", (Object)"-1");
        orderObject.put("buyerPhone", (Object)"");
        orderObject.put("email", (Object)"");
        JSONArray invoiceDetailArray = new JSONArray();
        List<InvoiceDetailMsg> invoiceDetailMsgList = redInvoiceMsg.getInvoiceDetailMsgList();
        for (InvoiceDetailMsg invoiceDetailMsg : invoiceDetailMsgList) {
            JSONObject invoiceDetailObject = new JSONObject();
            invoiceDetailObject.put("goodsName", (Object)invoiceDetailMsg.getGoodsName());
            invoiceDetailObject.put("withTaxFlag", (Object)"1");
            invoiceDetailObject.put("price", (Object)invoiceDetailMsg.getPrice());
            invoiceDetailObject.put("num", (Object)invoiceDetailMsg.getNum());
            invoiceDetailObject.put("unit", (Object)invoiceDetailMsg.getUnit());
            invoiceDetailObject.put("specType", (Object)invoiceDetailMsg.getSpecType());
            invoiceDetailObject.put("taxRate", (Object)invoiceDetailMsg.getTaxRate());
            invoiceDetailArray.add((Object)invoiceDetailObject);
        }
        orderObject.put("invoiceDetail", (Object)invoiceDetailArray);
        JSONObject contentObject = new JSONObject();
        contentObject.put("order", (Object)orderObject);
        JSONObject result = this.requestApi(siteid, "nuonuo.ElectronInvoice.requestBillingNew", contentObject.toString());
        if (result.containsKey("code") && result.getString("code").equalsIgnoreCase("E0000")) {
            String invoiceSerialNum = result.getJSONObject("result").getString("invoiceSerialNum");
            System.out.println(invoiceSerialNum);
        }
        if (result.containsKey("describe")) {
            String describe = result.getString("describe");
            System.out.println(describe);
        }
    }

    private JSONObject requestApi(String siteid, String method, String content) throws YosException {
        String appKey = Parameter.get(siteid, "nuonuo_invoice_appkey");
        String taxnum = Parameter.get(siteid, "nuonuo_invoice_taxnum");
        String appSecret = Parameter.get(siteid, "nuonuo_invoice_appsecret");
        String token = Parameter.get(siteid, "nuonuo_invoice_token");
        String url = "https://sdk.nuonuo.com/open/v1/services";
        String senid = UUID.randomUUID().toString().replace("-", "");
        NNOpenSDK sdk = NNOpenSDK.getIntance();
        String json = sdk.sendPostSyncRequest(url, senid, appKey, appSecret, token, taxnum, method, content, new int[0]);
        return JSONObject.parseObject((String)json);
    }
}

