/*
 * Decompiled with CFR 0.152.
 */
package common.api;

import beans.parameter.Parameter;
import beans.socket.Socket;
import beans.systemapp.SystemApp;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import common.BaseClass;
import common.Controller;
import common.ReturnObject_Err;
import common.YosException;
import common.annotation.API;
import common.annotation.CACHEING;
import common.annotation.CACHEING_CLEAN;
import common.annotation.cm;
import common.data.InsertSQL;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.UpdateSQL;
import common.data.db.DBConnect;
import common.data.db.DataPool;
import common.data.db.SQLLog;
import common.data.db.SQLiteMemory;
import common.data.db.SQLiteTable;
import common.data.db.SQLiteTableData;
import common.parameter.parameter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.log4j.Logger;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import restcontroller.ClientUserInfo;
import utility.tools.MessageMonitoringStation;
import utility.tools.WebRequest;

public class YOSAPI
extends BaseClass {
    private final Logger logger = Logger.getLogger(YOSAPI.class);
    private Class clazz;
    protected Method method;
    private API api;
    private CACHEING cacheing = null;
    private boolean isCacheing = false;
    private CACHEING_CLEAN cacheing_clean = null;
    private boolean isCacheing_clean = false;
    private long id;
    private int version;
    private static HashMap<API, Long> apiintervaltimeMap = new HashMap();
    public static boolean isinit = false;
    protected static HashMap<String, YOSAPI> yosApiNameMap = new HashMap();
    public static HashMap<Long, HashMap<Integer, YOSAPI>> yosApiIDMap = new HashMap();
    protected static HashMap<Class, YOSAPI> yosApiVersionsMap = new HashMap();
    private static int hour = 0;
    private static ArrayList<String> errloglist = new ArrayList();
    private HashMap<String[], Rows> dataCleanTableRows = new HashMap();
    private HashMap<String[], Rows> dataCleanAppRows = new HashMap();
    private static String day = "";
    private static ArrayList<String> k = new ArrayList();
    private static HashMap<Long, Long> userRequestLogMap = new HashMap();
    private static HashMap<Long, Long> userRequestLogcountMap = new HashMap();
    private static String lastday = "";
    private static long requestcount_today = 0L;
    private static long requestcount_today_lastsend = 0L;
    private static long requestcount_today_lastsendtimes = 0L;
    private static long requestusercount_today = 0L;

    public Class getClazz() {
        return this.clazz;
    }

    public void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public API getApi() {
        return this.api;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setApi(API api) {
        this.api = api;
    }

    public CACHEING getCacheing() {
        return this.cacheing;
    }

    public void setCacheing(CACHEING cacheing) {
        this.cacheing = cacheing;
    }

    public boolean isCacheing() {
        return this.isCacheing;
    }

    public boolean isCacheing_Clean() {
        return this.isCacheing_clean;
    }

    public CACHEING_CLEAN getCacheing_clean() {
        return this.cacheing_clean;
    }

    public void setCacheing_clean(CACHEING_CLEAN cacheing_clean) {
        this.cacheing_clean = cacheing_clean;
    }

    public static YOSAPI getApi(String className, String methodName) throws YosException {
        YOSAPI.initialize();
        String cmkey = new StringBuffer(className).append("#").append(methodName).toString();
        if (!yosApiNameMap.containsKey(cmkey)) {
            throw new YosException("\u627e\u4e0d\u5230" + className + "\u7684" + methodName + "\u63a5\u53e3");
        }
        return yosApiNameMap.get(cmkey);
    }

    public static YOSAPI getApi(Class apiversionclass) throws YosException {
        String apiversion = apiversionclass.getName().toLowerCase();
        if (apiversion.startsWith("restcontroller.r$id") && apiversion.contains("$v")) {
            int version = Integer.parseInt(apiversionclass.getSimpleName().replace("v", ""));
            long apiid = Long.parseLong(apiversion.replace("restcontroller.r$id", "").replace("$v" + version, ""));
            return YOSAPI.getApi(apiid, version);
        }
        return null;
    }

    public static YOSAPI getApi(long apiid, int apiversion) throws YosException {
        YOSAPI.initialize();
        if (!yosApiIDMap.containsKey(apiid)) {
            throw new YosException("\u627e\u4e0d\u5230ID\u4e3a" + apiid + "\u7684\u63a5\u53e3");
        }
        HashMap<Integer, YOSAPI> map = yosApiIDMap.get(apiid);
        if (apiversion > 0) {
            if (!map.containsKey(apiversion)) {
                throw new YosException("\u627e\u4e0d\u5230ID\u4e3a" + apiid + "version\u4e3a" + apiversion + "\u7684\u63a5\u53e3");
            }
            return map.get(apiversion);
        }
        int maxVersion = 0;
        for (int version : map.keySet()) {
            if (version <= maxVersion) continue;
            maxVersion = version;
        }
        if (!map.containsKey(maxVersion)) {
            throw new YosException("\u627e\u4e0d\u5230ID\u4e3a" + apiid + "version\u4e3a" + maxVersion + "\u7684\u63a5\u53e3");
        }
        return map.get(maxVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        Class<YOSAPI> clazz = YOSAPI.class;
        synchronized (YOSAPI.class) {
            if (!isinit) {
                Reflections reflections = new Reflections("restcontroller", new Scanner[0]);
                Set subTypes = reflections.getSubTypesOf(Controller.class);
                for (Class clazz2 : subTypes) {
                    Method[] methods;
                    for (Method method : methods = clazz2.getDeclaredMethods()) {
                        String apiversion;
                        if (!method.isAnnotationPresent(API.class)) continue;
                        API api = method.getAnnotation(API.class);
                        YOSAPI yosapi = new YOSAPI();
                        yosapi.setClazz(clazz2);
                        yosapi.setMethod(method);
                        yosapi.setApi(api);
                        if (method.isAnnotationPresent(CACHEING.class)) {
                            yosapi.setCacheing(method.getAnnotation(CACHEING.class));
                            yosapi.isCacheing = true;
                        }
                        if (method.isAnnotationPresent(CACHEING_CLEAN.class)) {
                            yosapi.setCacheing_clean(method.getAnnotation(CACHEING_CLEAN.class));
                            yosapi.isCacheing_clean = true;
                        }
                        if ((apiversion = api.apiversion().getName().toLowerCase()).startsWith("restcontroller.r$id") && apiversion.contains("$v")) {
                            int version = Integer.parseInt(api.apiversion().getSimpleName().replace("v", ""));
                            long apiid = Long.parseLong(apiversion.replace("restcontroller.r$id", "").replace("$v" + version, ""));
                            HashMap<Object, Object> idapimap = yosApiIDMap.containsKey(apiid) ? yosApiIDMap.get(apiid) : new HashMap();
                            yosapi.setId(apiid);
                            yosapi.setVersion(version);
                            idapimap.put(version, yosapi);
                            yosApiIDMap.put(apiid, idapimap);
                            yosApiVersionsMap.put(api.apiversion(), yosapi);
                        }
                        String cmkey = new StringBuffer(clazz2.getName()).append("#").append(method.getName()).toString();
                        yosApiNameMap.put(cmkey, yosapi);
                    }
                }
                isinit = true;
                try {
                    Rows rows = new DBConnect().runSqlQuery("select * from sys_api");
                    for (Row row : rows) {
                        apiintervaltimeMap.put(YOSAPI.getApi(row.getLong("apiid"), row.getInteger("apiversion")).getApi(), row.getLong("intervaltime"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void setApiIntervaltime(long apiid, int apiversion, long intervaltime) throws YosException {
        apiintervaltimeMap.put(YOSAPI.getApi(apiid, apiversion).getApi(), intervaltime);
    }

    public long getApiIntervaltime() {
        long intervaltime = apiintervaltimeMap.getOrDefault(this.getApi(), this.getApi().intervaltime());
        return intervaltime == -1L ? 1000L : intervaltime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object request_validate(YosRequest request) throws YosException {
        long intervaltime;
        if (this.getApi().accesstoken()) {
            if ("".equals(request.getAccesstoken()) || !parameter.tokenlist.containsKey(request.getAccesstoken()) && !this.istokeninuserlist(request)) {
                return new ReturnObject_Err().setErrCode(-1).setErrMsg("\u767b\u9646\u72b6\u6001\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u9646\uff01");
            }
            if (!(!Parameter.get("system_sessionidcheck").equalsIgnoreCase("true") || parameter.tokenSessionidlist.containsKey(request.getAccesstoken()) && parameter.tokenSessionidlist.get(request.getAccesstoken()).equals(request.getRequestsessionid()))) {
                return new ReturnObject_Err().setErrCode(-1).setErrMsg("\u8eab\u4efd\u4ee4\u724c\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u9646\uff01");
            }
            if (request.getUserRow().getBoolean("isthirddeveloper").booleanValue()) {
                return new ReturnObject_Err().setErrCode(-1).setErrMsg("\u8d26\u53f7\u8bf7\u6c42\u63a5\u53e3\u8c03\u7528\u9519\u8bef\uff01");
            }
        }
        if (request.isdebug && !Parameter.get("system_runmode_debug").equalsIgnoreCase("true")) {
            return new ReturnObject_Err().setErrMsg("\u7cfb\u7edf\u975e\u8c03\u8bd5\u6a21\u5f0f\u4e0b\uff0c\u4e0d\u53ef\u6267\u884c\u6b64\u64cd\u4f5c\uff01");
        }
        if (this.isCacheing() || (intervaltime = this.getApiIntervaltime()) <= 0L) return null;
        Class<YOSAPI> clazz = YOSAPI.class;
        synchronized (YOSAPI.class) {
            Map<Object, Object> userintervaltimemap;
            if (parameter.APIIntervaltimeCheck.containsKey(this.method)) {
                userintervaltimemap = parameter.APIIntervaltimeCheck.get(this.method);
                if (userintervaltimemap.containsKey(request.getAccesstoken()) && (Long)userintervaltimemap.get(request.getAccesstoken()) > Calendar.getInstance().getTimeInMillis()) {
                    if (!this.getApi().accesstoken()) return new ReturnObject_Err().setErrMsg("\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
                    // ** MonitorExit[var4_3] (shouldn't be in output)
                    return new ReturnObject_Err().setErrMsg("\u64cd\u4f5c\u592a\u8fc7\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
                }
            } else {
                userintervaltimemap = new HashMap<String, Long>();
            }
            userintervaltimemap.put(request.getAccesstoken(), Calendar.getInstance().getTimeInMillis() + intervaltime);
            parameter.APIIntervaltimeCheck.put(this.method, userintervaltimemap);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object action(YosRequest request) throws YosException {
        String result;
        block39: {
            Object data;
            request.setClasspath(this.getClazz().getName());
            request.setMethodname(this.getMethod().getName());
            String requestlogid = this.saveRequestLog(request);
            Object validateObject = this.request_validate(request);
            if (validateObject != null) {
                return validateObject;
            }
            long starttimes = Calendar.getInstance().getTimeInMillis();
            result = null;
            if (this.isCacheing() && !((Boolean)request.getContent().getOrDefault("nocache", false)).booleanValue() && (data = DataPool.get(request)) != null) {
                SQLiteTable sqLiteTable;
                result = data.toString();
                this.saveCallMethodMsg(this.getClazz().getName() + "." + this.getMethod().getName(), false, starttimes);
                if (Parameter.get("system_api_requestlog").equalsIgnoreCase("true") && !(sqLiteTable = SQLiteTable.getTable("apirequestlog")).dosNotExist()) {
                    SQLiteMemory.runSqlUpdate("update apirequestlog set iscacheing=1  where requestlogid='" + requestlogid + "'");
                }
            }
            Object obj = null;
            try {
                JSONObject requestContent = request.getContent();
                requestContent.put("accesstoken", (Object)request.getAccesstoken());
                if (result != null) break block39;
                boolean isExport = requestContent.getBooleanValue("isExport");
                if (isExport && requestContent.containsKey("exportFields") && !requestContent.getJSONArray("exportFields").isEmpty()) {
                    requestContent.put("pageSize", (Object)1000000);
                    requestContent.put("pageNumber", (Object)1);
                }
                Constructor cla = this.getClazz().getDeclaredConstructor(JSONObject.class);
                obj = cla.newInstance(requestContent);
                obj.getClass().getMethod("setYosapi", YOSAPI.class, YosRequest.class).invoke(obj, this, request);
                obj.getClass().getMethod("setSorting", new Class[0]).invoke(obj, new Object[0]);
                if (request.getFileItems() != null) {
                    obj.getClass().getMethod("setrequestFileItemList", List.class).invoke(obj, request.getFileItems());
                }
                result = (String)this.getMethod().invoke(obj, new Object[0]);
                if (isExport && requestContent.containsKey("exportFields") && !requestContent.getJSONArray("exportFields").isEmpty()) {
                    try {
                        JSONObject r = JSONObject.parseObject((String)result);
                        if (r.getIntValue("code") == 1) {
                            JSONArray exportFieldsArray = requestContent.getJSONArray("exportFields");
                            Rows excelRows = ((Controller)obj).uploadExcelToObs(SystemApp.getSystemAppName(request.getSystemappId()) + Calendar.getInstance().getTimeInMillis(), "Sheet1", exportFieldsArray, r.getJSONArray("data"));
                            r.put("data", (Object)excelRows.toJsonArray());
                            result = r.toString();
                        }
                        break block39;
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                        ReturnObject_Err returnObject_err = new ReturnObject_Err();
                        returnObject_err.setErrMsg("\u6570\u636e\u5bfc\u51fa\u5931\u8d25" + e3.getMessage());
                        ReturnObject_Err returnObject_Err = returnObject_err;
                        if (requestlogid.equals("")) return returnObject_Err;
                        this.saveSQLLog(obj, requestlogid);
                        return returnObject_Err;
                    }
                }
                if (!this.isCacheing()) break block39;
            }
            catch (InstantiationException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                ReturnObject_Err isExport = new ReturnObject_Err().setErrMsg("\u7c7b" + this.getClazz().getName() + "\u5b9e\u4f8b\u5316\u5f02\u5e38");
                return isExport;
            }
            catch (IllegalAccessException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                ReturnObject_Err isExport = new ReturnObject_Err().setErrMsg("\u7c7b" + this.getClazz().getName() + "\u5b89\u5168\u6743\u9650\u5f02\u5e38\uff0c\u53ef\u80fd\u8be5\u7c7b\u4e3a\u975epublic\u7c7b");
                return isExport;
            }
            catch (NoSuchMethodException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                ReturnObject_Err isExport = new ReturnObject_Err().setErrMsg("\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u7c7b" + this.getClazz().getName() + "\u7684" + this.getMethod().getName() + "\u65b9\u6cd5");
                if (requestlogid.equals("")) return isExport;
                this.saveSQLLog(obj, requestlogid);
                return isExport;
            }
            catch (IllegalArgumentException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                ReturnObject_Err isExport = new ReturnObject_Err().setErrMsg("\u7c7b" + this.getClazz().getName() + "\u7684" + this.getMethod().getName() + "\u65b9\u6cd5\u53c2\u6570\u4e0d\u5408\u6cd5");
                if (requestlogid.equals("")) return isExport;
                this.saveSQLLog(obj, requestlogid);
                return isExport;
                catch (InvocationTargetException e2) {
                    ReturnObject_Err returnObject_err;
                    block41: {
                        block40: {
                            Throwable targetException = e2.getTargetException();
                            returnObject_err = new ReturnObject_Err();
                            if (targetException instanceof YosException && !((YosException)targetException).consolelog) {
                                returnObject_err.setErrMsg(targetException.getMessage() + "");
                                ReturnObject_Err e3 = returnObject_err;
                                if (requestlogid.equals("")) return e3;
                                this.saveSQLLog(obj, requestlogid);
                                return e3;
                            }
                            if ("DataVersion conflict".equalsIgnoreCase(targetException.getMessage() + "")) break block40;
                            targetException.printStackTrace();
                            try {
                                Row row = request.getUserRow();
                                long userid = 0L;
                                String siteid = "";
                                if (row != null) {
                                    userid = row.getLong("userid");
                                    siteid = row.getString("siteid");
                                }
                                InsertSQL insertSQL = SQLFactory.createInsertSQL(this.dbConnect, "sys_requesterrlog");
                                insertSQL.setValue("apiid", this.getId());
                                insertSQL.setValue("title", this.getApi().title());
                                insertSQL.setValue("classname", this.getClazz().getName());
                                insertSQL.setValue("method", this.getMethod().getName());
                                insertSQL.setValue("message", targetException.getMessage() + " ");
                                insertSQL.setValue("stacktrace", JSON.toJSON((Object)targetException.getStackTrace()));
                                insertSQL.setValue("request", request.getContent());
                                insertSQL.setValue("userid", userid);
                                insertSQL.setValue("siteid", siteid);
                                insertSQL.setValue("systemappid", request.getSystemappId());
                                insertSQL.setDateValue("createdate");
                                insertSQL.insert();
                                if (!errloglist.contains(this.getId() + targetException.getStackTrace()[0].toString())) {
                                    StringBuilder errmsg = new StringBuilder("\n\u63a5\u53e3\u8bf7\u6c42\u6216\u6267\u884c\u5f02\u5e38\uff01\n\u63a5\u53e3\u540d\u79f0\uff1a" + this.getApi().title() + "\n\u63a5\u53e3ID\uff1a" + this.getId() + "\n");
                                    if (row != null) {
                                        errmsg.append("\u64cd\u4f5c\u8d26\u53f7\uff1a").append(siteid).append(" ").append(row.getString("name")).append("(").append(userid).append(")").append("\n");
                                        errmsg.append("\u64cd\u4f5c\u4f4d\u7f6e\uff1a").append(row.getString("systemclient")).append(" ").append(SystemApp.getSystemAppName(request.getSystemappId())).append("(").append(request.getSystemappId()).append(")").append("\n");
                                    }
                                    errmsg.append("\u5f02\u5e38\u539f\u56e0\uff1a").append(targetException.getMessage()).append("\n");
                                    errmsg.append("\u5f02\u5e38\u4f4d\u7f6e\uff1a\n");
                                    for (int i = 0; i < targetException.getStackTrace().length && i <= 3; ++i) {
                                        errmsg.append(targetException.getStackTrace()[i].toString()).append("\n");
                                    }
                                    errmsg.append("\n\u76f8\u5173\u4eba\u5458\u8bf7\u53ca\u65f6\u5904\u7406\uff01");
                                    MessageMonitoringStation.send(errmsg.toString());
                                    errloglist.add(this.getId() + targetException.getStackTrace()[0].toString());
                                }
                                if (hour != Calendar.getInstance().get(11)) {
                                    errloglist.clear();
                                    hour = Calendar.getInstance().get(11);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            returnObject_err.setErrMsg(targetException.getMessage());
                            break block41;
                        }
                        returnObject_err.setErrMsg("\u6570\u636e\u5df2\u66f4\u65b0\uff0c\u8bf7\u83b7\u53d6\u6700\u65b0\u6570\u636e\u540e\u518d\u91cd\u8bd5\uff01");
                    }
                    ReturnObject_Err returnObject_Err = returnObject_err;
                    if (requestlogid.equals("")) return returnObject_Err;
                    this.saveSQLLog(obj, requestlogid);
                    return returnObject_Err;
                    catch (Exception e4) {
                        try {
                            this.logger.error((Object)e4.getMessage(), (Throwable)e4);
                            ReturnObject_Err returnObject_Err2 = new ReturnObject_Err().setErrMsg("\u53d1\u751f\u672a\u77e5\u5f02\u5e38" + e4.getMessage());
                            return returnObject_Err2;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            this.saveCallMethodMsg(this.getClazz().getName() + "." + this.getMethod().getName(), true, starttimes);
                        }
                    }
                }
            }
            finally {
                if (!requestlogid.equals("")) {
                    this.saveSQLLog(obj, requestlogid);
                }
            }
            DataPool.put(request, (Object)result, this.getCacheing().life());
            this.saveCallMethodMsg(this.getClazz().getName() + "." + this.getMethod().getName(), true, starttimes);
        }
        if (this.isCacheing_clean) {
            this.cacheingclean(request);
        }
        this.createUserRequestLog(request);
        return JSON.parse((String)result, (Feature[])new Feature[]{Feature.OrderedField});
    }

    private void cacheingclean(YosRequest request) throws YosException {
        String[] systemapps;
        Class[] apiClasses;
        Class[] apiversions;
        cm[] cms;
        ArrayList<Long> cacheing_cleanUserids = request.getCacheing_cleanUsers();
        for (cm cm2 : cms = this.getCacheing_clean().cms()) {
            String[] methods;
            String classpath = cm2.clazz().getName();
            for (String string : methods = cm2.method()) {
                DataPool.remove(request.getAccesstoken(), classpath, string);
                for (Long cacheing_cleanUserid : cacheing_cleanUserids) {
                    DataPool.remove(cacheing_cleanUserid, classpath, string);
                }
            }
        }
        for (Class clazz : apiversions = this.getCacheing_clean().apiversions()) {
            long apiid;
            String clazzSimpleName = clazz.getSimpleName().toLowerCase();
            if (clazzSimpleName.startsWith("v")) {
                if (!yosApiVersionsMap.containsKey(clazz)) continue;
                YOSAPI yosapi = yosApiVersionsMap.get(clazz);
                String classpath = yosapi.getClazz().getName();
                String method = yosapi.getMethod().getName();
                DataPool.remove(request.getAccesstoken(), classpath, method);
                for (Long cacheing_cleanUserid : cacheing_cleanUserids) {
                    DataPool.remove(cacheing_cleanUserid, classpath, method);
                }
                continue;
            }
            if (!clazzSimpleName.startsWith("id") || !yosApiIDMap.containsKey(apiid = Long.parseLong(clazzSimpleName.replace("id", "")))) continue;
            HashMap<Integer, YOSAPI> apiversionmap = yosApiIDMap.get(apiid);
            for (int version : apiversionmap.keySet()) {
                YOSAPI yosapi = apiversionmap.get(version);
                String classpath = yosapi.getClazz().getName();
                String method = yosapi.getMethod().getName();
                DataPool.remove(request.getAccesstoken(), classpath, method);
                for (Long cacheing_cleanUserid : cacheing_cleanUserids) {
                    DataPool.remove(cacheing_cleanUserid, classpath, method);
                }
            }
        }
        for (Class apiClass : apiClasses = this.getCacheing_clean().apiClass()) {
            DataPool.remove(request.getAccesstoken(), apiClass.getName());
            for (Long cacheing_cleanUserid : cacheing_cleanUserids) {
                DataPool.remove(cacheing_cleanUserid, apiClass.getName());
            }
        }
        String[] tablenames = this.getCacheing_clean().tablename();
        if (tablenames.length > 0) {
            Rows tablenameRows = null;
            if (this.dataCleanTableRows.containsKey(tablenames)) {
                tablenameRows = this.dataCleanTableRows.get(tablenames);
            } else {
                SQLFactory tablenameapiquery = new SQLFactory("sql:select distinct t2.apiid,t2.apiversion from sys_objectapps t1 inner join sys_apiapps t2 on t1.systemappid=t2.systemappid where t1.table_name in $table_name$");
                tablenameapiquery.addParameter_in("table_name", tablenames);
                tablenameRows = tablenameapiquery.runSqlQuery(this.dbConnect);
                this.dataCleanTableRows.put(tablenames, tablenameRows);
            }
            for (Row tablenameRow : tablenameRows) {
                long apiid = tablenameRow.getLong("apiid");
                int apiversion = tablenameRow.getInteger("apiversion");
                try {
                    YOSAPI yOSAPI = YOSAPI.getApi(apiid, apiversion);
                    DataPool.remove(request.getAccesstoken(), yOSAPI.getClazz().getName(), yOSAPI.method.getName());
                    for (Long cacheing_cleanUserid : cacheing_cleanUserids) {
                        DataPool.remove(cacheing_cleanUserid, yOSAPI.getClazz().getName(), yOSAPI.method.getName());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        if ((systemapps = this.getCacheing_clean().systemapp()).length > 0) {
            Rows systemappsRows = null;
            if (this.dataCleanAppRows.containsKey(systemapps)) {
                systemappsRows = this.dataCleanAppRows.get(systemapps);
            } else {
                SQLFactory systemappquery = new SQLFactory("sql:select distinct t2.apiid,t2.apiversion from sys_systemapp t1 inner join sys_apiapps t2 on t1.systemappid=t2.systemappid where t1.systemapp in $systemapp$");
                systemappquery.addParameter_in("systemapp", systemapps);
                systemappsRows = systemappquery.runSqlQuery(this.dbConnect);
                this.dataCleanAppRows.put(tablenames, systemappsRows);
            }
            for (Row systemappsRow : systemappsRows) {
                long apiid = systemappsRow.getLong("apiid");
                int n = systemappsRow.getInteger("apiversion");
                try {
                    YOSAPI yosapi = YOSAPI.getApi(apiid, n);
                    DataPool.remove(request.getAccesstoken(), yosapi.getClazz().getName(), yosapi.method.getName());
                    for (Long cacheing_cleanUserid : cacheing_cleanUserids) {
                        DataPool.remove(cacheing_cleanUserid, yosapi.getClazz().getName(), yosapi.method.getName());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String saveRequestLog(YosRequest request) throws YosException {
        String requestlogid = "";
        if (Parameter.get("system_api_requestlog").equalsIgnoreCase("true")) {
            requestlogid = request.requestKey + Calendar.getInstance().getTimeInMillis();
            final SQLiteTable sqLiteTable = SQLiteTable.getTable("apirequestlog");
            if (!sqLiteTable.dosNotExist()) {
                SQLiteTableData sqLiteTableData = sqLiteTable.makeData();
                sqLiteTableData.set("requestlogid", requestlogid);
                sqLiteTableData.set("classname", this.getClazz().getName().replace("restcontroller.", ""));
                sqLiteTableData.set("method", this.getMethod().getName());
                sqLiteTableData.set("createdate", YOSAPI.getDateTime_Str());
                sqLiteTableData.set("request", request.getContent().toString(), true);
                if (parameter.tokenlist.containsKey(request.getAccesstoken())) {
                    if (parameter.usersiteIdList.containsKey(parameter.tokenlist.get(request.getAccesstoken()))) {
                        sqLiteTableData.set("usermsg", parameter.usersiteIdList.get(parameter.tokenlist.get(request.getAccesstoken())).toJsonObject().toJSONString());
                    } else {
                        sqLiteTableData.set("usermsg", "{}");
                    }
                } else {
                    sqLiteTableData.set("usermsg", "{}");
                }
                sqLiteTableData.insert();
            }
            if (request.getSystemappId() > 0L && this.getId() > 0L) {
                String key = request.getSystemappId() + "-" + this.getId() + "-" + this.getVersion();
                if (!k.contains(key)) {
                    InsertSQL sqlFactory = SQLFactory.createInsertSQL(this.dbConnect, "sys_apiapps");
                    sqlFactory.setValue("sys_apiappsid", this.createTableID("sys_apiapps"));
                    sqlFactory.setValue("apiid", this.getId());
                    sqlFactory.setValue("apiversion", this.getVersion());
                    sqlFactory.setValue("systemappid", request.getSystemappId());
                    sqlFactory.setValue("sequence", 0);
                    sqlFactory.setValue("createflag", 1);
                    sqlFactory.setValue("lastrequesttime", YOSAPI.getDateTime_Str());
                    sqlFactory.setWhere("not exists(select * from sys_apiapps where systemappid='" + request.getSystemappId() + "' and apiid='" + this.getId() + "' and apiversion='" + this.getVersion() + "')");
                    sqlFactory.insert();
                    k.add(key);
                } else {
                    UpdateSQL sqlFactory = SQLFactory.createUpdateSQL(this.dbConnect, "sys_apiapps");
                    sqlFactory.setValue("lastrequesttime", YOSAPI.getDateTime_Str());
                    sqlFactory.setWhere("apiid", this.getId());
                    sqlFactory.setWhere("apiversion", this.getVersion());
                    sqlFactory.setWhere("systemappid", request.getSystemappId());
                    sqlFactory.update();
                }
            }
            if (!day.equals(YOSAPI.getDate_Str())) {
                new Thread(){

                    @Override
                    public void run() {
                        super.run();
                        sqLiteTable.deleteData("datetime(createdate) < datetime('now','-1 day','localtime') ");
                        Calendar calendar = Calendar.getInstance();
                        calendar.add(5, -1);
                        SQLiteTable.getTable("apirequestsqllog").deleteData("createtimeinmillis < " + calendar.getTimeInMillis());
                    }
                }.start();
                day = YOSAPI.getDate_Str();
            }
        }
        return requestlogid;
    }

    private void saveSQLLog(Object obj, String requestlogid) {
        try {
            SQLiteTable sqLiteTable;
            if (obj instanceof BaseClass && Parameter.get("system_db_sqllog").equalsIgnoreCase("true") && !(sqLiteTable = SQLiteTable.getTable("apirequestsqllog")).dosNotExist()) {
                ArrayList sqlLogList = (ArrayList)obj.getClass().getMethod("getSQLLog", new Class[0]).invoke(obj, new Object[0]);
                for (SQLLog sqlLog : sqlLogList) {
                    SQLiteTableData sqLiteTableData = sqLiteTable.makeData();
                    sqLiteTableData.set("requestlogid", requestlogid);
                    sqLiteTableData.set("runtime", sqlLog.getRuntime());
                    sqLiteTableData.set("sql", sqlLog.getSQL(), true);
                    sqLiteTableData.set("success", sqlLog.isSuccess() ? 1 : 0);
                    sqLiteTableData.set("errmsg", sqlLog.getErrmsg());
                    sqLiteTableData.set("createtimeinmillis", Calendar.getInstance().getTimeInMillis());
                    sqLiteTableData.set("numofaffectedrows", sqlLog.getNumofaffectedrows());
                    sqLiteTableData.insert();
                }
                sqlLogList.clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createUserRequestLog(final YosRequest request) {
        if (parameter.tokenlist.containsKey(request.getAccesstoken())) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        long userrequestlogid;
                        Rows rows;
                        long usersiteid = parameter.tokenlist.get(request.getAccesstoken());
                        Row row = parameter.usersiteIdList.get(usersiteid);
                        long userid = row.getLong("userid");
                        String siteid = row.getString("siteid");
                        String nowday = BaseClass.getDate_Str();
                        if (!lastday.equals(nowday)) {
                            lastday = nowday;
                            userRequestLogMap.clear();
                            rows = YOSAPI.this.dbConnect.runSqlQuery("select sum(requesttimes)as requestcount_today,count(distinct userid)requestusercount_today from sys_userrequestlog where `date`= date_format(now(),'%Y-%m-%d')");
                            if (rows.isNotEmpty()) {
                                requestcount_today = rows.get(0).getBigDecimal("requestcount_today").longValue();
                                requestusercount_today = rows.get(0).getLong("requestusercount_today");
                            }
                        }
                        if (!userRequestLogMap.containsKey(usersiteid)) {
                            rows = YOSAPI.this.dbConnect.runSqlQuery("select userrequestlogid from sys_userrequestlog where usersiteid='" + usersiteid + "' and date_format(date,'%Y-%m-%d')=date_format(now(),'%Y-%m-%d')");
                            if (rows.isEmpty()) {
                                ArrayList<String> sqllist = new ArrayList<String>();
                                userrequestlogid = YOSAPI.this.createTableID("sys_userrequestlog");
                                SQLFactory deletesql = new SQLFactory(this, "\u8bf7\u6c42\u65e5\u5fd7\u5220\u9664");
                                deletesql.addParameter("usersiteid", usersiteid);
                                sqllist.add(deletesql.getSQL());
                                SQLFactory insertsql = new SQLFactory(this, "\u8bf7\u6c42\u65e5\u5fd7\u63d2\u5165");
                                insertsql.addParameter("userrequestlogid", userrequestlogid);
                                insertsql.addParameter("usersiteid", usersiteid);
                                insertsql.addParameter("userid", userid);
                                insertsql.addParameter("siteid", siteid);
                                if (request.getHttpServletRequest() != null) {
                                    insertsql.addParameter("ip", WebRequest.getRequestIP(request.getHttpServletRequest()));
                                    insertsql.addParameter("useragent", WebRequest.getUserAgent(request.getHttpServletRequest()));
                                } else {
                                    insertsql.addParameter("ip", "");
                                    insertsql.addParameter("useragent", "");
                                }
                                sqllist.add(insertsql.getSQL());
                                YOSAPI.this.dbConnect.runSqlUpdate(sqllist);
                                userRequestLogMap.put(usersiteid, userrequestlogid);
                            } else {
                                userRequestLogMap.put(usersiteid, rows.get(0).getLong("userrequestlogid"));
                            }
                            userRequestLogcountMap.put(usersiteid, 1L);
                        } else {
                            long count = (Long)userRequestLogcountMap.get(usersiteid) + 1L;
                            if (count > 9L) {
                                userRequestLogcountMap.put(usersiteid, 1L);
                                userrequestlogid = (Long)userRequestLogMap.get(usersiteid);
                                YOSAPI.this.dbConnect.runSqlUpdate("update sys_userrequestlog set lastrequestdate=now(),requesttimes=requesttimes+" + count + " where usersiteid='" + usersiteid + "' and userrequestlogid=" + userrequestlogid);
                            } else {
                                userRequestLogcountMap.put(usersiteid, count);
                            }
                        }
                        requestcount_today++;
                        long now = Calendar.getInstance().getTimeInMillis();
                        if (now - 2000L > requestcount_today_lastsendtimes) {
                            JSONObject object = new JSONObject();
                            object.put("requestcount_today", (Object)requestcount_today);
                            object.put("requestcount_today_lastsend", (Object)requestcount_today_lastsend);
                            object.put("requestusercount_today", (Object)requestusercount_today);
                            object.put("onlineusersiteaccount", (Object)parameter.websocketClients.size());
                            Socket.sendData("requestcount_today", object);
                            requestcount_today_lastsend = requestcount_today;
                            requestcount_today_lastsendtimes = now;
                        }
                    }
                    catch (YosException e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
    }

    private void saveCallMethodMsg(String key, boolean fromdb, long starttime) {
        long time = Calendar.getInstance().getTimeInMillis() - starttime;
        long callmethodTimes = parameter.callmethodTimes.getOrDefault(key, 0L);
        parameter.callmethodTimes.put(key, callmethodTimes + 1L);
        parameter.lastcallmethodtime.put(key, Calendar.getInstance().getTime());
        long callmethod_fromcacheTimes = parameter.callmethod_fromcacheTimes.getOrDefault(key, 0L);
        if (!fromdb) {
            parameter.callmethod_fromcacheTimes.put(key, callmethod_fromcacheTimes + 1L);
        } else {
            parameter.callmethodLastTimeLong.put(key, time);
            long totaltimes = callmethodTimes - callmethod_fromcacheTimes;
            long callmethodTimeLong = parameter.callmethodTimeLong.getOrDefault(key, 0L);
            parameter.callmethodTimeLong.put(key, (callmethodTimeLong * totaltimes + time) / (totaltimes + 1L));
        }
    }

    protected boolean istokeninuserlist(YosRequest request) throws YosException {
        DBConnect dbConnect = new DBConnect();
        SQLFactory factory = null;
        if (Parameter.get("system_sessionidcheck").equalsIgnoreCase("true")) {
            factory = new SQLFactory(this, "\u6301\u4e45\u5316\u8d26\u53f7\u5217\u8868\u67e5\u8be2_sessionid");
            factory.addParameter("sessionid", request.getRequestsessionid());
        } else {
            factory = new SQLFactory(this, "\u6301\u4e45\u5316\u8d26\u53f7\u5217\u8868\u67e5\u8be2");
        }
        factory.addParameter("accesstoken", request.getAccesstoken());
        Rows rows = dbConnect.runSqlQuery(factory.getSQL());
        if (rows.isEmpty()) {
            return false;
        }
        for (Row row : rows) {
            long usersiteid = row.getLong("usersiteid");
            row.put("logintime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime()));
            if (request.getHttpServletRequest() != null) {
                row.put("ip", WebRequest.getRequestIP(request.getHttpServletRequest()));
                row.put("useragent", WebRequest.getUserAgent(request.getHttpServletRequest()));
            } else {
                row.put("ip", "");
                row.put("useragent", "");
            }
            row.putAll(ClientUserInfo.setLoginReturn(usersiteid, row));
            parameter.usersiteIdList.put(usersiteid, row);
            parameter.tokenlist.put(request.getAccesstoken(), usersiteid);
            parameter.tokenSessionidlist.put(request.getAccesstoken(), request.getRequestsessionid());
        }
        return true;
    }

    public static class YosRequest {
        private HttpServletRequest httpServletRequest = null;
        private String requestKey = null;
        private String accesstoken = null;
        private String requestsessionid = null;
        private JSONObject content = null;
        private String classpath = null;
        private String methodname = null;
        private long systemappid = 0L;
        private boolean isdebug = false;
        private List<FileItem> fileItems = null;
        private ArrayList<Long> cacheing_cleanUsers = new ArrayList();

        public List<FileItem> getFileItems() {
            return this.fileItems;
        }

        public YosRequest setFileItems(List<FileItem> fileItems) {
            this.fileItems = fileItems;
            return this;
        }

        public JSONObject getContent() {
            return this.content;
        }

        public YosRequest setContent(JSONObject content) {
            this.content = content;
            return this;
        }

        public boolean isdebug() {
            return this.isdebug;
        }

        public void setIsdebug(boolean isdebug) {
            this.isdebug = isdebug;
        }

        public String getAccesstoken() {
            return this.accesstoken;
        }

        public YosRequest setAccesstoken(String accesstoken) {
            this.accesstoken = accesstoken;
            return this;
        }

        public String getRequestsessionid() {
            return this.requestsessionid;
        }

        public YosRequest setRequestsessionid(String requestsessionid) {
            this.requestsessionid = requestsessionid;
            return this;
        }

        public String getRequestKey() {
            return this.requestKey;
        }

        public YosRequest setRequestKey(String requestKey) {
            this.requestKey = requestKey;
            return this;
        }

        public HttpServletRequest getHttpServletRequest() {
            return this.httpServletRequest;
        }

        public YosRequest setHttpServletRequest(HttpServletRequest httpServletRequest) {
            this.httpServletRequest = httpServletRequest;
            return this;
        }

        public String getClasspath() {
            return this.classpath;
        }

        public void setClasspath(String classpath) {
            this.classpath = classpath;
        }

        public String getMethodname() {
            return this.methodname;
        }

        public void setMethodname(String methodname) {
            this.methodname = methodname;
        }

        public long getUsersiteid() {
            return parameter.tokenlist.getOrDefault(this.getAccesstoken(), 0L);
        }

        public Row getUserRow() {
            return parameter.usersiteIdList.getOrDefault(this.getUsersiteid(), null);
        }

        public ArrayList<Long> getCacheing_cleanUsers() {
            return this.cacheing_cleanUsers;
        }

        public void addCacheing_cleanUser(Long userid) {
            this.cacheing_cleanUsers.add(userid);
        }

        public long getSystemappId() {
            return this.systemappid;
        }

        public YosRequest setSystemappId(long systemappid) {
            this.systemappid = systemappid;
            return this;
        }
    }
}

