select t5.systemid,
                t4.systemmoduleid,
                t4.systemmodule,
                t4.systemmodulename,
                t6.sequence,
                t6.location,
                t6.issystem,
                t3.systemappid,
                t3.systemapp,
                t3.systemappname
from sys_roleappoptionauth t1
         inner join sys_systemapp_options t2 on t1.optionid = t2.optionid and t2.isused = 1
         inner join sys_systemapp t3 on t2.systemappid = t3.systemappid and t3.isused = 1
         inner join sys_systemmodule t4 on t3.systemmoduleid = t4.systemmoduleid and t4.isused = 1
         inner join sys_systemclient t5 on t4.systemclientid = t5.systemclientid and t5.isused = 1
         inner join sys_shortcuts t6
                    on t3.systemappid = t6.systemappid and t6.siteid = $siteid$ and t6.userid = $userid$ and
                       t6.systemclient = t5.systemclient
where t5.systemclient = $systemclient$
  and exists(select * from sys_userrole where roleid = t1.roleid and userid = $userid$ and siteid = $siteid$)
group by t5.systemid,
         t4.systemmoduleid,
         t4.systemmodule,
         t4.systemmodulename,
         t6.sequence,
         t6.location,
         t6.issystem,
         t3.systemappid,
         t3.systemapp,
         t3.systemappname, t6.sys_shortcutsid
order by t6.issystem desc, t6.sequence, t6.sys_shortcutsid
