package restcontroller.sysmanage.develop.users;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.*;
import restcontroller.R;
import utility.tools.Encryption;

import java.util.ArrayList;

@API(title = "管理端-账号管理")
public class users extends Controller {
    public users(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "系统管理员账号列表查询", apiversion = R.ID10017501.v1.class)
    public String query_userList() throws YosException {
        /*
          过滤条件设置
         */
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("t1.phonenumber like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.name like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.accountno like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
            if (whereObject.containsKey("status") && !"".equals(whereObject.getString("status"))) {
                where.append(" and(");
                where.append("t1.status ='").append(whereObject.getString("status")).append("' ");
                where.append(")");
            }
            if (whereObject.containsKey("sysadministrator") && !"".equals(whereObject.getString("sysadministrator"))) {
                where.append(" and(");
                where.append("t1.sysadministrator ='").append(whereObject.getString("sysadministrator")).append("' ");
                where.append(")");
            }
        }
        QuerySQL querySQL = SQLFactory.createQuerySQL(this, "sys_users", "userid", "name", "createby", "createdate",
                "changeby", "remarks", "changedate", "phonenumber", "status", "accountno","passwordchangedate").setTableAlias("t1");
        querySQL.addJoinTable(JOINTYPE.left, "sys_userrequestlog", "t2", "userid=:userid");
        querySQL.addQueryFields("lastrequestdate", " max(t2.lastrequestdate)");
        querySQL.addGroupBy();
        querySQL.setWhere(where.toString());
        querySQL.setPage(pageSize, pageNumber);
        Rows rows = querySQL.query();

        SQLFactory usersitesql = new SQLFactory(this, "账号授权站点查询");
        usersitesql.addParameter_in("userid", rows.toArrayList("userid"));
        RowsMap usersitemap = dbConnect.runSqlQuery(usersitesql.getSQL()).toRowsMap("userid");
        for (Row row : rows) {
            Rows siteRows = usersitemap.get(row.getString("userid"));
            for (Row siteRow : siteRows) {
                siteRow.put("role", dbConnect.runSqlQuery("select t2.rolename from sys_userrole t1 inner join sys_role t2 on t1.siteid = t2.siteid and t1.roleid = t2.roleid where t1.userid = " + row.getString("userid") + " and t1.siteid = '" + siteRow.getString("siteid") + "'").toArrayList("rolename"));
            }
            row.put("site", siteRows);
        }
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "账号新增、修改", apiversion = R.ID10017601.v1.class)
    public String insertormodify_user() throws YosException {
        long changeuserid = content.getLongValue("userid");//新增时传0
        String changename = content.getString("name", "sys_users");
        String changephonenumber = content.getString("phonenumber", "sys_users");
        String changeremarks = content.getString("remarks", "sys_users");
        String changepassword = content.getString("password", "sys_users");
        String changeaccountno = content.getString("accountno", "sys_users");
        boolean isactive = content.getBoolean("isactive");

        if (dbConnect.runSqlQuery("select *from sys_users where sysadministrator = 1 and  phonenumber='" + changephonenumber + "' and userid!='" + changeuserid + "'").isNotEmpty()) {
            return getErrReturnObject().setErrMsg("存在重复的手机号信息").toString();
        }
        if (dbConnect.runSqlQuery("select *from sys_users where sysadministrator = 1 and accountno='" + changeaccountno + "' and userid!='" + changeuserid + "'").isNotEmpty()) {
            return getErrReturnObject().setErrMsg("存在重复的账号信息").toString();
        }
        ArrayList<String> sqllist = new ArrayList<>();
        if (changeuserid <= 0 || dbConnect.runSqlQuery("select userid from sys_users where userid=" + changeuserid).isEmpty()) {
            long newuserid = createTableID("sys_users");
            SQLFactory addusersql = new SQLFactory(this, "账号新增");
            addusersql.addParameter("userid", newuserid);
            addusersql.addParameter("name", changename);
            addusersql.addParameter("password", changepassword);
            addusersql.addParameter("createby", username);
            addusersql.addParameter("phonenumber", changephonenumber);
            addusersql.addParameter("accountno", changeaccountno);
            addusersql.addParameter("remarks", changeremarks);
            addusersql.addParameter("status", isactive ? "ACTIVE" : "INACTIVE");
            sqllist.add(addusersql.getSQL());

            SQLFactory addusersitesql = new SQLFactory(this, "账号站点添加");
            addusersitesql.addParameter("usersiteid", createTableID("sys_usersite"));
            addusersitesql.addParameter("userid", newuserid);
            addusersitesql.addParameter("siteid", siteid);
            addusersitesql.addParameter("createby", username);
            sqllist.add(addusersitesql.getSQL());

            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_usersitelog");
            insertSQL.setValue("sys_usersitelogid", createTableID("sys_usersitelog"));
            insertSQL.setValue("userid", newuserid);
            insertSQL.setValue("siteid", siteid);
            insertSQL.setDateValue("begdate");
            insertSQL.setWhere(" not exists (select *from sys_usersite where userid=" + newuserid + " and siteid='" + siteid + "')");
            sqllist.add(insertSQL.getSQL());
        } else {
            SQLFactory sqlFactory = new SQLFactory(this, "账号修改");
            sqlFactory.addParameter("userid", changeuserid);
            sqlFactory.addParameter("name", changename);
            sqlFactory.addParameter("changeby", username);
            sqlFactory.addParameter("phonenumber", changephonenumber);
            sqlFactory.addParameter("remarks", changeremarks);
            sqlFactory.addParameter("status", isactive ? "ACTIVE" : "INACTIVE");
            sqllist.add(sqlFactory.getSQL());
        }
        dbConnect.runSqlUpdate(sqllist);
        if (userid != changeuserid) {
            loguserout(changeuserid);
        }
        return getSucReturnObject().toString();
    }

    @API(title = "账号站点授权", apiversion = R.ID10017701.v1.class)
    public String addUserSiteid() throws YosException {
        long changeuserid = content.getLongValue("userid");//新增时传0
        JSONArray array = content.getJSONArray("siteids");
        ArrayList<String> siteidlist = new ArrayList<>();
        ArrayList<String> sqlist = new ArrayList<>();
        for (Object o : array) {
            siteidlist.add(o.toString());
            if (dbConnect.runSqlQuery("select *from sys_usersite where userid=" + changeuserid + " and siteid='" + o.toString() + "'").isEmpty()) {
                InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_usersite");
                insertSQL.setValue("usersiteid", createTableID("sys_usersite"));
                insertSQL.setValue("userid", changeuserid);
                insertSQL.setValue("siteid", o.toString());
                insertSQL.setValue("usertype", 1);
                insertSQL.setValue("createby", username);
                insertSQL.setDateValue("createdate");
                sqlist.add(insertSQL.getSQL());

                InsertSQL insertSQL2 = SQLFactory.createInsertSQL(this, "sys_usersitelog");
                insertSQL2.setValue("sys_usersitelogid", createTableID("sys_usersitelog"));
                insertSQL2.setValue("userid", changeuserid);
                insertSQL2.setValue("siteid", o.toString());
                insertSQL2.setDateValue("begdate");
                sqlist.add(insertSQL2.getSQL());
            }
        }
        if (sqlist.size() > 0) {
            dbConnect.runSqlUpdate(sqlist);
            sqlist.clear();
        }

        ArrayList<String> siteidList = dbConnect.runSqlQuery("select siteid from sys_usersite where userid=" + changeuserid).toArrayList("siteid");
        for (String s : siteidList) {
            if (!siteidlist.contains(s)) {
                sqlist.add("delete from sys_usersite where userid=" + changeuserid + " and siteid='" + s + "'");
                sqlist.add("update sys_usersitelog set enddate=now() where userid=" + changeuserid + " and siteid='" + s + "' and enddate is null");
            }
        }
        if (sqlist.size() > 0) {
            dbConnect.runSqlUpdate(sqlist);
        }
        return getSucReturnObject().toString();
    }

    @API(title = "前端配置信息查询", apiversion = R.ID10017801.v1.class)
    public String queryClientConfig() throws YosException {
        Rows rows = dbConnect.runSqlQuery("select config from sys_userclientconfig where siteid='" + siteid + "' and systemclient='" + systemclient + "' and userid=" + userid);
        for (Row row : rows) {
            try {
                row.put("config", Encryption.Decode_Base64(row.getString("config").replace(" ", "\n")));
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return getSucReturnObject().setData(rows.isEmpty() ? new Row() : rows.get(0)).toString();
    }

    @API(title = "前端配置信息更新", apiversion = R.ID10017901.v1.class)
    public String updateClientConfig() throws YosException {
        if (dbConnect.runSqlQuery("select config from sys_userclientconfig where siteid='" + siteid + "' and systemclient='" + systemclient + "' and userid=" + userid).isEmpty()) {
            InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_userclientconfig");
            insertSQL.setValue("config", Encryption.Encode_Base64(content.getString("config")));
            insertSQL.setValue("systemclient", systemclient);
            insertSQL.setValue("userid", userid);
            insertSQL.setValue("siteid", siteid);
            insertSQL.setValue("sys_userclientconfigid", createTableID("sys_userclientconfig"));
            insertSQL.insert();
        } else {
            dbConnect.runSqlUpdate("update sys_userclientconfig set config='" + Encryption.Encode_Base64(content.getString("config")) + "' where siteid='" + siteid + "' and systemclient='" + systemclient + "' and userid=" + userid);
        }
        return getSucReturnObject().toString();
    }
}
