/**
 *
 */
package common.data.db;

import common.YosException;
import common.data.Rows;
import common.parameter.properties;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author SJW
 *
 */
public class DBConnectPool {
    public static HashMap<String, Properties> propertiesMap = new HashMap<String, Properties>();
    /**
     * 数据库连接池
     */
    public static final HashMap<String, LinkedList<Connection>> POOLS_MAP = new HashMap<String, LinkedList<Connection>>();

    private static int day = 0;

    public Connection getConnect(String datakey) {
        synchronized (DBConnectPool.class) {
            Connection connection = null;
            if (POOLS_MAP.containsKey(datakey) && (POOLS_MAP.get(datakey).size()) > 0) {
                connection = POOLS_MAP.get(datakey).remove(0);
            }
            try {
                if (connection == null || connection.isClosed()) {
                    connection = buildConnect(datakey);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            if (day != (day = Calendar.getInstance().get(Calendar.DAY_OF_MONTH))) {
                clean();
            }
            return connection;
        }
    }

    /**
     * 获取数据源
     * @param datakey
     * @return
     */
    private Properties getDataSource(String datakey) throws YosException {
        Properties prop = new Properties();
        switch (datakey) {
            case "default": {
                return properties.getYosProperties();
            }
            default: {
                DBConnect dbConnect = new DBConnect();
                String sql = "select driver,username,password,url from sys_datasource where datakey='" + datakey + "'";
                Rows rows = dbConnect.runSqlQuery(sql);
                if (!rows.isEmpty()) {
                    prop.setProperty("system.db.driver", rows.get(0).getString("driver"));
                    prop.setProperty("system.db.username", rows.get(0).getString("username"));
                    prop.setProperty("system.db.password", rows.get(0).getString("password"));
                    prop.setProperty("system.db.url", rows.get(0).getString("url"));
                } else {
                    return null;
                }
                break;
            }
        }
        return prop;
    }

    private Connection buildConnect(String datakey) throws YosException {
        synchronized (DBConnectPool.class) {
            Connection conn = null;
            if (!propertiesMap.containsKey(datakey)) {
                Properties prop = getDataSource(datakey);
                if (!prop.isEmpty()) {
                    propertiesMap.put(datakey, prop);
                }
            }
            Properties p = propertiesMap.get(datakey);
            try {
                Class.forName(p.getProperty("system.db.driver"));
                conn = DriverManager.getConnection(p.getProperty("system.db.url"), p.getProperty("system.db.username"),
                        p.getProperty("system.db.password"));
                conn.setAutoCommit(false);
                conn.setTransactionIsolation(Connection.TRANSACTION_READ_COMMITTED);
            } catch (Exception e) {
                e.printStackTrace();
                throw new YosException("创建" + datakey + "数据库连接失败！");
            }
            return conn;
        }
    }


    public void close(String datakey, Connection conn) {
        synchronized (DBConnectPool.class) {
            boolean isclose = true;
            try {
                isclose = conn.isClosed();
            } catch (SQLException e1) {
                e1.printStackTrace();
                System.err.println(datakey + "连接关闭失败" + getDateTime_Str() + e1.getMessage());
            }
            if (!isclose) {
                if (!POOLS_MAP.containsKey(datakey)) {
                    LinkedList<Connection> list = new LinkedList<Connection>();
                    POOLS_MAP.put(datakey, list);
                }
                if (POOLS_MAP.get(datakey).size() <= 40) {
                    POOLS_MAP.get(datakey).add(conn);
                } else {
                    try {
                        conn.close();
                    } catch (SQLException e) {
                        e.printStackTrace();
                        System.err.println(datakey + "连接关闭失败" + getDateTime_Str() + e.getMessage());
                    } finally {
                        conn = null;
                    }
                }
            } else {
                conn = null;
            }
        }
    }

    /**
     * 连接池清理
     */
    public void clean() {
        synchronized (DBConnectPool.class) {
            Set<String> set = POOLS_MAP.keySet();
            for (String datakey : set) {
                while (POOLS_MAP.get(datakey).size() > 1) {
                    try {
                        Connection connection = POOLS_MAP.get(datakey).remove(0);
                        if (connection != null && !connection.isClosed()) {
                            connection.close();
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public String getDateTime_Str() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(calendar.getTime());
    }
}
