package common.data;

import beans.department.Department;
import beans.user.User;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.data.db.DBConnect;
import restcontroller.sysmanage.develop.appregistry.appregistry_table;
import utility.tools.Encryption;

import java.util.*;

public class QuerySQL extends BaseSQL<QuerySQL> implements Cloneable {
    private int pageSize = 0;
    private int pageNumber = 0;

    public int pageSize_s = 0;
    // 查询字段<表别名，字段>
    private HashMap<String, ArrayList<String>> queryfieldnames = new HashMap<>();
    //排序
    private ArrayList<String> orderbylist = new ArrayList<>();
    //查询字段（虚拟字段）
    private HashMap<String, String> formulafieldMap = new HashMap<>();

    protected QuerySQL(Controller controller, String tablename) throws YosException {
        super(controller, tablename);
        this.queryfieldnames.put(table_alias, new ArrayList<>());
    }

    /**
     * @param controller
     * @param tablename  主表名
     * @param fieldnames 主表查询的字段
     * @throws YosException
     */
    protected QuerySQL(Controller controller, String tablename, String... fieldnames) throws YosException {
        super(controller, tablename);
        this.queryfieldnames.put(table_alias, new ArrayList<>());
        addQueryFields(fieldnames);
    }

    protected QuerySQL(DBConnect dbConnect, String tablename) throws YosException {
        super(dbConnect, tablename);
        this.queryfieldnames.put(table_alias, new ArrayList<>());
    }

    /**
     * 构造函数
     *
     * @param dbConnect
     * @param tablename  主表名
     * @param fieldnames 主表查询的字段
     * @throws YosException
     */
    protected QuerySQL(DBConnect dbConnect, String tablename, String... fieldnames) throws YosException {
        super(dbConnect, tablename);
        this.queryfieldnames.put(table_alias, new ArrayList<>());
        addQueryFields(fieldnames);
    }


    /**
     * 设置主表别名
     *
     * @param table_alias
     * @return
     */
    public QuerySQL setTableAlias(String table_alias) {
        ArrayList<String> list = this.queryfieldnames.get(this.table_alias);
        this.queryfieldnames.remove(this.table_alias);
        this.queryfieldnames.put(table_alias, list);
        this.table_alias = table_alias;
        return this;
    }

    /**
     * 设置角色数据权限过滤开关，默认开启
     *
     * @param withroledatalimit
     * @return
     */
    public QuerySQL setRoleDataLimit(boolean withroledatalimit) {
        this.withroledatalimit = withroledatalimit;
        return this;
    }

    /**
     * 指定查询的字段，字段前可以指定表名（如存在表别名则为表别名），如不指定表名，则默认该字段为主表字段
     *
     * @param fieldnames
     */
    public QuerySQL addQueryFields(String... fieldnames) {
        for (String fieldname : fieldnames) {
            if (fieldname.contains(".")) {
                String[] c = fieldname.split("\\.");
                String t = c[0];
                String f = c[1];
                if (!this.queryfieldnames.containsKey(t)) {
                    this.queryfieldnames.put(t, new ArrayList<>());
                }
                if (!this.queryfieldnames.get(t).contains(f)) {
                    this.queryfieldnames.get(t).add(f);
                }
            } else if (!this.queryfieldnames.get(table_alias).contains(fieldname)) {
                this.queryfieldnames.get(table_alias).add(fieldname);
            }
        }
        return this;
    }

    /**
     * 指定查询的字段，字段前可以指定表名（如存在表别名则为表别名），如不指定表名，则默认该字段为主表字段
     *
     * @param fieldnames
     */
    public QuerySQL addQueryFields(ArrayList<String> fieldnames) {
        return addQueryFields(fieldnames.toArray(new String[]{}));
    }

    /**
     * 新增虚拟字段，如涉及相关实体字段，需指定所属的表或表别名
     *
     * @param column_name 字段名称
     * @param formula     公式或原字段名称，字段必须指定表名
     */
    public QuerySQL addQueryFields(String column_name, String formula) {
        formulafieldMap.put(column_name, formula);
        return this;
    }

    private ArrayList<String> joinlist = new ArrayList<>();
    private HashMap<String, JOINTYPE> linkjointypeMap = new HashMap<>();
    private HashMap<String, String> linktablenameMap = new HashMap<>();
    private HashMap<String, String> linkconditionMap = new HashMap<>();

    /**
     * 新增关联表
     *
     * @param jointype  关联类型
     * @param tablename 关联表的名称
     * @param linkname  关联别的别名
     * @param condition 关联条件，条件字段不指定表名的情况下，默认为关联表的字段。如果前面加上英文冒号，则表示为主表字段，示例：siteid=:siteid
     *                  允许添加参数，参数需要用$符号进行包裹
     * @return
     * @throws YosException
     */
    public QuerySQL addJoinTable(JOINTYPE jointype, String tablename, String linkname, String condition) throws YosException {
        this.joinlist.add(linkname);
        this.linkjointypeMap.put(linkname, jointype);
        this.linktablenameMap.put(linkname, tablename);
        this.linkconditionMap.put(linkname, conditionHander(condition));
        if (!this.tableColumnNames.containsKey(tablename)) {
            this.tableColumnNames.put(tablename, getTableColumnNames(tablename));
        }
        return this;
    }

    /**
     * @param jointype   关联类型
     * @param tablename  关联表的名称
     * @param linkname   关联别的别名
     * @param condition  关联条件，条件字段不指定表名的情况下，默认为关联表的字段。如果前面加上英文冒号，则表示为主表字段，示例：siteid=:siteid，
     *                   允许添加参数，参数需要用$符号进行包裹
     * @param fieldnames 关联表的查询字段
     * @return
     * @throws YosException
     */
    public QuerySQL addJoinTable(JOINTYPE jointype, String tablename, String linkname, String condition, String... fieldnames) throws YosException {
        this.joinlist.add(linkname);
        linkjointypeMap.put(linkname, jointype);
        linktablenameMap.put(linkname, tablename);
        linkconditionMap.put(linkname, conditionHander(condition));

        ArrayList<String> linkfieldnames = new ArrayList<>();
        for (String fieldname : fieldnames) {
            if (!fieldname.contains(".")) {
                fieldname = linkname + "." + fieldname;
            }
            if (!linkfieldnames.contains(fieldname)) {
                linkfieldnames.add(fieldname);
            }
        }
        this.addQueryFields(linkfieldnames);

        if (!this.tableColumnNames.containsKey(tablename)) {
            this.tableColumnNames.put(tablename, getTableColumnNames(tablename));
        }
        return this;
    }

    public QuerySQL addJoinTable(JOINTYPE jointype, QuerySQL querySQL, String linkname, String condition) throws YosException {
        String tablename = "(" + querySQL.setWithOutOrderBy().getSQL() + ")";
        this.joinlist.add(linkname);
        this.linkjointypeMap.put(linkname, jointype);
        this.linktablenameMap.put(linkname, tablename);
        this.linkconditionMap.put(linkname, conditionHander(condition));

        try {
            if (!this.tableColumnNames.containsKey(tablename)) {
                this.tableColumnNames.put(tablename, querySQL.clone().setWhere(" 1=2 ").query().getFieldList());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public QuerySQL addJoinTable(JOINTYPE jointype, QuerySQL querySQL, String linkname, String condition, String... fieldnames) throws YosException {
        String tablename = "(" + querySQL.setWithOutOrderBy().getSQL() + ")";
        this.joinlist.add(linkname);
        linkjointypeMap.put(linkname, jointype);
        linktablenameMap.put(linkname, tablename);
        linkconditionMap.put(linkname, conditionHander(condition));

        ArrayList<String> linkfieldnames = new ArrayList<>();
        for (String fieldname : fieldnames) {
            if (!fieldname.contains(".")) {
                fieldname = linkname + "." + fieldname;
            }
            if (!linkfieldnames.contains(fieldname)) {
                linkfieldnames.add(fieldname);
            }
        }
        this.addQueryFields(linkfieldnames);

        try {
            if (!this.tableColumnNames.containsKey(tablename)) {
                this.tableColumnNames.put(tablename, querySQL.clone().setWhere(" 1=2 ").query().getFieldList());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }


    private ArrayList<String> groupbyList = new ArrayList<>();
    private boolean isgroupby = false;

    /**
     * 设置查询分组，当查询存在统计函数时，需要执行此方法
     *
     * @param groupformulas
     * @return
     */
    public QuerySQL addGroupBy(String... groupformulas) {
        this.isgroupby = true;
        this.groupbyList.addAll(Arrays.asList(groupformulas));
        return this;
    }


    /**
     * 设置查询排序
     *
     * @param orderbys
     * @return
     */
    public QuerySQL setOrderBy(String... orderbys) {
        if (controller == null || controller.pageSorting == null || controller.pageSorting.equals("") || controller.pageSorting.equals("''")) {
            orderbylist.addAll(Arrays.asList(orderbys));
        }
        return this;
    }

    /**
     * 设置查询分页
     *
     * @param pageSize   每页数量
     * @param pageNumber 页码
     * @return
     */
    public QuerySQL setPage(int pageSize, int pageNumber) {
        if (controller != null && controller.pageSorting != null && !controller.pageSorting.equals("") && !controller.pageSorting.equals("''")) {
            this.orderbylist.clear();
            this.orderbylist.add(controller.pageSorting);
        }

        this.pageSize = pageSize;
        this.pageSize_s = pageSize;
        this.pageNumber = pageNumber;
        return this;
    }


    /**
     * 获取SQL语句
     *
     * @return
     * @throws YosException
     */

    private String rowcountsql = "";

    public String getSQL() throws YosException {
        rowcountsql = "";
        String fields_str = "";
        StringBuilder jointable_str = new StringBuilder();
        StringBuilder where_str = new StringBuilder(" where (1=1) ");
        if (!this.isgroupby && this.queryfieldnames.containsKey(this.table_alias) && this.queryfieldnames.get(this.table_alias).isEmpty()) {
            //如果当前查询没有指定任何字段，则默认查询主表的所有字段
            //如果是分组查询，则一定要指定查询字段
            addQueryFields(this.tableColumnNames.get(tablename));
        }
        if (!this.isgroupby && this.tableColumnNames.get(tablename).contains(getdataversioncolumnname(tablename))) {
            //如果不是分组查询，则默认将数据版本字段加入查询
            this.addQueryFields(getdataversioncolumnname(tablename));
        }
        /*
        开始遍历查询字段并拼接
         */
        for (String tablekey : this.queryfieldnames.keySet()) {
            for (String fieldname : this.queryfieldnames.get(tablekey)) {
                fields_str = fields_str.equals("") ? (tablekey + "." + fieldname) : (fields_str + "," + tablekey + "." + fieldname);
            }
        }

        //处理关联表及字段
        for (String linkname : this.joinlist) {
            String linktablename = linktablenameMap.get(linkname);
            String linkcondition = parameterDo(linkconditionMap.getOrDefault(linkname, ""));
            JOINTYPE jointype = linkjointypeMap.get(linkname);

            //主表字段替换
            for (String tablefield : this.tableColumnNames.get(tablename)) {
                linkcondition = linkcondition.replaceAll(":" + tablefield, table_alias + "." + tablefield);
            }
            //关联表字段替换
            for (String linktablefield : this.tableColumnNames.get(linktablename)) {
                if (linkcondition.contains(" " + linktablefield + " ")) {
                    linkcondition = linkcondition.replaceAll(" " + linktablefield + " ", " " + linkname + "." + linktablefield + " ");
                }
            }
            jointable_str.append(" ").append(jointype.toString()).append(" join ").append(linktablename).append(" as ").append(linkname).append(" on ").append(linkcondition);
        }
        //处理公式字段
        for (String column_name : formulafieldMap.keySet()) {
            fields_str = fields_str.equals("") ? ("(" + formulafieldMap.get(column_name) + ") as " + column_name) : (fields_str + ",(" + formulafieldMap.get(column_name) + ") as " + column_name);
        }
        fields_str = fields_str.equals("") ? "*" : fields_str;

        //处理前端表格字段搜索及排序
        clientFieldFilterAndSort(fields_str, jointable_str.toString());
        //查询条件拼接
        for (String where : wherelist) {
            where_str.append(" and ").append(parameterDo(where));
        }
        //分组拼接
        StringBuilder groupby_str = new StringBuilder();
        if (isgroupby) {
            if (groupbyList.isEmpty()) {
                for (String tkey : queryfieldnames.keySet()) {
                    for (String f : queryfieldnames.get(tkey)) {
                        groupbyList.add(tkey + "." + f);
                    }
                }
            }
            for (String groupby : groupbyList) {
                (groupby_str.toString().equals("") ? groupby_str.append(" group by ") : groupby_str.append(", ")).append(groupby);
            }
        }

        String sql_str = "";
        if (withroledatalimit && controller != null && !controller.getAccesstoken().equals("")) {
            sql_str = "select " + fields_str + " from " + addRoleDataLimit() + jointable_str + where_str + groupby_str;
            if (groupby_str.toString().equals("")) {
                //如果不存在分组，则直接通过sql进行行数查询。如果存在分组，则通过在代码中加入SQL_CALC_FOUND_ROWS 在dbcontent中获取行数
                rowcountsql = "select count(0) as rowscount, CEILING(count(0)/(" + pageSize + "*1.0)) pagecount from " + addRoleDataLimit() + jointable_str + where_str;
            }
        } else {
            sql_str = "select " + fields_str + " from " + tablename + " as " + table_alias + jointable_str + where_str + groupby_str;
            if (groupby_str.toString().equals("")) {
                //如果不存在分组，则直接通过sql进行行数查询。如果存在分组，则通过在代码中加入SQL_CALC_FOUND_ROWS 在dbcontent中获取行数
                rowcountsql = "select count(0) as rowscount, CEILING(count(0)/(" + pageSize + "*1.0)) pagecount from " + tablename + " as " + table_alias + jointable_str + where_str + groupby_str;
            }
        }
        return addPageSQLStr(sql_str);
    }

    //apiid,<fieldname,FieldMeta>
    private static HashMap<String, HashMap<String, FieldMeta>> FieldsMetaMap = new HashMap<>();

    /**
     * 前端字段过滤排序处理
     *
     * @return
     */
    private void clientFieldFilterAndSort(String fields_str, String jointable_str) throws YosException {
        if (pageNumber > 0 && pageSize > 0 && controller != null) {
            long tableid = controller.content.getLongValue("tableid");
            if (tableid > 0) {
                String FieldsMetaMapKey = controller.requestAPI.getId() + "-" + controller.requestAPI.getVersion();
                if (!FieldsMetaMap.containsKey(FieldsMetaMapKey)) {
                    /*
                    获取当前查询的字段信息
                     */
                    FieldsMetaMap.put(FieldsMetaMapKey, controller.dbConnect.runSqlQuery("select " + fields_str + " from " + tablename + " as " + table_alias + jointable_str + " where 1=2").getFieldMetaMap());
                }

                if (controller.content.containsKey("where") && controller.content.getJSONObject("where").containsKey("tablefilter")) {
                    JSONObject tablefilter = controller.content.getJSONObject("where").getJSONObject("tablefilter");
                    //过滤字段名称
                    for (String columnname : tablefilter.keySet()) {
                        String filtervalue = tablefilter.getStringValue(columnname);//过滤值
                        if (!filtervalue.equals("") && FieldsMetaMap.get(FieldsMetaMapKey).containsKey(columnname)) {
                            int filter = appregistry_table.getTableColFilter(controller.siteid, tableid, columnname);//1 精确搜索 2 模糊搜索
                            if (filter > 0) {
                                String table_alias = FieldsMetaMap.get(FieldsMetaMapKey).get(columnname).getTable_alias();//表别名
                                Class fieldclazztype = FieldsMetaMap.get(FieldsMetaMapKey).get(columnname).getFieldtype();//字段类型
                                if (fieldclazztype == Integer.class || fieldclazztype == Long.class || fieldclazztype == Float.class || fieldclazztype == Double.class) {
                                    if (filter == 1) {
                                        setWhere(table_alias + "." + columnname + "=" + filtervalue.replaceFirst("=", ""));
                                    } else if (filter == 2) {
                                        if (filtervalue.startsWith(">=")) {
                                            setWhere(table_alias + "." + columnname + ">=" + filtervalue.replaceFirst(">=", ""));
                                        } else if (filtervalue.startsWith("<=")) {
                                            setWhere(table_alias + "." + columnname + "<=" + filtervalue.replaceFirst("<=", ""));
                                        } else if (filtervalue.startsWith(">")) {
                                            setWhere(table_alias + "." + columnname + ">" + filtervalue.replaceFirst(">", ""));
                                        } else if (filtervalue.startsWith("<")) {
                                            setWhere(table_alias + "." + columnname + "<" + filtervalue.replaceFirst("<", ""));
                                        } else {
                                            setWhere(table_alias + "." + columnname + "=" + filtervalue.replaceFirst("=", ""));
                                        }
                                    }
                                } else if (fieldclazztype == Date.class) {
                                    if (filter == 1) {
                                        setWhere(table_alias + "." + columnname + "='" + filtervalue.replaceFirst("=", "") + "'");
                                    } else if (filter == 2) {
                                        if (filtervalue.startsWith(">=")) {
                                            setWhere(table_alias + "." + columnname + ">='" + filtervalue.replaceFirst(">=", "") + "'");
                                        } else if (filtervalue.startsWith("<=")) {
                                            setWhere(table_alias + "." + columnname + "<='" + filtervalue.replaceFirst("<=", "") + "'");
                                        } else if (filtervalue.startsWith(">")) {
                                            setWhere(table_alias + "." + columnname + ">'" + filtervalue.replaceFirst(">", "") + "'");
                                        } else if (filtervalue.startsWith("<")) {
                                            setWhere(table_alias + "." + columnname + "<'" + filtervalue.replaceFirst("<", "") + "'");
                                        } else if (filtervalue.equalsIgnoreCase("td")) {
                                            setWhere("convert(" + table_alias + "." + columnname + ",date)=convert(now(),date)");
                                        } else if (filtervalue.equalsIgnoreCase("tw")) {
                                            setWhere(table_alias + "." + columnname + ">='" + getWeekFirstDay() + "' and " + table_alias + "." + columnname + "<='" + getWeekLastDay());
                                        } else if (filtervalue.equalsIgnoreCase("tm")) {
                                            setWhere(table_alias + "." + columnname + ">='" + getMonthFirstDay() + "' and " + table_alias + "." + columnname + "<='" + getMonthLastDay());
                                        } else if (filtervalue.equalsIgnoreCase("ty")) {
                                            setWhere("convert(" + table_alias + "." + columnname + ",year)=convert(now(),year)");
                                        } else {
                                            setWhere(table_alias + "." + columnname + "='" + filtervalue.replaceFirst("=", "") + "'");
                                        }
                                    }
                                } else {
                                    if (filter == 1) {
                                        setWhere(table_alias + "." + columnname + "='" + filtervalue.replaceFirst("=", "") + "'");
                                    } else if (filter == 2) {
                                        setWhere(table_alias + "." + columnname + " like '%" + filtervalue + "%'");
                                    }
                                }
                            }
                        }
                    }
                }
                if (controller.content.containsKey("simplesort")) {
                    JSONObject simplesortObject = controller.content.getJSONObject("simplesort");
                    for (String fieldname : simplesortObject.keySet()) {
                        if (FieldsMetaMap.get(FieldsMetaMapKey).containsKey(fieldname)) {
                            if (appregistry_table.getTableColSortable(controller.siteid, tableid, fieldname)) {
                                this.orderbylist.clear();
                                String table_alias = FieldsMetaMap.get(FieldsMetaMapKey).get(fieldname).getTable_alias();//表别名
                                this.orderbylist.add(table_alias + "." + fieldname + (simplesortObject.getBooleanValue(fieldname) ? " asc" : " desc"));
                            }
                        }
                    }
                }
            }
        }
    }

    /**
     * 角色过滤处理
     *
     * @return
     */
    private String addRoleDataLimit() throws YosException {
        String where_str = "1=2";
        if (!tokendatalimitRowsMap.containsKey(controller.getAccesstoken())) {
            RowsMap rowsMap = this.controller.dbConnect.runSqlQuery("select distinct t2.sqlstr,t2.table_name from sys_userrole t1 inner join sys_role_datalimit t2 on t1.roleid=t2.roleid where t1.siteid='" + this.controller.siteid + "' and t1.userid='" + this.controller.userid + "'").toRowsMap("table_name");
            tokendatalimitRowsMap.put(controller.getAccesstoken(), rowsMap);
        }
        Rows limitSqlRows = tokendatalimitRowsMap.get(controller.getAccesstoken()).get(tablename);
        for (Row limitSqlRow : limitSqlRows) {
            String sqlstr = limitSqlRow.getString("sqlstr").trim();
            if (!sqlstr.equals("")) {
                sqlstr = sqlstr.replace(":hrid", String.valueOf(this.controller.hrid));
                sqlstr = sqlstr.replace(":userid", String.valueOf(this.controller.userid));
                sqlstr = sqlstr.replace(":sys_enterpriseid", String.valueOf(this.controller.sys_enterpriseid));
                sqlstr = sqlstr.replace(":departmentid", String.valueOf(this.controller.departmentid));

                if (sqlstr.contains(":subhrids")) {
                    ArrayList<Long> sublist = User.getSubHrIds(this.controller);
                    sublist.add(this.controller.hrid);
                    sqlstr = sqlstr.replace(":subhrids", sublist.toString().replace("[", "(").replace("]", ")"));
                }
                if (sqlstr.contains(":subuserids")) {
                    ArrayList<Long> sublist = User.getSubUserIds(this.controller);
                    sublist.add(this.controller.userid);
                    sqlstr = sqlstr.replace(":subuserids", sublist.toString().replace("[", "(").replace("]", ")"));
                }
                if (sqlstr.contains(":subsys_enterpriseids")) {
                    ArrayList<Long> subhridlist = User.getSubHrIds(this.controller);
                    subhridlist.add(controller.hrid);
                    SQLFactory sqlFactory = new SQLFactory("sql:select distinct sys_enterpriseid from sys_enterprise_tradefield where siteid='" + controller.siteid + "' and hrid in $hrids$");
                    sqlFactory.addParameter_in("hrids", subhridlist);
                    ArrayList<Long> sublist = this.controller.dbConnect.runSqlQuery(sqlFactory.getSQL()).toArrayList("sys_enterpriseid", new ArrayList<>());
                    if (sublist.isEmpty()) {
                        sqlstr = sqlstr.replace(":subsys_enterpriseids", "(null)");
                    } else {
                        sqlstr = sqlstr.replace(":subsys_enterpriseids", sublist.toString().replace("[", "(").replace("]", ")"));
                    }
                }
                if (sqlstr.contains(":subdepartmentids")) {
                    ArrayList<Long> sublist = Department.getSubDepartmentIds(this.controller, this.controller.departmentid);
                    sublist.add(this.controller.departmentid);
                    sqlstr = sqlstr.replace(":subdepartmentids", sublist.toString().replace("[", "(").replace("]", ")"));
                }
                where_str = where_str + " or (" + sqlstr + ")";
            }
        }
        if (where_str.equals("1=2")) {
            if (tablename.equals(table_alias)) {
                return tablename;
            } else {
                return tablename + " as " + table_alias;
            }
        } else {
            return "(select * from " + tablename + " where " + where_str + ") as " + table_alias;
        }
    }


    //查询行数缓存
    private static HashMap<String, Row> queryCountMap = new HashMap<>();
    private static int queryCountHour = 0;

    /**
     * 分页及排序处理
     *
     * @param sql_str
     * @return
     */
    private String addPageSQLStr(String sql_str) throws YosException {
        if (!withoutorderby) {
            String orderby_str = "";
            for (String orderby : orderbylist) {
                orderby_str = orderby_str.equals("") ? orderby : ("," + orderby);
            }
            orderby_str = orderby_str.equals("") ? (table_alias + "." + uniquecolumnname) : orderby_str;
            if (pageNumber > 0 && pageSize > 0) {
                if (dbConnect.getDBProduct().equals("MySQL")) {
                    if (!rowcountsql.equals("")) {
                        if (queryCountHour != Calendar.getInstance().get(Calendar.HOUR_OF_DAY)) {
                            queryCountHour = Calendar.getInstance().get(Calendar.HOUR_OF_DAY);
                            queryCountMap.clear();
                        }
                        Row countrow = null;
                        String queryCountKey = controller.getAccesstoken() + rowcountsql;
                        if (controller != null && queryCountMap.containsKey(queryCountKey)) {
                            countrow = queryCountMap.get(queryCountKey);
                        } else {
                            countrow = dbConnect.runSqlQuery(0, rowcountsql);
                        }
                        long rowscount = countrow.getLong("rowscount");
                        long pagecount = countrow.getBigDecimal("pagecount").longValue();

                        if (rowscount > 10000 && controller != null && !queryCountMap.containsKey(queryCountKey)) {
                            //当总行数超过1万条时，将行数信息进行缓存
                            queryCountMap.put(queryCountKey, countrow);
                        }
                        sql_str = sql_str.replaceFirst("(?i)select", "select " + rowscount + " as total," + pagecount + " as pageTotal," + pageNumber + " as pageNumber," + pageSize + " as pageSize,");
                        sql_str = sql_str + " order by " + orderby_str + " limit " + (pageNumber - 1) * pageSize + "," + pageSize;
                    } else {
                        sql_str = sql_str.replaceFirst("(?i)select", "select SQL_CALC_FOUND_ROWS " + pageNumber + " as pageNumber," + pageSize + " as pageSize,");
                        sql_str = sql_str + " order by " + orderby_str + " limit " + (pageNumber - 1) * pageSize + "," + pageSize;
                    }
                } else {
                    sql_str = sql_str.replaceFirst("(?i)select", "with p2dbconnectstring as (select ROW_NUMBER()over(order by " + orderby_str + " )rowindex,");
                    sql_str = sql_str + " )select * from p2dbconnectstring t1 inner join (select count(0)total,CEILING(count(0)/(" + pageSize + "*1.0)) pageTotal from p2dbconnectstring) t2 on 1=1 where rowindex>(" + pageNumber + "-1)*" + pageSize + " and rowindex<=" + pageNumber + "*" + pageSize;
                }
            } else if (!this.isgroupby) {
                sql_str = sql_str + " order by " + orderby_str;
            }
        }
        return sql_str;
    }

    private boolean withroledatalimit = true;


    private static int day = 0;

    /**
     * 执行查询
     *
     * @return
     * @throws YosException
     */
    public Rows query() throws YosException {
        Rows rows = dbConnect.runSqlQuery(getSQL());
        if (controller != null && pageSize > 0 && pageNumber > 0) {
            int today = Calendar.getInstance().get(Calendar.DATE);
            if (day != today) {
                QuerySQLMap.clear();
                day = today;
            }
            String listqueryid = Encryption.Encode_MD5(controller.getAccesstoken() + "_" + controller.requestAPI.getApi().apiversion().getName());
            QuerySQLMap.put(listqueryid, this);
            rows.listqueryid = listqueryid;
        }
        return rows;
    }

    //查询指定位置的行
    public Rows query(int rowindex) throws YosException {
        Rows rows = new Rows();
        if (controller != null) {
            this.pageSize = 1;
            this.pageNumber = rowindex;
            rows = query();
            if (rows.isNotEmpty()) {
                rows.get(0).put("rowindex", rowindex);
            }
        }
        return rows;
    }

    //用于前端分页查询的上一条下一条功能实现
    public static HashMap<String, QuerySQL> QuerySQLMap = new HashMap<>();

    private static HashMap<String, RowsMap> tokendatalimitRowsMap = new HashMap<>();

    public static void cleanDataLimitRowsMapPool(String accesstoken) throws YosException {
        tokendatalimitRowsMap.remove(accesstoken);
    }

    private String conditionHander(String condition) {
        condition = condition.replaceAll("(?<![.:])\\s*([-+=><()])\\s*(?![.])", " $1 ");
        return " " + condition + " ";
    }

    private boolean withoutorderby = false;

    /**
     * 设置查询不排序。如果当前查询会作为join输入，则不应该进行排序，否则会报错
     *
     * @return
     */
    private QuerySQL setWithOutOrderBy() {
        this.withoutorderby = true;
        return this;
    }
//    public static void main(String[] args) throws YosException {
////        QuerySQL querySQL = new QuerySQL(new DBConnect(), "sys_users");
////        querySQL.addQueryFields("maxid", "max(userid)");
////        querySQL.addGroupBy();
////        querySQL.setTableAlias("t1");
////        System.err.println(querySQL.getSQL());
////        QuerySQL querySQL = SQLFactory.createQuerySQL(new DBConnect(), "sa_logistics_items");
////        querySQL.setTableAlias("t1");
////        querySQL.addJoinTable(JOINTYPE.left, "st_stockbill_items", "t2", "t2.st_stockbill_itemsid=t1.st_stockbill_itemsid and t2.siteid=t1.siteid",
////                "rowno", "itemno", "itemname", "model", "unit", "price", "amount", "remarks");
////        querySQL.addJoinTable(JOINTYPE.left, "st_stockbill", "t3", "t3.st_stockbillid =t2.st_stockbillid and t3.siteid=t2.siteid",
////                "billno");
////        querySQL.setWhere("t1.sa_logisticsid=" + 1);
////        querySQL.setWhere("t1.siteid='asd'");
////        //querySQL.setPage(pageSize, pageNumber).setOrderBy(pageSorting);
////        System.err.println(querySQL.getSQL());
////        //Rows rows = querySQL.query();
//
////        QuerySQL querySQL = new QuerySQL(new DBConnect(), "sys_users");
////        querySQL.addQueryFields("maxid", "max(sys_users.userid)");
////        querySQL.addGroupBy();
//
//        System.err.println(new DBConnect().getDBProduct());
//    }


    @Override
    public QuerySQL clone() throws CloneNotSupportedException {
        return (QuerySQL) super.clone();
    }

}
