/*
 * Decompiled with CFR 0.152.
 */
package utility.sms;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.YosException;
import common.data.InsertSQL;
import common.data.SQLFactory;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.HashMap;
import utility.tools.MessageMonitoringStation;

public class Sms
extends BaseClass {
    private static int hour = 0;

    public void sendout(String phonenumber, String msg) throws YosException {
        this.sendout("", phonenumber, msg);
    }

    public void sendout(String phonenumber, String smsmodel, String[] parameters) throws YosException {
        for (String parameter2 : parameters) {
            smsmodel = smsmodel.replaceFirst("\\{s}", parameter2);
        }
        this.sendout("", phonenumber, smsmodel);
    }

    public void sendout(String siteid, String phonenumber, String smsmodel, String[] parameters) throws YosException {
        for (String parameter2 : parameters) {
            smsmodel = smsmodel.replaceFirst("\\{s}", parameter2);
        }
        this.sendout(siteid, phonenumber, smsmodel);
    }

    public void sendout(String siteid, String phonenumber, String content) throws YosException {
        if (!Parameter.get("system_sms_switch").equalsIgnoreCase("true")) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("account", Parameter.get("chuanglan_sms_account"));
        map.put("password", Parameter.get("chuanglan_sms_password"));
        map.put("msg", content);
        map.put("phone", phonenumber);
        map.put("report", Parameter.get("chuanglan_sms_report"));
        map.put("extend", "");
        JSONObject jsonObject = (JSONObject)JSONObject.toJSON(map);
        String result = this.sendSmsByPost("https://smssh1.253.com/msg/send/json", jsonObject.toString());
        try {
            JSONObject object = JSONObject.parseObject((String)result);
            switch (object.getStringValue("code")) {
                case "109": {
                    MessageMonitoringStation.send("\u521b\u84dd\u77ed\u4fe1\uff08\u65e0\u53d1\u9001\u989d\u5ea6\uff09");
                    break;
                }
                case "118": {
                    MessageMonitoringStation.send("\u521b\u84dd\u77ed\u4fe1\uff08\u7528\u6237\u6ca1\u6709\u76f8\u5e94\u7684\u53d1\u9001\u6743\u9650\uff09");
                    break;
                }
                case "119": {
                    MessageMonitoringStation.send("\u521b\u84dd\u77ed\u4fe1\uff08\u7528\u6237\u5df2\u8fc7\u671f\uff09");
                    break;
                }
                case "120": {
                    MessageMonitoringStation.send("\u521b\u84dd\u77ed\u4fe1\uff08\u8fdd\u53cd\u9632\u76d7\u7528\u7b56\u7565(\u65e5\u53d1\u9001\u9650\u5236)\uff09");
                    break;
                }
                case "134": {
                    MessageMonitoringStation.send("\u521b\u84dd\u77ed\u4fe1\uff08\u8fdd\u53cd\u9632\u76d7\u7b56\u7565, \u8d85\u8fc7\u6708\u53d1\u9001\u9650\u5236\uff09");
                    break;
                }
            }
        }
        catch (Exception object) {
            // empty catch block
        }
        InsertSQL insertSQL = SQLFactory.createInsertSQL(this.dbConnect, "sys_smssendlog");
        insertSQL.setValue("siteid", siteid);
        insertSQL.setValue("phonenumber", phonenumber);
        insertSQL.setValue("content", content);
        insertSQL.insert();
        int HOUR_OF_DAY = Calendar.getInstance().get(11);
        if (hour != HOUR_OF_DAY && HOUR_OF_DAY >= 8) {
            try {
                JSONObject object = JSONObject.parseObject((String)this.queryBalance());
                int smslimitcount = 100;
                if (object.getIntValue("balance") < smslimitcount) {
                    MessageMonitoringStation.send("\u521b\u84dd\u77ed\u4fe1\uff08\u5269\u4f59\u53ef\u7528\u6761\u6570\u5c11\u4e8e" + smslimitcount + "\u6761\uff09");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            hour = HOUR_OF_DAY;
        }
    }

    public String queryBalance() throws YosException {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("account", Parameter.get("chuanglan_sms_account"));
        map1.put("password", Parameter.get("chuanglan_sms_password"));
        JSONObject jsonObject = (JSONObject)JSONObject.toJSON(map1);
        return this.sendSmsByPost("http://smssh1.253.com/msg/balance/json", jsonObject.toString());
    }

    public String sendSmsByPost(String url, String postContent) {
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(url).openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setConnectTimeout(10000);
            httpURLConnection.setReadTimeout(10000);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            httpURLConnection.setRequestProperty("Content-Type", "application/json");
            httpURLConnection.connect();
            OutputStream os = httpURLConnection.getOutputStream();
            os.write(postContent.getBytes(StandardCharsets.UTF_8));
            os.flush();
            StringBuilder sb = new StringBuilder();
            int httpRspCode = httpURLConnection.getResponseCode();
            if (httpRspCode == 200) {
                BufferedReader br = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), StandardCharsets.UTF_8));
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                br.close();
                return sb.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

