/*
 * Decompiled with CFR 0.152.
 */
package common.mq;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.data.InsertSQL;
import common.data.QuerySQL;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.UpdateSQL;
import common.data.db.DBConnect;
import common.mq.MQDatas;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class EventValidate
extends BaseClass {
    private static ExecutorService executorService = Executors.newFixedThreadPool(10);
    private static HashMap<Long, Rows> eventRowsMap = new HashMap();
    private static HashMap<Long, Rows> eventRuleRowsMap = new HashMap();
    private static HashMap<Long, ArrayList<Long>> deviceid_eventidmap = new HashMap();

    public static void put(long w_deviceid, MQDatas.MQData mqData) {
        DBConnect dbConnect = new DBConnect();
        Runnable task = () -> EventValidate.validate(dbConnect, w_deviceid, mqData);
        executorService.execute(task);
    }

    private static void validate(DBConnect dbConnect, long w_deviceid, MQDatas.MQData mqData) {
        try {
            if (!eventRowsMap.containsKey(w_deviceid)) {
                QuerySQL eventQuerySQL = SQLFactory.createQuerySQL(dbConnect, "w_event", "siteid", "w_eventid");
                ((QuerySQL)eventQuerySQL.setWhere("ownertable", "w_device")).setWhere("ownerid", w_deviceid);
                Rows rows = eventQuerySQL.query();
                eventRowsMap.put(w_deviceid, rows);
                deviceid_eventidmap.put(w_deviceid, rows.toArrayList("w_eventid", new ArrayList()));
            }
            Rows eventRows = eventRowsMap.get(w_deviceid);
            block2: for (Row eventRow : eventRows) {
                String siteid = eventRow.getString("siteid");
                long w_eventid = eventRow.getLong("w_eventid");
                if (!eventRuleRowsMap.containsKey(w_eventid)) {
                    QuerySQL eventRuleQuerySQL = SQLFactory.createQuerySQL(dbConnect, "w_event_rule", "w_event_ruleid", "level");
                    ((QuerySQL)eventRuleQuerySQL.setWhere("siteid", siteid)).setWhere("w_eventid", w_eventid);
                    eventRuleQuerySQL.setOrderBy("level");
                    eventRuleRowsMap.put(w_eventid, eventRuleQuerySQL.query());
                }
                Rows eventRuleRows = eventRuleRowsMap.get(w_eventid);
                for (Row eventRuleRow : eventRuleRows) {
                    long w_event_logid;
                    long w_event_ruleid = eventRuleRow.getLong("w_event_ruleid");
                    int level = eventRuleRow.getInteger("level");
                    QuerySQL eventRuleMXQuerySQL = SQLFactory.createQuerySQL(dbConnect, "w_event_rulemx", "symbol", "value");
                    eventRuleMXQuerySQL.addJoinTable(BaseClass.JOINTYPE.inner, "w_dataparam", "w_dataparam", "siteid=:siteid and w_dataparamid=:w_dataparamid", "param", "paramname", "w_dataparamid");
                    ((QuerySQL)eventRuleMXQuerySQL.setWhere("siteid", siteid)).setWhere("w_event_ruleid", w_event_ruleid);
                    Rows eventRuleMXRows = eventRuleMXQuerySQL.query();
                    boolean isevent = true;
                    JSONArray paramvaluesArray = new JSONArray();
                    for (Row eventRuleMXRow : eventRuleMXRows) {
                        long w_dataparamid = eventRuleMXRow.getLong("w_dataparamid");
                        String param = eventRuleMXRow.getString("param");
                        String paramname = eventRuleMXRow.getString("paramname");
                        String symbol = eventRuleMXRow.getString("symbol");
                        String value = eventRuleMXRow.getString("value");
                        if (!mqData.containsKey(param)) continue;
                        Rows row = dbConnect.runSqlQuery("select " + w_event_ruleid + " as w_event_ruleid, where '" + mqData.get(param) + "' " + symbol + " '" + value + "'");
                        if (row.isEmpty()) {
                            isevent = false;
                            break;
                        }
                        JSONObject dataObject = new JSONObject();
                        dataObject.put("param", (Object)param);
                        dataObject.put("paramname", (Object)paramname);
                        dataObject.put("paramvalue", mqData.get(param));
                        dataObject.put("eventvalue", (Object)value);
                        dataObject.put("symbol", (Object)symbol);
                        dataObject.put("w_dataparamid", (Object)w_dataparamid);
                        paramvaluesArray.add((Object)dataObject);
                    }
                    if (!isevent || paramvaluesArray.isEmpty()) continue;
                    ArrayList<String> sqlist = new ArrayList<String>();
                    Rows w_event_logRows = ((QuerySQL)((QuerySQL)((QuerySQL)((QuerySQL)SQLFactory.createQuerySQL(dbConnect, "w_event_log", new String[0]).setSiteid(siteid)).setWhere("w_deviceid", w_deviceid)).setWhere("w_eventid", w_eventid)).setWhere("status in('\u5f85\u5904\u7406','\u5904\u7406\u4e2d')")).query();
                    if (w_event_logRows.isEmpty()) {
                        InsertSQL w_event_logInsertSQL = SQLFactory.createInsertSQL(dbConnect, "w_event_log");
                        w_event_logInsertSQL.setValue("siteid", siteid);
                        w_event_logInsertSQL.setValue("w_deviceid", w_deviceid);
                        w_event_logInsertSQL.setValue("w_eventid", w_eventid);
                        w_event_logInsertSQL.setValue("buildtype", 0);
                        w_event_logInsertSQL.setDateValue("lasteventtime");
                        w_event_logInsertSQL.setValue("lasteventparamvalues", paramvaluesArray);
                        w_event_logInsertSQL.setValue("buildtype", 0);
                        w_event_logInsertSQL.setValue("lasteventlevel", level);
                        w_event_logInsertSQL.setValue("status", "\u5f85\u5904\u7406");
                        sqlist.add(w_event_logInsertSQL.getSQL());
                        w_event_logid = w_event_logInsertSQL.getUniqueid();
                    } else {
                        w_event_logid = w_event_logRows.get(0).getLong("w_event_logid");
                        UpdateSQL w_event_logUpdateSQL = SQLFactory.createUpdateSQL(dbConnect, "w_event_log");
                        ((UpdateSQL)w_event_logUpdateSQL.setSiteid(siteid)).setUniqueid(w_event_logid);
                        w_event_logUpdateSQL.setDateValue("lasteventtime");
                        w_event_logUpdateSQL.setValue("lasteventparamvalues", paramvaluesArray);
                        w_event_logUpdateSQL.setValue("lasteventlevel", level);
                        w_event_logUpdateSQL.update();
                    }
                    InsertSQL insertSQL = SQLFactory.createInsertSQL(dbConnect, "w_event_logmx");
                    insertSQL.setValue("siteid", siteid);
                    insertSQL.setValue("w_event_logid", w_event_logid);
                    insertSQL.setValue("w_event_ruleid", w_event_ruleid);
                    insertSQL.setValue("level", level);
                    insertSQL.setValue("paramvalues", paramvaluesArray);
                    insertSQL.setDateValue("eventtime");
                    sqlist.add(insertSQL.getSQL());
                    dbConnect.runSqlUpdate(sqlist);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void eventRuleInit(long w_deviceid) {
        if (deviceid_eventidmap.containsKey(w_deviceid)) {
            ArrayList<Long> w_eventids = deviceid_eventidmap.get(w_deviceid);
            for (Long w_eventid : w_eventids) {
                eventRuleRowsMap.remove(w_eventid);
            }
            eventRowsMap.remove(w_deviceid);
            deviceid_eventidmap.remove(w_deviceid);
        }
    }
}

