/*
 * Decompiled with CFR 0.152.
 */
package common.data;

import com.alibaba.fastjson.JSONObject;
import com.mchange.v2.util.PropertiesUtils;
import common.Controller;
import common.YosException;
import common.data.DeleteSQL;
import common.data.FieldMeta;
import common.data.InsertSQL;
import common.data.QuerySQL;
import common.data.Rows;
import common.data.SQLProcess;
import common.data.UpdateSQL;
import common.data.db.DBConnect;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class SQLFactory {
    private static HashMap<String, String> modelmap = new HashMap();
    private String SQLMODELNAME;
    private String SQLMODELNAME_KEY;
    private Object o = null;
    private SQLProcess sqlProcess = null;
    HashMap<String, Object> parametermap;
    HashMap<String, String[]> parametermap_array;
    HashMap<String, ArrayList> parametermap_arrayList;
    HashMap<String, String> parametermap_SQL;
    HashMap<String, ArrayList> parametermap_SQL_arrayList;
    public boolean queryforpage = false;
    int pageSize = 0;
    int pageNumber = 0;
    int rowindex = 0;
    String orderfields = "";
    String sqlstr;
    private static HashMap<String, HashMap<String, FieldMeta>> FieldsMetaMap = new HashMap();

    public SQLFactory(String SQLMODELNAME) {
        if (SQLMODELNAME.startsWith("sql:") || SQLMODELNAME.startsWith("SQL:")) {
            this.sqlstr = SQLMODELNAME.replaceFirst("(?i)sql:", "");
            this.SQLMODELNAME = "SQL";
        } else {
            this.SQLMODELNAME_KEY = this.SQLMODELNAME = "SQL/" + SQLMODELNAME;
        }
    }

    public SQLFactory(Object o, String SQLMODELNAME) {
        this.SQLMODELNAME = "SQL/" + SQLMODELNAME;
        this.o = o;
        this.SQLMODELNAME_KEY = o.getClass().getName() + this.SQLMODELNAME;
    }

    @Deprecated
    public SQLFactory(String SQLMODELNAME, int rowindex) {
        if (SQLMODELNAME.startsWith("sql:") || SQLMODELNAME.startsWith("SQL:")) {
            this.sqlstr = SQLMODELNAME.replaceFirst("(?i)sql:", "");
            this.SQLMODELNAME = "SQL";
        } else {
            this.SQLMODELNAME_KEY = this.SQLMODELNAME = "SQL/" + SQLMODELNAME;
        }
        this.rowindex = rowindex;
    }

    @Deprecated
    public SQLFactory(String SQLMODELNAME, int rowindex, String orderfields) {
        if (SQLMODELNAME.startsWith("sql:") || SQLMODELNAME.startsWith("SQL:")) {
            this.sqlstr = SQLMODELNAME.replaceFirst("(?i)sql:", "");
            this.SQLMODELNAME = "SQL";
        } else {
            this.SQLMODELNAME_KEY = this.SQLMODELNAME = "SQL/" + SQLMODELNAME;
        }
        this.rowindex = rowindex;
        this.orderfields = orderfields == null || orderfields.equals("") ? "''" : orderfields;
    }

    @Deprecated
    public SQLFactory(Object o, String SQLMODELNAME, int rowindex) {
        this.SQLMODELNAME = "SQL/" + SQLMODELNAME;
        this.o = o;
        this.rowindex = rowindex;
        this.SQLMODELNAME_KEY = o.getClass().getName() + this.SQLMODELNAME;
    }

    @Deprecated
    public SQLFactory(String SQLMODELNAME, int pageSize, int pageNumber, String orderfields) {
        if (SQLMODELNAME.startsWith("sql:") || SQLMODELNAME.startsWith("SQL:")) {
            this.sqlstr = SQLMODELNAME.replaceFirst("(?i)sql:", "");
            this.SQLMODELNAME = "SQL";
        } else {
            this.SQLMODELNAME_KEY = this.SQLMODELNAME = "SQL/" + SQLMODELNAME;
        }
        this.queryforpage = true;
        this.pageSize = pageSize;
        this.pageNumber = pageNumber;
        this.orderfields = orderfields == null || orderfields.equals("") ? "''" : orderfields;
    }

    @Deprecated
    public SQLFactory(Object o, String SQLMODELNAME, int pageSize, int pageNumber, String orderfields) {
        this.SQLMODELNAME = "SQL/" + SQLMODELNAME;
        this.o = o;
        this.queryforpage = true;
        this.pageSize = pageSize;
        this.pageNumber = pageNumber;
        this.orderfields = orderfields == null || orderfields.equals("") ? "''" : orderfields;
        this.SQLMODELNAME_KEY = o.getClass().getName() + this.SQLMODELNAME;
    }

    @Deprecated
    public SQLFactory(Object o, String SQLMODELNAME, int rowindex, String orderfields) {
        this.SQLMODELNAME = "SQL/" + SQLMODELNAME;
        this.o = o;
        this.rowindex = rowindex;
        this.orderfields = orderfields == null || orderfields.equals("") ? "''" : orderfields;
        this.SQLMODELNAME_KEY = o.getClass().getName() + this.SQLMODELNAME;
    }

    private String getSQLModel() throws YosException {
        if (this.SQLMODELNAME.equals("SQL")) {
            return this.sqlstr;
        }
        if (!this.SQLMODELNAME.contains(".sql") && !this.SQLMODELNAME.contains(".SQL")) {
            this.SQLMODELNAME = this.SQLMODELNAME + ".sql";
        }
        StringBuffer SQL = new StringBuffer();
        if (!modelmap.containsKey(this.SQLMODELNAME_KEY)) {
            InputStream is = null;
            InputStreamReader isr = null;
            try {
                is = this.o != null ? this.o.getClass().getResourceAsStream(this.SQLMODELNAME) : PropertiesUtils.class.getClassLoader().getResourceAsStream(this.SQLMODELNAME);
                isr = new InputStreamReader(is, StandardCharsets.UTF_8);
                char[] ch = new char[2048];
                int byteRead = 0;
                while ((byteRead = isr.read(ch)) != -1) {
                    String str = new String(ch, 0, byteRead);
                    SQL.append(str);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new YosException(this.SQLMODELNAME + "\u8bfb\u53d6\u5931\u8d25");
            }
            finally {
                try {
                    isr.close();
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new YosException(e.getMessage());
                }
            }
            if (SQL.toString().contains("--demo_begin")) {
                SQL = SQL.replace(SQL.indexOf("--demo_begin"), SQL.lastIndexOf("--demo_end") + "--demo_end".length(), "");
            }
            if (!"".equals(SQL.toString().trim())) {
                modelmap.put(this.SQLMODELNAME_KEY, SQL.toString().trim());
            }
        }
        return modelmap.get(this.SQLMODELNAME_KEY);
    }

    public void addParameter(String key, Object value) {
        if (this.parametermap == null) {
            this.parametermap = new HashMap();
        }
        this.parametermap.put(key, value);
    }

    public void addParameter(String key, StringBuffer value) {
        if (this.parametermap == null) {
            this.parametermap = new HashMap();
        }
        this.parametermap.put(key, value.toString());
    }

    public void addParameter_in(String key, String[] value) {
        if (this.parametermap_array == null) {
            this.parametermap_array = new HashMap();
        }
        this.parametermap_array.put(key, value);
    }

    public void addParameter_in(String key, String value) {
        this.addParameter_in(key, new String[]{value});
    }

    public void addParameter_in(String key, Object value) {
        if (value instanceof ArrayList) {
            ArrayList list = (ArrayList)value;
            ArrayList<String> newlist = new ArrayList<String>();
            for (Object o : list) {
                newlist.add(o.toString());
            }
            this.addParameter_in(key, newlist);
        } else if (value.getClass().isArray()) {
            Object[] Objectarray;
            ArrayList<String> newlist = new ArrayList<String>();
            for (Object object : Objectarray = (Object[])value) {
                newlist.add(object.toString());
            }
            this.addParameter_in(key, newlist);
        } else {
            this.addParameter_in(key, String.valueOf(value));
        }
    }

    public void addParameter_in(String key, ArrayList value) {
        if (this.parametermap_arrayList == null) {
            this.parametermap_arrayList = new HashMap();
        }
        this.parametermap_arrayList.put(key, value);
    }

    public void addParameter_SQL(String key, String value) {
        if (this.parametermap_SQL == null) {
            this.parametermap_SQL = new HashMap();
        }
        this.parametermap_SQL.put(key, value);
    }

    public void addParameter_SQL(String key, StringBuffer value) {
        this.addParameter_SQL(key, value.toString());
    }

    public void addParameter_SQL_in(String key, ArrayList value) {
        if (this.parametermap_SQL_arrayList == null) {
            this.parametermap_SQL_arrayList = new HashMap();
        }
        this.parametermap_SQL_arrayList.put(key, value);
    }

    public void addParameter(String key, boolean value) {
        if (this.parametermap == null) {
            this.parametermap = new HashMap();
        }
        this.parametermap.put(key, value ? 1 : 0);
    }

    private String getSQLBase(boolean withroledatalimit) throws YosException {
        Iterator iterator;
        StringBuilder instr;
        Object values;
        Object value;
        String sqlkey;
        String str = this.getSQLModel();
        if (this.parametermap != null) {
            for (String key : this.parametermap.keySet()) {
                sqlkey = "$" + key + "$";
                value = this.parametermap.get(key);
                if (value == null || "null".equalsIgnoreCase(value.toString())) {
                    str = str.replace(sqlkey, "NULL");
                    continue;
                }
                str = str.replace(sqlkey, "'" + value + "'");
            }
        }
        if (this.parametermap_array != null) {
            for (String key : this.parametermap_array.keySet()) {
                sqlkey = "$" + key + "$";
                values = this.parametermap_array.get(key);
                if (values == null || ((String[])values).length == 0) {
                    str = str.replace(sqlkey, "('')");
                    continue;
                }
                instr = new StringBuilder();
                for (Iterator value2 : values) {
                    if (instr.toString().equals("")) {
                        if (String.valueOf(value2).equalsIgnoreCase("null")) {
                            instr = new StringBuilder("NULL");
                            continue;
                        }
                        instr = new StringBuilder("'" + value2 + "'");
                        continue;
                    }
                    if (String.valueOf(value2).equalsIgnoreCase("null")) {
                        instr.append(",NULL");
                        continue;
                    }
                    instr.append(",'").append((String)((Object)value2)).append("'");
                }
                str = str.replace(sqlkey, "(" + instr + ")");
            }
        }
        if (this.parametermap_arrayList != null) {
            for (String key : this.parametermap_arrayList.keySet()) {
                sqlkey = "$" + key + "$";
                values = this.parametermap_arrayList.get(key);
                if (values == null || ((ArrayList)values).size() == 0) {
                    str = str.replace(sqlkey, "('')");
                    continue;
                }
                instr = new StringBuilder();
                iterator = ((ArrayList)values).iterator();
                while (iterator.hasNext()) {
                    Object value3 = iterator.next();
                    if (instr.toString().equals("")) {
                        if (String.valueOf(value3).equalsIgnoreCase("null")) {
                            instr = new StringBuilder("NULL");
                            continue;
                        }
                        instr = new StringBuilder("'" + value3 + "'");
                        continue;
                    }
                    if (String.valueOf(value3).equalsIgnoreCase("null")) {
                        instr.append(",NULL");
                        continue;
                    }
                    instr.append(",'").append(value3).append("'");
                }
                str = str.replace(sqlkey, "(" + instr + ")");
            }
        }
        if (this.parametermap_SQL != null) {
            for (String key : this.parametermap_SQL.keySet()) {
                sqlkey = "$" + key + "$";
                value = this.parametermap_SQL.get(key);
                str = str.replace(sqlkey, (CharSequence)value);
            }
        }
        if (this.parametermap_SQL_arrayList != null) {
            for (String key : this.parametermap_SQL_arrayList.keySet()) {
                sqlkey = "$" + key + "$";
                values = this.parametermap_SQL_arrayList.get(key);
                if (values == null || ((ArrayList)values).size() == 0) {
                    str = str.replace(sqlkey, "()");
                    continue;
                }
                instr = new StringBuilder();
                iterator = ((ArrayList)values).iterator();
                while (iterator.hasNext()) {
                    Object value4 = iterator.next();
                    if (instr.toString().equals("")) {
                        instr = new StringBuilder("" + value4);
                        continue;
                    }
                    instr.append(",").append(value4);
                }
                str = str.replace(sqlkey, "(" + instr + ")");
            }
        }
        if (this.queryforpage && this.o instanceof Controller) {
            JSONObject simplesortObject;
            Rows tablecolRows;
            String table_alias;
            boolean issimplesort;
            Controller controller = (Controller)this.o;
            long tableid = controller.content.getLongValue("tableid");
            boolean istablefilter = str.contains("$tablefilter$") && tableid > 0L;
            boolean bl = issimplesort = controller.content.containsKey("simplesort") && tableid > 0L;
            if ((istablefilter || issimplesort) && !FieldsMetaMap.containsKey(this.SQLMODELNAME_KEY)) {
                FieldsMetaMap.put(this.SQLMODELNAME_KEY, controller.dbConnect.runSqlQuery(str.replace("$tablefilter$", " 1=2 ")).getFieldMetaMap());
            }
            StringBuffer filtersql = new StringBuffer(" 1=1 ");
            if (istablefilter && controller.content.containsKey("where") && controller.content.getJSONObject("where").containsKey("tablefilter")) {
                JSONObject tablefilter = controller.content.getJSONObject("where").getJSONObject("tablefilter");
                for (String columnname : tablefilter.keySet()) {
                    String filtervalue = tablefilter.getStringValue(columnname);
                    if (filtervalue.equals("") || !FieldsMetaMap.get(this.SQLMODELNAME_KEY).containsKey(columnname)) continue;
                    table_alias = FieldsMetaMap.get(this.SQLMODELNAME_KEY).get(columnname).getTable_alias();
                    tablecolRows = controller.dbConnect.runSqlQuery("select distinct filter from sys_systemapp_tablecols where filter in (1,2) and tableid=" + tableid + " and columnname='" + columnname + "'");
                    if (table_alias.equals("") || !tablecolRows.isNotEmpty()) continue;
                    Class fieldclazztype = FieldsMetaMap.get(this.SQLMODELNAME_KEY).get(columnname).getFieldtype();
                    int filter = tablecolRows.get(0).getInteger("filter");
                    if (fieldclazztype == Integer.class || fieldclazztype == Long.class || fieldclazztype == Float.class || fieldclazztype == Double.class || fieldclazztype == Date.class) {
                        if (filter == 1) {
                            filtersql.append(" and ").append(table_alias).append(".").append(columnname).append("='").append(filtervalue).append("'");
                            continue;
                        }
                        if (filter != 2) continue;
                        if (filtervalue.startsWith(">=")) {
                            filtersql.append(" and ").append(table_alias).append(".").append(columnname).append(">='").append(filtervalue.replaceFirst(">=", "")).append("'");
                            continue;
                        }
                        if (filtervalue.startsWith("<=")) {
                            filtersql.append(" and ").append(table_alias).append(".").append(columnname).append("<='").append(filtervalue.replaceFirst("<=", "")).append("'");
                            continue;
                        }
                        if (filtervalue.startsWith(">")) {
                            filtersql.append(" and ").append(table_alias).append(".").append(columnname).append(">'").append(filtervalue.replaceFirst(">", "")).append("'");
                            continue;
                        }
                        if (filtervalue.startsWith("<")) {
                            filtersql.append(" and ").append(table_alias).append(".").append(columnname).append("<'").append(filtervalue.replaceFirst("<", "")).append("'");
                            continue;
                        }
                        filtersql.append(" and ").append(table_alias).append(".").append(columnname).append("='").append(filtervalue.replaceFirst("=", "")).append("'");
                        continue;
                    }
                    if (filter == 1) {
                        filtersql.append(" and ").append(table_alias).append(".").append(columnname).append("='").append(filtervalue).append("'");
                        continue;
                    }
                    if (filter != 2) continue;
                    filtersql.append(" and ").append(table_alias).append(".").append(columnname).append(" like '%").append(filtervalue).append("%'");
                }
            }
            str = str.replace("$tablefilter$", " ( " + filtersql + " ) ");
            if (issimplesort && !(simplesortObject = controller.content.getJSONObject("simplesort")).isEmpty()) {
                for (String fieldname : simplesortObject.keySet()) {
                    if (!FieldsMetaMap.get(this.SQLMODELNAME_KEY).containsKey(fieldname)) continue;
                    boolean isasc = simplesortObject.getBooleanValue(fieldname);
                    table_alias = FieldsMetaMap.get(this.SQLMODELNAME_KEY).get(fieldname).getTable_alias();
                    tablecolRows = controller.dbConnect.runSqlQuery("select sortable from sys_systemapp_tablecols where sortable=1 and tableid=" + tableid + " and columnname='" + fieldname + "'");
                    if (table_alias.equals("") || !tablecolRows.isNotEmpty()) continue;
                    this.orderfields = table_alias + "." + fieldname + (isasc ? " asc" : " desc");
                }
            }
        }
        if (withroledatalimit) {
            try {
                if (this.o != null && this.o.getClass().getSuperclass().getName().equals("common.Controller") && this.sqlProcess == null) {
                    this.sqlProcess = new SQLProcess(this.o, this.SQLMODELNAME_KEY == null ? "" : this.SQLMODELNAME_KEY, str);
                    str = this.sqlProcess.getSQL();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return str;
    }

    public String getSQL() throws YosException {
        return this.getSQL(true);
    }

    public String getSQL(boolean withroledatalimit) throws YosException {
        String str = this.getSQLBase(withroledatalimit);
        if (this.queryforpage) {
            str = str.replaceFirst("(?i)select", "with p2dbconnectstring as (select ROW_NUMBER()over(order by " + this.orderfields + " )rowindex,");
            str = str + " )select * from p2dbconnectstring t1 inner join (select count(0)total,CEILING(count(0)/(" + this.pageSize + "*1.0)) pageTotal from p2dbconnectstring) t2 on 1=1 where rowindex>(" + this.pageNumber + "-1)*" + this.pageSize + " and rowindex<=" + this.pageNumber + "*" + this.pageSize;
        } else if (this.rowindex > 0) {
            if (this.orderfields.equals("")) {
                this.orderfields = "1=1";
            }
            str = str.replaceFirst("(?i)select", "with p2dbconnectstring as (select ROW_NUMBER()over(order by " + this.orderfields + " )rowindex,");
            str = str + " )select * from p2dbconnectstring t1 inner join (select count(0)total from p2dbconnectstring) t2 on 1=1 where rowindex=" + this.rowindex;
        }
        return str;
    }

    public Rows runSqlQuery(DBConnect dbConnect) throws YosException {
        return dbConnect.runSqlQuery(this);
    }

    public void runSqlUpdate(DBConnect dbConnect) throws YosException {
        dbConnect.runSqlUpdate(this);
    }

    public Object getOjbect() {
        return this.o;
    }

    public static InsertSQL createInsertSQL(DBConnect dbConnect, String tablename) throws YosException {
        return new InsertSQL(dbConnect, tablename);
    }

    public static InsertSQL createInsertSQL(Controller controller, String tablename) throws YosException {
        return new InsertSQL(controller, tablename);
    }

    public static UpdateSQL createUpdateSQL(DBConnect dbConnect, String tablename) throws YosException {
        return new UpdateSQL(dbConnect, tablename);
    }

    public static UpdateSQL createUpdateSQL(Controller controller, String tablename) throws YosException {
        return new UpdateSQL(controller, tablename);
    }

    public static DeleteSQL createDeleteSQL(DBConnect dbConnect, String tablename) throws YosException {
        return new DeleteSQL(dbConnect, tablename);
    }

    public static DeleteSQL createDeleteSQL(Controller controller, String tablename) throws YosException {
        return new DeleteSQL(controller, tablename);
    }

    public static QuerySQL createQuerySQL(DBConnect dbConnect, String tablename, String ... fieldnames) throws YosException {
        return new QuerySQL(dbConnect, tablename, fieldnames);
    }

    public static QuerySQL createQuerySQL(Controller controller, String tablename, String ... fieldnames) throws YosException {
        return new QuerySQL(controller, tablename, fieldnames);
    }
}

