/*
 * Decompiled with CFR 0.152.
 */
package common.data;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import common.data.Rows;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class Row
extends HashMap<String, Object> {
    private static final long serialVersionUID = 1L;

    public JSONObject toJsonObject() {
        return (JSONObject)JSON.toJSON((Object)this);
    }

    public Object getValueAsObject(String fieldname) {
        return this.get(fieldname);
    }

    public long getLong(String fieldname) {
        Object object = this.getValueAsObject(fieldname);
        if (object != null) {
            if (object instanceof String) {
                return Long.parseLong(object.toString());
            }
            if (object instanceof Integer) {
                return ((Integer)object).intValue();
            }
            return (Long)object;
        }
        return 0L;
    }

    public float getFloat(String fieldname) {
        Object object = this.getValueAsObject(fieldname);
        if (object != null) {
            if (object instanceof String) {
                return Float.parseFloat(object.toString());
            }
            if (object instanceof Integer) {
                return ((Float)object).floatValue();
            }
            if (object instanceof BigDecimal) {
                return ((BigDecimal)object).floatValue();
            }
            if (object instanceof Float) {
                return ((Float)object).floatValue();
            }
            return ((Float)object).floatValue();
        }
        return 0.0f;
    }

    public String getString(String fieldname) {
        Object object = this.getValueAsObject(fieldname);
        if (object == null || String.valueOf(object).equalsIgnoreCase("null")) {
            return "";
        }
        if (object instanceof Float || object instanceof Double) {
            DecimalFormat df = new DecimalFormat("#");
            return df.format(object);
        }
        return String.valueOf(object);
    }

    public JSONArray getJSONArray(String fieldname) {
        Object object = this.getValueAsObject(fieldname);
        if (object instanceof String && object.toString().equals("")) {
            return new JSONArray();
        }
        try {
            return JSONArray.parseArray((String)object.toString());
        }
        catch (Exception e) {
            return new JSONArray();
        }
    }

    public Rows getRows(String linkname) {
        Object object = this.getValueAsObject(linkname);
        if (object instanceof Rows) {
            return (Rows)object;
        }
        return new Rows();
    }

    public Row getRow(String linkname) {
        Object object = this.getValueAsObject(linkname);
        if (object instanceof Row) {
            return (Row)object;
        }
        return new Row();
    }

    public JSONObject getJSONObject(String fieldname) {
        Object object = this.getValueAsObject(fieldname);
        if (object instanceof String && object.toString().equals("")) {
            return new JSONObject();
        }
        try {
            return JSONObject.parseObject((String)object.toString(), (Feature[])new Feature[]{Feature.OrderedField});
        }
        catch (Exception e) {
            return new JSONObject();
        }
    }

    public Integer getInteger(String fieldname) {
        Object object = this.getValueAsObject(fieldname);
        if (object != null) {
            if (object instanceof String) {
                return Integer.parseInt(object.toString());
            }
            return (Integer)object;
        }
        return 0;
    }

    public Short getShort(String fieldname) {
        Object object = this.getValueAsObject(fieldname);
        if (object != null) {
            if (object instanceof String) {
                return Short.parseShort(object.toString());
            }
            return (Short)object;
        }
        return (short)0;
    }

    public double getDouble(String fieldname) {
        Object object = this.getValueAsObject(fieldname);
        if (object != null) {
            if (object instanceof String || object instanceof Integer) {
                return Double.parseDouble(object.toString());
            }
            if (object instanceof Double) {
                return (Double)object;
            }
            if (object instanceof BigDecimal) {
                return ((BigDecimal)object).doubleValue();
            }
        }
        return 0.0;
    }

    public BigDecimal getBigDecimal(String fieldname) {
        Object object = this.getValueAsObject(fieldname);
        if (object != null) {
            if (object instanceof String) {
                return new BigDecimal(object.toString());
            }
            if (object instanceof Integer) {
                return new BigDecimal((Integer)object);
            }
            if (object instanceof BigDecimal) {
                return (BigDecimal)object;
            }
        }
        return new BigDecimal("0");
    }

    public Boolean getBoolean(String fieldname) {
        Object object = this.getValueAsObject(fieldname);
        if (object != null) {
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (object instanceof String) {
                return "true".equalsIgnoreCase(object.toString()) || "1".equals(object.toString());
            }
            if (object instanceof Short) {
                return (Short)object == 1;
            }
            if (object instanceof Integer) {
                return (Integer)object == 1;
            }
            if (object instanceof Long) {
                return (Long)object == 1L;
            }
        }
        return false;
    }

    public Date getDate(String fieldname) {
        Object object = this.getValueAsObject(fieldname);
        if (object != null) {
            if (object instanceof String) {
                String value = object.toString();
                if (value.length() == 10) {
                    value = value + " 00:00:00.0";
                }
                try {
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(value);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            if (object instanceof Date) {
                return (Date)this.getValueAsObject(fieldname);
            }
            if (object instanceof Timestamp) {
                return new Date(((Timestamp)object).getTime());
            }
        }
        return null;
    }

    public String toXml() {
        Document document = DocumentHelper.createDocument();
        if (this.size() > 0) {
            Iterator it = this.keySet().iterator();
            ArrayList list = new ArrayList();
            while (it.hasNext()) {
                list.add(it.next());
            }
            Element root = document.addElement("rows");
            Element element = root.addElement("row0");
            for (String key : list) {
                Object value = this.get(key);
                Element e = element.addElement(key);
                if (value == null) {
                    e.addText("null");
                    continue;
                }
                e.addText(this.get(key).toString());
            }
        }
        return document.asXML();
    }

    public <T> T toPOJO(T pojo) {
        try {
            Field[] pojofields;
            block27: for (Field field : pojofields = pojo.getClass().getFields()) {
                String fieldtype;
                String fieldname = field.getName();
                if (!this.containsKey(fieldname)) continue;
                switch (fieldtype = field.getType().getSimpleName()) {
                    case "String": {
                        field.set(pojo, this.getString(fieldname));
                        continue block27;
                    }
                    case "Date": {
                        field.set(pojo, this.getDate(fieldname));
                        continue block27;
                    }
                    case "Object": {
                        field.set(pojo, this.getValueAsObject(fieldname));
                        continue block27;
                    }
                    case "int": 
                    case "Integer": {
                        field.set(pojo, this.getInteger(fieldname));
                        continue block27;
                    }
                    case "long": 
                    case "Long": {
                        field.set(pojo, this.getLong(fieldname));
                        continue block27;
                    }
                    case "short": 
                    case "Short": {
                        field.set(pojo, this.getShort(fieldname));
                        continue block27;
                    }
                    case "double": 
                    case "Double": {
                        field.set(pojo, this.getBigDecimal(fieldname));
                        continue block27;
                    }
                    case "boolean": 
                    case "Boolean": {
                        field.set(pojo, this.getBoolean(fieldname));
                        continue block27;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pojo;
    }
}

