package utility.wechat.wechatpay;

import common.BaseClass;
import common.YosException;
import common.data.Row;
import common.data.Rows;
import common.data.db.DBConnect;
import utility.wechat.wechatpay.POJO.*;

import java.util.ArrayList;

public class WechatPay extends BaseClass {
    private String appid;
    private String mch_id;
    private String mch_key;
    private String notify_url = "";//支付结果通知地址

    private WechatPay() {
    }

    /**
     * 构造函数，创建支付订单必须调用该构造函数
     *
     * @param systemclient 微信支付端名称
     * @throws YosException
     */
    public WechatPay(String systemclient) throws YosException {
        DBConnect dbConnect = new DBConnect();
        Rows rows = dbConnect.runSqlQuery("select appid,secret,mch_id from sys_wechatapp where systemclient='" + systemclient + "'");
        if (rows.isNotEmpty()) {
            this.appid = rows.get(0).getString("appid");
            this.mch_id = rows.get(0).getString("mch_id");
            this.mch_key = rows.get(0).getString("mch_key");
        }
    }

    /**
     * 创建一个微信小程序支付订单
     *
     * @param out_trade_no 本地订单
     * @param trade_type   APP、JSAPI、
     * @param openid       用户openid
     * @param custip       客户端IP地址
     * @param ordertype    支付订单类型
     * @param title        支付标题
     * @return
     */
    public CreateOrderResponse createPayOrder(String out_trade_no, String trade_type, String openid, String custip, String ordertype, String title) throws YosException {
        int order_amount = 0;
        Rows sys_payorderRows = dbConnect.runSqlQuery("select amount from sys_payorder where out_trade_no='" + out_trade_no + "'");
        if (sys_payorderRows.isNotEmpty()) {
            order_amount = new Double(sys_payorderRows.get(0).getDouble("amount") * 100).intValue();
        }

        /**
         * 开始创建微信支付订单
         */
        CreateOrderRequest order = new CreateOrderRequest();
        order.setAppid(appid);
        order.setBody(title);
        order.setMch_id(mch_id);
        order.setNotify_url(notify_url);//支付结果通知地址
        order.setOpenid(openid);
        order.setOut_trade_no(out_trade_no);
        order.setSpbill_create_ip(custip);
        order.setTotal_fee(order_amount);
        order.setTrade_type(trade_type);//APP、JSAPI、
        CreateOrderResponse response = order.getOrderResponse(mch_key);
        return response;
    }


    /**
     * 订单查询
     *
     * @param out_trade_no 商户订单号
     * @return
     */
    public void queryOrder(String out_trade_no) throws YosException {
        QueryOrderRequest queryOrderRequest = new QueryOrderRequest();
        queryOrderRequest.setAppid(appid);
        queryOrderRequest.setMch_id(mch_id);
        queryOrderRequest.setOut_trade_no(out_trade_no);
        updatePayOrder(queryOrderRequest.getOrder(mch_key));
    }

    /**
     * 订单关闭
     *
     * @param out_trade_no 商户订单号
     * @return
     */
    public CloseOrderResponse closeOrder(String out_trade_no) {
        CloseOrderRequest closeOrderRequest = new CloseOrderRequest();
        closeOrderRequest.setAppid(appid);
        closeOrderRequest.setMch_id(mch_id);
        closeOrderRequest.setOut_trade_no(out_trade_no);
        return closeOrderRequest.getOrderResponse(mch_key);
    }

    /**
     * 更新本地数据库的订单信息
     */
    public static boolean updatePayOrder(WechatOrder wechatOrder) throws YosException {
        WechatPay wechatPay = new WechatPay();
        String trade_state = wechatOrder.getTrade_state();
        String out_trade_no = wechatOrder.getOut_trade_no();
        Rows sys_payorderRows = wechatPay.dbConnect.runSqlQuery("select * from sys_payorder where orderno='" + out_trade_no + "'");
        for (Row sys_payorderRow : sys_payorderRows) {
            ArrayList<String> sqllist = new ArrayList<>();
            sqllist.add("update sys_payorder set wechatpayorder='" + wechatOrder + "' where orderno='" + out_trade_no + "'");
            if ("SUCCESS".equalsIgnoreCase(trade_state)) {
                sqllist.add("update sys_payorder set ispaid=1,paytime=" + wechatOrder.getTime_end() + " where orderno='" + out_trade_no + "'");
            }
            wechatPay.dbConnect.runSqlUpdate(sqllist);
        }
        return true;
    }
}
