package restcontroller.sysmanage.develop.appregistry;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.SQLFactory;
import restcontroller.R;

import java.util.ArrayList;

@API(title = "管理端-开发-系统应用注册管理-表格管理")
public class appregistry_table extends Controller {

    public appregistry_table(JSONObject content) throws YosException {
        super(content);
    }

    /**
     * 应用表格查询
     *
     * @return
     */
    @API(title = "应用表格查询", apiversion = R.ID10006101.v1.class)
    public String query_apptablelist() throws YosException {
        long systemappid = content.getLong("systemappid");
        SQLFactory sqlFactory = new SQLFactory(this, "应用表格查询");
        sqlFactory.addParameter("systemappid", systemappid);
        Rows rows = dbConnect.runSqlQuery(sqlFactory);
        return getSucReturnObject().setData(rows).toString();
    }

    /**
     * 应用表格新增修改
     *
     * @return
     */
    @API(title = "应用表格新增修改", apiversion = R.ID10006201.v1.class)
    public String insertormodify_apptable() throws YosException {
        String table = content.getString("table");
        String tablename = content.getString("tablename");
        if (table.equals("") || !String.valueOf(table.charAt(0)).matches("^[a-zA-Z]*")) {
            return getErrReturnObject().setErrMsg("表格名称必须以英文字母开头").toString();
        }
        if (!table.matches("^[a-zA-Z0-9]*")) {
            return getErrReturnObject().setErrMsg("表格名称必须为英文字母或英文数字组合").toString();
        }
        if (content.getBooleanValue("isasync")) {
            String systemapp = content.getString("systemapp");
            long systemappid = 0L;

            Rows sys_systemappRows = dbConnect.runSqlQuery("select *from sys_systemapp where systemapp='" + systemapp + "'");
            if (sys_systemappRows.isEmpty()) {
                return getErrReturnObject().setErrMsg("应用" + systemapp + "不存在").toString();
            }
            systemappid = sys_systemappRows.get(0).getLong("systemappid");

            long tableid = 0;
            Rows sys_systemapp_optionsRows = dbConnect.runSqlQuery("select*from sys_systemapp_tables where ifnull(siteids,'')='' and systemappid=" + systemappid + " and `table`='" + table + "'");

            SQLFactory sqlFactory;
            if (sys_systemapp_optionsRows.isEmpty()) {
                tableid = createTableID("sys_systemapp_tables");
                sqlFactory = new SQLFactory(this, "应用表格新增");
                sqlFactory.addParameter("systemappid", systemappid);
                sqlFactory.addParameter("tableid", tableid);
                sqlFactory.addParameter("table", table);
                sqlFactory.addParameter("tablename", tablename);
                sqlFactory.addParameter("siteids", "");
            } else {
                tableid = sys_systemapp_optionsRows.get(0).getLong("tableid");

                sqlFactory = new SQLFactory(this, "应用表格修改");
                sqlFactory.addParameter("tableid", tableid);
                sqlFactory.addParameter("table", table);
                sqlFactory.addParameter("tablename", tablename);
                sqlFactory.addParameter("siteids", "");
            }
            dbConnect.runSqlUpdate(sqlFactory);
            return getSucReturnObject().toString();
        } else {
            long systemappid = content.getLong("systemappid");
            long tableid = content.getLongValue("tableid");//新增时传0
            String siteids = content.getString("siteids");

            SQLFactory sqlFactory;
            if (tableid <= 0 || dbConnect.runSqlQuery("select tableid from sys_systemapp_tables where tableid=" + tableid).isEmpty()) {
                if (dbConnect.runSqlQuery("select *from sys_systemapp_tables where systemappid='" + systemappid + "' and siteids='" + siteids + "' and `table`='" + table + "'").isNotEmpty()) {
                    return getErrReturnObject().setErrMsg("表格注册不可重复").toString();
                }
                tableid = createTableID("sys_systemapp_tables");
                sqlFactory = new SQLFactory(this, "应用表格新增");
                sqlFactory.addParameter("systemappid", systemappid);
                sqlFactory.addParameter("tableid", tableid);
                sqlFactory.addParameter("table", table);
                sqlFactory.addParameter("tablename", tablename);
                sqlFactory.addParameter("siteids", siteids);
            } else {
                if (dbConnect.runSqlQuery("select *from sys_systemapp_tables where tableid!='" + tableid + "' and systemappid='" + systemappid + "' and siteids='" + siteids + "' and `table`='" + table + "'").isNotEmpty()) {
                    return getErrReturnObject().setErrMsg("表格注册不可重复").toString();
                }
                sqlFactory = new SQLFactory(this, "应用表格修改");
                sqlFactory.addParameter("tableid", tableid);
                sqlFactory.addParameter("table", table);
                sqlFactory.addParameter("tablename", tablename);
                sqlFactory.addParameter("siteids", siteids);
            }
            dbConnect.runSqlUpdate(sqlFactory);
            return query_apptablelist();
        }

    }

    /**
     * 应用表格删除
     *
     * @return
     */
    @API(title = "应用表格删除", apiversion = R.ID10006301.v1.class)
    public String delete_apptable() throws YosException {
        long tableid = content.getLong("tableid");
        ArrayList<String> list = new ArrayList<>();
        list.add("delete from sys_systemapp_tables where tableid=" + tableid);
        list.add("delete from sys_systemapp_tablecols where tableid=" + tableid);
        dbConnect.runSqlUpdate(list);
        return getSucReturnObject().toString();
    }

    /**
     * 应用表格查询
     *
     * @return
     */
    @API(title = "应用表格栏位查询", apiversion = R.ID10006401.v1.class)
    public String query_apptablecollist() throws YosException {
        long tableid = content.getLong("tableid");
        SQLFactory sqlFactory = new SQLFactory(this, "应用表格栏位查询");
        sqlFactory.addParameter("tableid", tableid);
        Rows rows = dbConnect.runSqlQuery(sqlFactory);
        return getSucReturnObject().setData(rows).toString();
    }

    /**
     * 应用表格查询
     *
     * @return
     */
    @API(title = "站点应用表格栏位查询", apiversion = R.ID10006501.v1.class)
    public String query_siteapptablecollist() throws YosException {
        long tableid = content.getLong("tableid");
        SQLFactory sqlFactory = new SQLFactory(this, "应用表格栏位查询");
        sqlFactory.addParameter("tableid", tableid);
        Rows rows = dbConnect.runSqlQuery(sqlFactory);

        JSONArray array = new JSONArray();

        Rows siteRows = dbConnect.runSqlQuery("select siteid,sitename from sys_site order by siteuid");
        RowsMap sitetablecolRowsMap = dbConnect.runSqlQuery("select t1.siteid,t1.tablecolid,t1.title,t1.width,t1.hidden,t1.sortable from sys_systemapp_tablecols_site t1 inner join sys_systemapp_tablecols t2 on t1.tablecolid=t2.tablecolid and t2.tableid=" + tableid).toRowsMap("siteid");
        for (Row siteRow : siteRows) {
            String siteid = siteRow.getString("siteid");
            String sitename = siteRow.getString("sitename");

            JSONObject object = new JSONObject();
            object.put("siteid", siteid);
            object.put("sitename", sitename);

            JSONArray sitecolarray = new JSONArray();
            RowsMap map = sitetablecolRowsMap.get(siteid).toRowsMap("tablecolid");
            for (Row colrow : rows) {
                JSONObject sitecolObject = new JSONObject();
                long tablecolid = colrow.getLong("tablecolid");
                sitecolObject.put("tablecolid", tablecolid);
                sitecolObject.put("title_default", colrow.getString("title"));

                if (map.containsKey(String.valueOf(tablecolid))) {
                    Row r = map.get(String.valueOf(tablecolid)).get(0);
                    sitecolObject.put("title", r.getString("title").equals("") ? colrow.getString("title") : r.getString("title"));
                    sitecolObject.put("width", r.getInteger("width") == 0 ? colrow.getInteger("width") : r.getInteger("width"));
                    sitecolObject.put("sequence", r.getInteger("sequence") == 0 ? colrow.getInteger("sequence") : r.getInteger("sequence"));
                    sitecolObject.put("filter", r.getInteger("filter"));
                    sitecolObject.put("hidden", r.getInteger("hidden") == 0 ? colrow.getInteger("hidden") : 1);
                    sitecolObject.put("sortable", r.getInteger("sortable") == 0 ? colrow.getInteger("sortable") : 1);
                    sitecolObject.put("customed", 1);
                } else {
                    sitecolObject.put("title", colrow.getString("title"));
                    sitecolObject.put("width", colrow.getInteger("width"));
                    sitecolObject.put("sequence", colrow.getInteger("sequence"));
                    sitecolObject.put("filter", colrow.getInteger("filter"));
                    sitecolObject.put("hidden", colrow.getInteger("hidden"));
                    sitecolObject.put("sortable", colrow.getInteger("sortable"));
                    sitecolObject.put("customed", 0);
                }
                sitecolarray.add(sitecolObject);
            }
            object.put("list", sitecolarray);
            array.add(object);
        }
        return getSucReturnObject().setData(array).toString();
    }

    /**
     * 应用表格栏位新增修改
     *
     * @return
     */
    @API(title = "应用表格栏位新增修改", apiversion = R.ID10006601.v1.class)
    public String insertormodify_apptablecol() throws YosException {
        if (content.getBooleanValue("isasync")) {
            String systemapp = content.getString("systemapp");
            String table = content.getString("table");
            String columnname = content.getString("columnname");
            String title = content.getString("title");
            int width = content.getInteger("width");
            int filter = content.getIntValue("filter");
            int hidden = content.getIntValue("hidden");
            int sortable = content.getIntValue("sortable");

            Rows sys_systemappRows = dbConnect.runSqlQuery("select *from sys_systemapp where systemapp='" + systemapp + "'");
            if (sys_systemappRows.isEmpty()) {
                return getErrReturnObject().setErrMsg("系统应用" + systemapp + "不存在").toString();
            }
            long systemappid = sys_systemappRows.get(0).getLong("systemappid");

            Rows sys_systemapp_tablesRows = dbConnect.runSqlQuery("select * from sys_systemapp_tables where systemappid='" + systemappid + "' and `table`='" + table + "' ");
            if (sys_systemapp_tablesRows.isEmpty()) {
                return getErrReturnObject().setErrMsg("应用表" + table + "不存在").toString();
            }
            long tableid = sys_systemapp_tablesRows.get(0).getLong("tableid");

            Rows sys_systemapp_tablecolsRows = dbConnect.runSqlQuery("select * from sys_systemapp_tablecols where tableid=" + tableid + " and columnname='" + columnname + "'");

            long tablecolid = 0L;
            SQLFactory sqlFactory;
            if (sys_systemapp_tablecolsRows.isEmpty()) {
                tablecolid = createTableID("sys_systemapp_tablecols");
                sqlFactory = new SQLFactory(this, "应用表格栏位新增");
                sqlFactory.addParameter("tableid", tableid);
                sqlFactory.addParameter("tablecolid", tablecolid);
                sqlFactory.addParameter("columnname", columnname);
                sqlFactory.addParameter("title", title);
                sqlFactory.addParameter("width", width);
                sqlFactory.addParameter("filter", filter);
                sqlFactory.addParameter("hidden", hidden);
                sqlFactory.addParameter("sortable", sortable);
                sqlFactory.addParameter("sequence", 1);
            } else {
                tablecolid = sys_systemapp_tablecolsRows.get(0).getLong("tablecolid");
                sqlFactory = new SQLFactory(this, "应用表格栏位修改");
                sqlFactory.addParameter("tablecolid", tablecolid);
                sqlFactory.addParameter("columnname", columnname);
                sqlFactory.addParameter("title", title);
                sqlFactory.addParameter("width", width);
                sqlFactory.addParameter("filter", filter);
                sqlFactory.addParameter("hidden", hidden);
                sqlFactory.addParameter("sortable", sortable);
            }
            dbConnect.runSqlUpdate(sqlFactory);
            return getSucReturnObject().toString();
        } else {
            long tableid = content.getLong("tableid");
            long tablecolid = content.getLongValue("tablecolid");//新增时传0
            String columnname = content.getString("columnname");
            String title = content.getString("title");
            int width = content.getIntValue("width");
            int filter = content.getIntValue("filter");
            int hidden = content.getIntValue("hidden");
            int sortable = content.getIntValue("sortable");
            SQLFactory sqlFactory;
            if (tablecolid <= 0 || dbConnect.runSqlQuery("select tablecolid from sys_systemapp_tablecols where tablecolid=" + tablecolid).isEmpty()) {

                if (dbConnect.runSqlQuery("select *from sys_systemapp_tablecols where tableid='" + tableid + "' and columnname='" + columnname + "'").isNotEmpty()) {
                    return getErrReturnObject().setErrMsg("表格栏位不可重复").toString();
                }
                tablecolid = createTableID("sys_systemapp_tablecols");
                sqlFactory = new SQLFactory(this, "应用表格栏位新增");
                sqlFactory.addParameter("tableid", tableid);
                sqlFactory.addParameter("tablecolid", tablecolid);
                sqlFactory.addParameter("columnname", columnname);
                sqlFactory.addParameter("title", title);
                sqlFactory.addParameter("width", width);
                sqlFactory.addParameter("filter", filter);
                sqlFactory.addParameter("sequence", 1);
                sqlFactory.addParameter("hidden", hidden);
                sqlFactory.addParameter("sortable", sortable);
            } else {
                if (dbConnect.runSqlQuery("select *from sys_systemapp_tablecols where tablecolid!='" + tablecolid + "' and tableid='" + tableid + "' and columnname='" + columnname + "'").isNotEmpty()) {
                    return getErrReturnObject().setErrMsg("表格栏位不可重复").toString();
                }
                sqlFactory = new SQLFactory(this, "应用表格栏位修改");
                sqlFactory.addParameter("tablecolid", tablecolid);
                sqlFactory.addParameter("columnname", columnname);
                sqlFactory.addParameter("title", title);
                sqlFactory.addParameter("width", width);
                sqlFactory.addParameter("filter", filter);
                sqlFactory.addParameter("hidden", hidden);
                sqlFactory.addParameter("sortable", sortable);
            }
            dbConnect.runSqlUpdate(sqlFactory);
            return query_apptablecollist();
        }
    }

    /**
     * 应用表格栏位新增修改
     *
     * @return
     */
    @API(title = "站点应用表格栏位新增修改", apiversion = R.ID10006701.v1.class)
    public String modify_apptablecol_site() throws YosException {
        long tablecolid = content.getLong("tablecolid");
        String siteid = content.getString("siteid");
        String title = content.getString("title");
        int width = content.getInteger("width");
        int hidden = content.getIntValue("hidden");
        int sortable = content.getIntValue("sortable");

        Rows sys_systemapp_tablecolRows = dbConnect.runSqlQuery("select * from sys_systemapp_tablecols where tablecolid=" + tablecolid);
        if (sys_systemapp_tablecolRows.isEmpty()) {
            return getErrReturnObject().setErrMsg("找不到该表格栏位").toString();
        }

        String title_default = sys_systemapp_tablecolRows.get(0).getString("title");
        int width_default = sys_systemapp_tablecolRows.get(0).getInteger("width");
        int hidden_default = sys_systemapp_tablecolRows.get(0).getInteger("hidden");

        if ((title.trim().equals("") || title.equals(title_default)) && (width == 0 || width == width_default) && (hidden == 0 || hidden == hidden_default)) {
            dbConnect.runSqlUpdate("delete from sys_systemapp_tablecols_site where siteid='" + siteid + "' and tablecolid=" + tablecolid);
            return getSucReturnObject().toString();
        }

        title = title.equals(title_default) ? "" : title;
        width = width == width_default ? 0 : width;
        hidden = hidden == hidden_default ? 0 : hidden;
        if (dbConnect.runSqlQuery("select *from sys_systemapp_tablecols_site where siteid='" + siteid + "'and tablecolid=" + tablecolid).isEmpty()) {
            SQLFactory sqlFactory = new SQLFactory(this, "站点应用表格栏位新增");
            sqlFactory.addParameter("sys_systemapp_tablecols_siteid", createTableID("sys_systemapp_tablecols_site"));
            sqlFactory.addParameter("siteid", siteid);
            sqlFactory.addParameter("tablecolid", tablecolid);
            sqlFactory.addParameter("title", title);
            sqlFactory.addParameter("width", width);
            sqlFactory.addParameter("hidden", hidden);
            sqlFactory.addParameter("sortable", sortable);
            dbConnect.runSqlUpdate(sqlFactory.getSQL());
        } else {
            dbConnect.runSqlUpdate("update sys_systemapp_tablecols_site set title='" + title + "',width=" + width + ",hidden=" + hidden + ",sortable=" + sortable + " where siteid='" + siteid + "' and tablecolid=" + tablecolid);
        }
        return getSucReturnObject().toString();
    }

    /**
     * 应用表格栏位删除
     *
     * @return
     */
    @API(title = "应用表格栏位删除", apiversion = R.ID10006801.v1.class)
    public String delete_apptablecol() throws YosException {
        long tablecolid = content.getLong("tablecolid");
        ArrayList<String> list = new ArrayList<>();
        list.add("delete from sys_systemapp_tablecols where tablecolid=" + tablecolid);
        dbConnect.runSqlUpdate(list);
        return getSucReturnObject().toString();
    }

    @API(title = "应用表格选择")
    public String querytable() throws YosException {
        long systemappid = content.getLong("systemappid");
        /**
         * 过滤条件设置
         */
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("t1.`table` like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.tablename like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.tableid ='").append(whereObject.getString("condition")).append("' ");
                where.append("or t2.systemappname like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
        }

        SQLFactory sqlFactory = new SQLFactory(this, "应用表格选择查询");
        sqlFactory.addParameter("systemappid", systemappid);
        sqlFactory.addParameter_SQL("where", where);
        Rows rows = dbConnect.runSqlQuery(sqlFactory.getSQL());
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "应用表格复制", apiversion = R.ID10006901.v1.class)
    public String duplicatetable() throws YosException {
        long systemappid = content.getLong("systemappid");
        long tableid = content.getLong("tableid");

        ArrayList<String> sqlList = new ArrayList<>();

        Rows tablerows = dbConnect.runSqlQuery("select `table`,tablename from sys_systemapp_tables where tableid=" + tableid);
        for (Row tablerow : tablerows) {
            long newtableid = createTableID("sys_systemapp_tables");

            SQLFactory inserttableSQl = new SQLFactory(this, "应用表格新增");
            inserttableSQl.addParameter("systemappid", systemappid);
            inserttableSQl.addParameter("tableid", newtableid);
            inserttableSQl.addParameter("table", tablerow.getString("table"));
            inserttableSQl.addParameter("tablename", tablerow.getString("tablename"));
            inserttableSQl.addParameter("siteids", "");
            sqlList.add(inserttableSQl.getSQL());

            Rows tablecolrows = dbConnect.runSqlQuery("select columnname,title,width,filter,sequence,hidden,sortable from sys_systemapp_tablecols where tableid=" + tableid);
            for (Row tablecolrow : tablecolrows) {
                SQLFactory inserttablecolSQl = new SQLFactory(this, "应用表格栏位新增");
                inserttablecolSQl.addParameter("tableid", newtableid);
                inserttablecolSQl.addParameter("tablecolid", createTableID("sys_systemapp_tablecols"));
                inserttablecolSQl.addParameter("columnname", tablecolrow.getString("columnname"));
                inserttablecolSQl.addParameter("title", tablecolrow.getString("title"));
                inserttablecolSQl.addParameter("width", tablecolrow.getInteger("width"));
                inserttablecolSQl.addParameter("filter", tablecolrow.getInteger("filter"));
                inserttablecolSQl.addParameter("sequence", tablecolrow.getInteger("sequence"));
                inserttablecolSQl.addParameter("hidden", tablecolrow.getInteger("hidden"));
                inserttablecolSQl.addParameter("sortable", tablecolrow.getInteger("sortable"));
                sqlList.add(inserttablecolSQl.getSQL());
            }
        }
        dbConnect.runSqlUpdate(sqlList);
        return getSucReturnObject().toString();
    }
}
