package restcontroller.sysmanage.develop.appregistry;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.annotation.CACHEING;
import common.annotation.CACHEING_CLEAN;
import common.annotation.cm;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import restcontroller.R;

import java.util.ArrayList;

@API(title = "管理端-开发-系统应用注册管理-网格管理")
public class appregistry_grid extends Controller {

    public appregistry_grid(JSONObject content) throws YosException {
        super(content);
    }

    /**
     * 应用表格查询
     *
     * @return
     */
    @API(title = "应用网格查询", apiversion = R.ID10005701.v1.class)
    @CACHEING
    public String query_appgridlist() throws YosException {
        long systemappid = content.getLong("systemappid");
        SQLFactory sqlFactory = new SQLFactory(this, "应用网格查询");
        sqlFactory.addParameter("systemappid", systemappid);
        Rows rows = dbConnect.runSqlQuery(sqlFactory);
        for (Row row : rows) {
            row.put("layout", JSONObject.parseObject(row.getString("layout")));
        }
        return getSucReturnObject().setData(rows).toString();
    }

    /**
     * 应用表格查询
     *
     * @return
     */
    @API(title = "应用网格详情查询", apiversion = R.ID10005801.v1.class)
    @CACHEING
    public String query_appgridmain() throws YosException {
        long gridid = content.getLongValue("gridid");
        SQLFactory sqlFactory = new SQLFactory(this, "应用网格详情查询");
        sqlFactory.addParameter("gridid", gridid);
        Rows rows = dbConnect.runSqlQuery(sqlFactory);
        for (Row row : rows) {
            row.put("layout", JSONObject.parseObject(row.getString("layout")));
        }
        return getSucReturnObject().setData(rows).toString();
    }

    /**
     * 应用网格新增修改
     *
     * @return
     */
    @API(title = "应用网格新增修改", apiversion = R.ID10005901.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = appregistry_grid.class, method = {"query_appgridlist", "query_appgridmain"})})
    public String insertormodify_appgrid() throws YosException {
        long systemappid = content.getLong("systemappid");
        long gridid = content.getLongValue("gridid");//新增时传0
        String grid = content.getString("grid");
        String gridname = content.getString("gridname");
        String siteids = content.getString("siteids");
        String layout = content.getString("layout");

        if (grid.equals("") || !String.valueOf(grid.charAt(0)).matches("^[a-zA-Z]*")) {
            return getErrReturnObject().setErrMsg("表格名称必须以英文字母开头").toString();
        }
        if (!grid.matches("^[a-zA-Z0-9]*")) {
            return getErrReturnObject().setErrMsg("表格名称必须为英文字母或英文数字组合").toString();
        }
        SQLFactory sqlFactory;
        if (gridid <= 0 || dbConnect.runSqlQuery("select gridid from sys_systemapp_grids where gridid=" + gridid).isEmpty()) {
            gridid = createTableID("sys_systemapp_grids");
            sqlFactory = new SQLFactory(this, "应用网格新增");
            sqlFactory.addParameter("systemappid", systemappid);
            sqlFactory.addParameter("gridid", gridid);
            sqlFactory.addParameter("grid", grid);
            sqlFactory.addParameter("gridname", gridname);
            sqlFactory.addParameter("siteids", siteids);
            sqlFactory.addParameter("layout", layout);
            content.put("gridid", gridid);
        } else {
            sqlFactory = new SQLFactory(this, "应用网格修改");
            sqlFactory.addParameter("gridid", gridid);
            sqlFactory.addParameter("grid", grid);
            sqlFactory.addParameter("gridname", gridname);
            sqlFactory.addParameter("siteids", siteids);
            sqlFactory.addParameter("layout", layout);
        }
        dbConnect.runSqlUpdate(sqlFactory);
        return query_appgridmain();
    }

    /**
     * 应用网格删除
     *
     * @return
     */
    @API(title = "应用网格删除", apiversion = R.ID10006001.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = appregistry_grid.class, method = {"query_appgridlist"})})
    public String delete_appgrid() throws YosException {
        long gridid = content.getLong("gridid");
        ArrayList<String> list = new ArrayList<>();
        list.add("delete from sys_systemapp_grids where gridid=" + gridid);
        dbConnect.runSqlUpdate(list);
        return getSucReturnObject().toString();
    }
}
