package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public class sys_requesterrlog implements YosObject {
    @Override
    public String table_comment() {
        return "接口请求错误日志";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("sys_requesterrlogid", "数据ID");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> arrayList = new ArrayList<>();
        arrayList.add(new VarcharCol("apiid", "apiid", 50));
        arrayList.add(new TextCol("title", "title"));
        arrayList.add(new TextCol("classname", "classname"));
        arrayList.add(new VarcharCol("method", "method", 200));
        arrayList.add(new LongTextCol("message", "message"));
        arrayList.add(new JsonCol("stacktrace", "stacktrace"));
        arrayList.add(new JsonCol("request", "request"));
        arrayList.add(new BigIntCol("userid", "userid"));
        arrayList.add(new VarcharCol("siteid", "siteid", 50));
        arrayList.add(new DateTimeCol("createdate", "createdate"));
        return arrayList;
    }
}
