package common.parameter;

import com.mchange.v2.util.PropertiesUtils;

import java.io.InputStream;
import java.util.Properties;

public class properties {
    private static Properties yosProperties;

    public static Properties getYosProperties() {
        if (yosProperties == null || yosProperties.isEmpty()) {
            yosProperties = new Properties();
            InputStream in = PropertiesUtils.class.getClassLoader().getResourceAsStream("yos.properties");
            try {
                yosProperties.load(in);
            } catch (Exception e) {
                e.printStackTrace();
                yosProperties = null;
            } finally {
                if (yosProperties != null && yosProperties.isEmpty()) {
                    yosProperties = null;
                }
            }
        }
        return yosProperties;
    }

    /**
     * log4j日志参数设置
     *
     * @return
     */
    private static Properties log4jProperties = new Properties();

    public static Properties getLog4jProperties() {
        if (log4jProperties == null || log4jProperties.isEmpty()) {
            log4jProperties = new Properties();
            InputStream in = PropertiesUtils.class.getClassLoader().getResourceAsStream("log4j.properties");
            try {
                log4jProperties.load(in);
            } catch (Exception e) {
                e.printStackTrace();
                log4jProperties = null;
            } finally {
                if (log4jProperties != null && log4jProperties.isEmpty()) {
                    log4jProperties = null;
                }
            }
        }
        return log4jProperties;
    }
}
