package common.mq;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.BaseClass;
import common.data.*;
import common.data.db.DBConnect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class EventValidate extends BaseClass {

    private static ExecutorService executorService = Executors.newFixedThreadPool(10);//线程池

    public static void put(long w_deviceid, MQDatas.MQData mqData) {
        DBConnect dbConnect = new DBConnect();
        Runnable task = () -> validate(dbConnect, w_deviceid, mqData);
        executorService.execute(task);
    }

    private static HashMap<Long, Rows> eventRowsMap = new HashMap<>();
    private static HashMap<Long, Rows> eventRuleRowsMap = new HashMap<>();


    private static void validate(DBConnect dbConnect, long w_deviceid, MQDatas.MQData mqData) {
        try {
            if (!eventRowsMap.containsKey(w_deviceid)) {
                //预警时间查询
                QuerySQL eventQuerySQL = SQLFactory.createQuerySQL(dbConnect, "w_event", "siteid", "w_eventid");
                eventQuerySQL.setWhere("ownertable", "w_device").setWhere("ownerid", w_deviceid);
                Rows rows = eventQuerySQL.query();
                eventRowsMap.put(w_deviceid, rows);
                deviceid_eventidmap.put(w_deviceid, rows.toArrayList("w_eventid", new ArrayList<>()));
            }
            Rows eventRows = eventRowsMap.get(w_deviceid);
            for (Row eventRow : eventRows) {
                String siteid = eventRow.getString("siteid");
                long w_eventid = eventRow.getLong("w_eventid");
                if (!eventRuleRowsMap.containsKey(w_eventid)) {
                    //预警事件等级查询
                    QuerySQL eventRuleQuerySQL = SQLFactory.createQuerySQL(dbConnect, "w_event_rule", "w_event_ruleid", "level");
                    eventRuleQuerySQL.setWhere("siteid", siteid).setWhere("w_eventid", w_eventid);
                    eventRuleQuerySQL.setOrderBy("level");
                    eventRuleRowsMap.put(w_eventid, eventRuleQuerySQL.query());
                }
                Rows eventRuleRows = eventRuleRowsMap.get(w_eventid);
                for (Row eventRuleRow : eventRuleRows) {
                    long w_event_ruleid = eventRuleRow.getLong("w_event_ruleid");
                    int level = eventRuleRow.getInteger("level");

                    QuerySQL eventRuleMXQuerySQL = SQLFactory.createQuerySQL(dbConnect, "w_event_rulemx", "symbol", "value");
                    eventRuleMXQuerySQL.addJoinTable(JOINTYPE.inner, "w_dataparam", "w_dataparam", "siteid=:siteid and w_dataparamid=:w_dataparamid", "param", "paramname", "w_dataparamid");
                    eventRuleMXQuerySQL.setWhere("siteid", siteid).setWhere("w_event_ruleid", w_event_ruleid);
                    Rows eventRuleMXRows = eventRuleMXQuerySQL.query();

                    boolean isevent = true;//是否告警的标识，默认需要告警，循环判断各点位，如果有点位不满足则不需要告警
                    JSONArray paramvaluesArray = new JSONArray();
                    for (Row eventRuleMXRow : eventRuleMXRows) {
                        long w_dataparamid = eventRuleMXRow.getLong("w_dataparamid");
                        String param = eventRuleMXRow.getString("param");
                        String paramname = eventRuleMXRow.getString("paramname");
                        String symbol = eventRuleMXRow.getString("symbol");
                        String value = eventRuleMXRow.getString("value");

                        if (mqData.containsKey(param)) {
                            Rows row = dbConnect.runSqlQuery("select " + w_event_ruleid + " as w_event_ruleid, where '" + mqData.get(param) + "' " + symbol + " '" + value + "'");
                            if (row.isEmpty()) {
                                isevent = false;
                                break;
                            } else {
                                JSONObject dataObject = new JSONObject();
                                dataObject.put("param", param);
                                dataObject.put("paramname", paramname);
                                dataObject.put("paramvalue", mqData.get(param));
                                dataObject.put("eventvalue", value);
                                dataObject.put("symbol", symbol);
                                dataObject.put("w_dataparamid", w_dataparamid);
                                paramvaluesArray.add(dataObject);
                            }
                        }
                    }
                    if (isevent && !paramvaluesArray.isEmpty()) {
                        ArrayList<String> sqlist = new ArrayList<>();
                        //查询设备有无未处理的告警
                        long w_event_logid;
                        Rows w_event_logRows = SQLFactory.createQuerySQL(dbConnect, "w_event_log").setSiteid(siteid).setWhere("w_deviceid", w_deviceid).setWhere("w_eventid", w_eventid).setWhere("status in('待处理','处理中')").query();
                        if (w_event_logRows.isEmpty()) {
                            InsertSQL w_event_logInsertSQL = SQLFactory.createInsertSQL(dbConnect, "w_event_log");
                            w_event_logInsertSQL.setValue("siteid", siteid);
                            w_event_logInsertSQL.setValue("w_deviceid", w_deviceid);
                            w_event_logInsertSQL.setValue("w_eventid", w_eventid);
                            w_event_logInsertSQL.setValue("buildtype", 0);
                            w_event_logInsertSQL.setDateValue("lasteventtime");
                            w_event_logInsertSQL.setValue("lasteventparamvalues", paramvaluesArray);
                            w_event_logInsertSQL.setValue("buildtype", 0);
                            w_event_logInsertSQL.setValue("lasteventlevel", level);
                            w_event_logInsertSQL.setValue("status", "待处理");//待处理、处理中、已处理
                            sqlist.add(w_event_logInsertSQL.getSQL());
                            w_event_logid = w_event_logInsertSQL.getUniqueid();
                        } else {
                            w_event_logid = w_event_logRows.get(0).getLong("w_event_logid");
                            UpdateSQL w_event_logUpdateSQL = SQLFactory.createUpdateSQL(dbConnect, "w_event_log");
                            w_event_logUpdateSQL.setSiteid(siteid).setUniqueid(w_event_logid);
                            w_event_logUpdateSQL.setDateValue("lasteventtime");
                            w_event_logUpdateSQL.setValue("lasteventparamvalues", paramvaluesArray);
                            w_event_logUpdateSQL.setValue("lasteventlevel", level);
                            w_event_logUpdateSQL.update();
                        }
                        InsertSQL insertSQL = SQLFactory.createInsertSQL(dbConnect, "w_event_logmx");
                        insertSQL.setValue("siteid", siteid);
                        insertSQL.setValue("w_event_logid", w_event_logid);
                        insertSQL.setValue("w_event_ruleid", w_event_ruleid);
                        insertSQL.setValue("level", level);
                        insertSQL.setValue("paramvalues", paramvaluesArray);
                        insertSQL.setDateValue("eventtime");
                        sqlist.add(insertSQL.getSQL());
                        dbConnect.runSqlUpdate(sqlist);
                        break;//告警级别由高到低，触发高级报警则不在继续向下验证
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static HashMap<Long, ArrayList<Long>> deviceid_eventidmap = new HashMap<>();

    /**
     * 告警配置缓存清理
     *
     * @param w_deviceid
     */
    public static void eventRuleInit(long w_deviceid) {
        if (deviceid_eventidmap.containsKey(w_deviceid)) {
            ArrayList<Long> w_eventids = deviceid_eventidmap.get(w_deviceid);
            for (Long w_eventid : w_eventids) {
                eventRuleRowsMap.remove(w_eventid);
            }
            eventRowsMap.remove(w_deviceid);
            deviceid_eventidmap.remove(w_deviceid);
        }
    }

//    private static void validate(DBConnect dbConnect, long w_deviceid, MQDatas.MQData mqData) {
//        try {
//            if (!deviceid_eventid_eventruleidListMap.containsKey(w_deviceid)) {
//                QuerySQL querySQL = SQLFactory.createQuerySQL(dbConnect, "w_event", "siteid", "w_eventid", "event", "eventname");
//                querySQL.addJoinTable(BaseClass.JOINTYPE.inner, "w_event_rule", "w_event_rule", "siteid=:siteid and w_eventid=:w_eventid", "w_event_ruleid", "level");
//                querySQL.addJoinTable(BaseClass.JOINTYPE.inner, "w_event_rulemx", "w_event_rulemx", "siteid=:siteid and w_event_ruleid=w_event_rule.w_event_ruleid", "symbol", "value");
//                querySQL.addJoinTable(BaseClass.JOINTYPE.inner, "w_dataparam", "w_dataparam", "siteid=:siteid and w_dataparamid=w_event_rulemx.w_dataparamid", "param", "paramname", "w_dataparamid");
//
//                querySQL.setWhere("ownertable", "w_device");
//                querySQL.setWhere("ownerid", w_deviceid);
//                querySQL.setOrderBy("w_event_rule.level");
//                Rows eventRows = querySQL.query();
//
//                eventruleid_eventMap.putAll(eventRows.toRowsMap("w_event_ruleid"));
//
//                RowsMap w_eventidMap = eventRows.toRowsMap("w_eventid");
//                HashMap<Long, ArrayList<Long>> m = new HashMap<>();
//                for (String w_eventid : w_eventidMap.keySet()) {
//                    m.put(w_deviceid, w_eventidMap.get(w_eventid).toArrayList("w_event_ruleid", new ArrayList<>()));
//                }
//                deviceid_eventid_eventruleidListMap.put(w_deviceid, m);
//            }
//
//            if (deviceid_eventid_eventruleidListMap.containsKey(w_deviceid)) {
//                HashMap<Long, ArrayList<Long>> eventList = deviceid_eventid_eventruleidListMap.get(w_deviceid);
//                for (Long w_eventid : eventList.keySet()) {
//                    ArrayList<Long> eventruleidList = eventList.get(w_eventid);
//                    for (Long w_event_ruleid : eventruleidList) {
//                        boolean isevent = true;//是否告警的标识，默认需要告警，循环判断各点位，如果有点位不满足则不需要告警
//                        String siteid = "";
//                        int level = 0;
//                        JSONArray paramvaluesArray = new JSONArray();
//                        Rows eventRuleMxRows = eventruleid_eventMap.get(String.valueOf(w_event_ruleid));
//                        for (Row eventRuleMxRow : eventRuleMxRows) {
//                            String symbol = eventRuleMxRow.getString("symbol");
//                            String eventvalue = eventRuleMxRow.getString("eventvalue");
//                            String param = eventRuleMxRow.getString("param");
//                            if (mqData.containsKey(param)) {
//                                Rows row = dbConnect.runSqlQuery("select " + w_event_ruleid + " as w_event_ruleid, where '" + mqData.get(param) + "' " + symbol + " '" + eventvalue + "'");
//                                if (row.isEmpty()) {
//                                    isevent = false;
//                                    break;
//                                } else {
//                                    siteid = eventRuleMxRow.getString("siteid");
//                                    level = eventRuleMxRow.getInteger("level");
//
//                                    JSONObject dataObject = new JSONObject();
//                                    dataObject.put("param", param);
//                                    dataObject.put("paramname", eventRuleMxRow.getString("paramname"));
//                                    dataObject.put("paramvalue", mqData.get(param));
//                                    dataObject.put("eventvalue", eventvalue);
//                                    dataObject.put("symbol", symbol);
//                                    dataObject.put("w_dataparamid", eventRuleMxRow.getString("w_dataparamid"));
//                                    paramvaluesArray.add(dataObject);
//                                }
//                            }
//                        }
//                        if (isevent && w_eventid > 0) {
//                            ArrayList<String> sqlist = new ArrayList<>();
//                            //查询设备有无未处理的告警
//                            long w_event_logid;
//                            Rows rows = SQLFactory.createQuerySQL(dbConnect, "w_event_log").setSiteid(siteid).setWhere("w_deviceid", w_deviceid).setWhere("w_eventid", w_eventid).setWhere("status in('待处理','处理中')").query();
//                            if (rows.isEmpty()) {
//                                InsertSQL insertSQL = SQLFactory.createInsertSQL(dbConnect, "w_event_log");
//                                insertSQL.setValue("siteid", siteid);
//                                insertSQL.setValue("w_deviceid", w_deviceid);
//                                insertSQL.setValue("w_eventid", w_eventid);
//                                insertSQL.setValue("buildtype", 0);
//                                insertSQL.setValue("status", "待处理");//待处理、处理中、已处理
//                                sqlist.add(insertSQL.getSQL());
//                                w_event_logid = insertSQL.getUniqueid();
//                            } else {
//                                w_event_logid = rows.get(0).getLong("w_event_logid");
//                            }
//                            InsertSQL insertSQL = SQLFactory.createInsertSQL(dbConnect, "w_event_logmx");
//                            insertSQL.setValue("siteid", siteid);
//                            insertSQL.setValue("w_event_logid", w_event_logid);
//                            insertSQL.setValue("w_event_ruleid", w_event_ruleid);
//                            insertSQL.setValue("level", level);
//                            insertSQL.setValue("paramvalues", paramvaluesArray);
//                            insertSQL.setDateValue("eventtime");
//                            sqlist.add(insertSQL.getSQL());
//                            dbConnect.runSqlUpdate(sqlist);
//                            break;
//                        }
//                    }
//                }
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//
//    }
}
