/*
 * Decompiled with CFR 0.152.
 */
package utility.wechat.wechatpay.nativepay;

import com.alibaba.fastjson.JSONObject;
import com.wechat.pay.contrib.apache.httpclient.Credentials;
import com.wechat.pay.contrib.apache.httpclient.Validator;
import com.wechat.pay.contrib.apache.httpclient.WechatPayHttpClientBuilder;
import com.wechat.pay.contrib.apache.httpclient.auth.AutoUpdateCertificatesVerifier;
import com.wechat.pay.contrib.apache.httpclient.auth.PrivateKeySigner;
import com.wechat.pay.contrib.apache.httpclient.auth.Signer;
import com.wechat.pay.contrib.apache.httpclient.auth.Verifier;
import com.wechat.pay.contrib.apache.httpclient.auth.WechatPay2Credentials;
import com.wechat.pay.contrib.apache.httpclient.auth.WechatPay2Validator;
import com.wechat.pay.contrib.apache.httpclient.util.PemUtil;
import common.BaseClass;
import common.YosException;
import common.data.Row;
import common.data.Rows;
import common.data.db.DBConnect;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.util.ArrayList;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.glassfish.grizzly.http.util.Base64Utils;

public class NativePay
extends BaseClass {
    private String appid;
    private String mch_id;
    private String mch_key;
    private String mchSerialNo = "";
    private String apiV3Key = "";
    private String privateKey = "";
    private String notify_url = "";
    private CloseableHttpClient httpClient;
    private AutoUpdateCertificatesVerifier verifier;

    private NativePay() {
    }

    public NativePay(String systemclient) throws YosException {
        DBConnect dbConnect = new DBConnect();
        Rows rows = dbConnect.runSqlQuery("select appid,secret,mch_id from sys_wechatapp where systemclient='" + systemclient + "'");
        if (rows.isNotEmpty()) {
            this.appid = rows.get(0).getString("appid");
            this.mch_id = rows.get(0).getString("mch_id");
            this.mch_key = rows.get(0).getString("mch_key");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String createPayOrder(String out_trade_no) throws YosException {
        int order_amount = 0;
        Rows sys_payorderRows = this.dbConnect.runSqlQuery("select amount from sys_payorder where out_trade_no='" + out_trade_no + "'");
        if (sys_payorderRows.isNotEmpty()) {
            order_amount = new Double(sys_payorderRows.get(0).getDouble("amount") * 100.0).intValue();
        }
        String codeurl = "";
        try {
            HttpPost httpPost = new HttpPost("https://api.mch.weixin.qq.com/v3/pay/transactions/native");
            JSONObject reqdata = new JSONObject();
            reqdata.put("time_expire", (Object)"2023-04-27T18:30:00+08:00");
            JSONObject amount = new JSONObject();
            amount.put("total", (Object)order_amount);
            amount.put("currency", (Object)"CNY");
            reqdata.put("amount", (Object)amount);
            reqdata.put("mchid", (Object)this.mch_id);
            reqdata.put("description", (Object)"\u7cfb\u7edf\u6388\u6743");
            reqdata.put("notify_url", (Object)this.notify_url);
            reqdata.put("out_trade_no", (Object)out_trade_no);
            reqdata.put("appid", (Object)this.appid);
            reqdata.put("attach", (Object)"\u7f8e\u5927YOS");
            StringEntity entity = new StringEntity(reqdata.toString(), "utf-8");
            entity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)entity);
            httpPost.setHeader("Accept", "application/json");
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    System.out.println("success,return body = " + EntityUtils.toString((HttpEntity)response.getEntity()));
                    String string = codeurl = EntityUtils.toString((HttpEntity)response.getEntity());
                    return string;
                }
                if (statusCode == 204) {
                    System.out.println("success");
                    return codeurl;
                }
                System.out.println("failed,resp code = " + statusCode + ",return body = " + EntityUtils.toString((HttpEntity)response.getEntity()));
                throw new IOException("request failed");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return codeurl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryOrder(String out_trade_no) {
        block9: {
            try {
                HttpGet httpPost = new HttpGet("https://api.mch.weixin.qq.com/v3/pay/transactions/out-trade-no/" + out_trade_no + "?mchid=" + this.mch_id);
                httpPost.setHeader("Accept", "application/json");
                try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode == 200) {
                        System.out.println("success,return body = " + EntityUtils.toString((HttpEntity)response.getEntity()));
                        JSONObject returnobject = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity()));
                        this.updatePayOrder(returnobject);
                        break block9;
                    }
                    if (statusCode == 204) {
                        System.out.println("success");
                        break block9;
                    }
                    System.out.println("failed,resp code = " + statusCode + ",return body = " + EntityUtils.toString((HttpEntity)response.getEntity()));
                    throw new IOException("request failed");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean updatePayOrder(JSONObject wechatOrder) throws YosException {
        String trade_state = wechatOrder.getString("trade_state");
        String out_trade_no = wechatOrder.getString("out_trade_no");
        Rows sys_payorderRows = this.dbConnect.runSqlQuery("select * from sys_payorder where orderno='" + out_trade_no + "'");
        for (Row sys_payorderRow : sys_payorderRows) {
            ArrayList<String> sqllist = new ArrayList<String>();
            sqllist.add("update sys_payorder set wechatpayorder='" + wechatOrder + "' where orderno='" + out_trade_no + "'");
            if ("SUCCESS".equalsIgnoreCase(trade_state)) {
                sqllist.add("update sys_payorder set ispaid=1,paytime=" + wechatOrder.getString("success_time") + " where orderno='" + out_trade_no + "'");
            }
            this.dbConnect.runSqlUpdate(sqllist);
        }
        return true;
    }

    public static boolean updatePayOrder_CallBack(JSONObject returnobject) throws YosException {
        NativePay nativepay = new NativePay();
        if ("\u652f\u4ed8\u6210\u529f".equals(returnobject.getString("summary"))) {
            JSONObject resource = returnobject.getJSONObject("resource");
            String associated_data = resource.getString("associated_data");
            String nonce = resource.getString("nonce");
            String ciphertext = resource.getString("ciphertext");
            String data = nativepay.decryptResponseBody(nativepay.apiV3Key, associated_data, nonce, ciphertext);
            JSONObject wechatOrder = JSONObject.parseObject((String)data);
            return nativepay.updatePayOrder(wechatOrder);
        }
        return false;
    }

    private String decryptResponseBody(String apiV3Key, String associatedData, String nonce, String ciphertext) {
        try {
            byte[] bytes;
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            SecretKeySpec key = new SecretKeySpec(apiV3Key.getBytes(StandardCharsets.UTF_8), "AES");
            GCMParameterSpec spec = new GCMParameterSpec(128, nonce.getBytes(StandardCharsets.UTF_8));
            cipher.init(2, (Key)key, spec);
            cipher.updateAAD(associatedData.getBytes(StandardCharsets.UTF_8));
            try {
                bytes = cipher.doFinal(Base64Utils.decode((String)ciphertext));
            }
            catch (GeneralSecurityException e) {
                throw new IllegalArgumentException(e);
            }
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void setup() {
        PrivateKey merchantPrivateKey = PemUtil.loadPrivateKey((InputStream)new ByteArrayInputStream(this.privateKey.getBytes(StandardCharsets.UTF_8)));
        PrivateKeySigner privateKeySigner = new PrivateKeySigner(this.mchSerialNo, merchantPrivateKey);
        WechatPay2Credentials wechatPay2Credentials = new WechatPay2Credentials(this.mch_id, (Signer)privateKeySigner);
        this.verifier = new AutoUpdateCertificatesVerifier((Credentials)wechatPay2Credentials, this.apiV3Key.getBytes(StandardCharsets.UTF_8));
        WechatPay2Validator wechatPay2Validator = new WechatPay2Validator((Verifier)this.verifier);
        this.httpClient = WechatPayHttpClientBuilder.create().withMerchant(this.mch_id, this.mchSerialNo, merchantPrivateKey).withValidator((Validator)wechatPay2Validator).build();
    }

    public void after() throws IOException {
        this.httpClient.close();
    }
}

