package utility.huawei.obs.mpc;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huaweicloud.sdk.core.auth.BasicCredentials;
import com.huaweicloud.sdk.core.http.HttpConfig;
import com.huaweicloud.sdk.mpc.v1.model.*;
import common.BaseClass;
import common.YosException;
import common.data.Rows;
import common.parameter.properties;
import utility.huawei.obs.Bucket;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class MpcFactory extends BaseClass {
    private HttpConfig httpConfig = null;
    private static BasicCredentials auth;
    private static com.huaweicloud.sdk.mpc.v1.MpcClient mpcClient;

    private String getBucketname(String siteid) {
        String bucketname = null;
        try {
            Rows rows = dbConnect.runSqlQuery("select bucketname from sys_site where siteid='" + siteid + "'");
            if (rows.isNotEmpty()) {
                bucketname = rows.get(0).getString("bucketname").toLowerCase();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return bucketname;
    }

    public MpcFactory() throws YosException {
        httpConfig = HttpConfig.getDefaultHttpConfig().withIgnoreSSLVerification(true).withTimeout(3);
        auth = new BasicCredentials().withAk(Parameter.get("attachment_huawei_obs_ak")).withSk(Parameter.get("attachment_huawei_obs_sk")).withProjectId(Parameter.get("attachment_huawei_obs_projectid"));
        mpcClient = com.huaweicloud.sdk.mpc.v1.MpcClient.newBuilder().withHttpConfig(httpConfig).withCredential(auth).withEndpoint(Parameter.get("attachment_huawei_mpc_endpoint")).build();
    }

    /**
     * 创建视频转码任务
     *
     * @param siteid
     * @param filename
     * @return
     * @throws YosException
     */
    public String createTranscodingTask(String siteid, String filename) throws YosException {
        String bucketname = getBucketname(siteid);
        // 媒体处理服务构造方法

        //设置转码源文件地址
        ObsObjInfo input = new ObsObjInfo().withBucket(bucketname).withLocation(Parameter.get("attachment_huawei_obs_location")).withObject(filename);

        // 设置转码后的文件存放地址
        ObsObjInfo output = new ObsObjInfo().withBucket(bucketname).withLocation(Parameter.get("attachment_huawei_obs_location")).withObject(filename + "-hls/");

        List<Integer> transTempIds = new ArrayList<Integer>();
        transTempIds.add(Integer.parseInt(Parameter.get("attachment_huawei_obs_mpc_transtemplateid")));

        CreateTranscodingTaskRequest createTranscodingTaskRequest = new CreateTranscodingTaskRequest().withBody(new CreateTranscodingReq()
                        .withInput(input)
                        .withOutput(output)
                        //设置转码模板，预置模板Id可以在MPC console页面“全局设置” - “预置模板”上查看
                        .withTransTemplateId(transTempIds)
                        //设置输出名称，名称个数需要与模板个数一一对应
                        .withOutputFilenames(Collections.singletonList(filename))
                //设置截图参数，根据实际需要填充Thumbnail结构
                //.withThumbnail(new Thumbnail())
                //设置加密参数，根据实际需要填充Encryption结构
                //.withEncryption(new Encryption())
        );

        //发送媒体处理服务请求
        CreateTranscodingTaskResponse response = mpcClient.createTranscodingTask(createTranscodingTaskRequest);
        //返回消息
        String taskId = "";
        JSONObject resultObject = (JSONObject) JSON.toJSON(response);
        if (resultObject.containsKey("requestStatus") && "SUCCESS".equalsIgnoreCase(resultObject.getString("requestStatus"))) {
            taskId = resultObject.getString("taskId");
        }
        return taskId;
    }

    /**
     * 查询视频转码任务
     *
     * @param taskId
     * @return
     * @throws YosException
     */
    public MpcFile queryTranscodingTask(String taskId) throws YosException {
        //按单个TaskId查询任务，TaskId是转码请求响应中返回的任务ID
        ListTranscodingTaskRequest req = new ListTranscodingTaskRequest().withTaskId(Collections.singletonList(Long.parseLong(taskId)));
        //发送请求
        ListTranscodingTaskResponse listTranscodingTaskResponse = mpcClient.listTranscodingTask(req);
        JSONObject resultObject = (JSONObject) JSON.toJSON(listTranscodingTaskResponse);
        if (resultObject.containsKey("taskArray")) {
            JSONArray taskArray = resultObject.getJSONArray("taskArray");
            for (Object o : taskArray) {
                JSONObject object = (JSONObject) o;
                if (taskId.equalsIgnoreCase(object.getString("taskId"))) {
                    MpcFile mpcFile = new MpcFile();
                    mpcFile.setTask_id(taskId);
                    if ((object.getJSONArray("outputFileName").isEmpty())) {
                        return null;
                    } else {
                        mpcFile.setOutput_file_name(object.getJSONArray("outputFileName").getString(0));
                    }
                    JSONObject outputObject = object.getJSONObject("output");
                    mpcFile.setBucket(outputObject.getString("bucket"));
                    mpcFile.setLocation(outputObject.getString("location"));
                    mpcFile.setObject(outputObject.getString("object"));
                    return mpcFile;
                }
            }
        }
        return null;
    }

    /**
     * 获取视频文件参数
     *
     * @param siteid
     * @param filename
     * @return
     */
    public MediaMetaData getMetaData(String siteid, String filename) throws YosException {
        String bucketname = getBucketname(siteid);
        MediaMetaData mediaMetaData = new MediaMetaData();
        //设置解析输入视频地址和输出路径
        ObsObjInfo input = new ObsObjInfo().withBucket(bucketname).withLocation(Parameter.get("attachment_huawei_obs_location")).withObject(filename);
        //创建解析请求
        CreateExtractTaskRequest req = new CreateExtractTaskRequest()
                .withBody(new CreateExtractTaskReq().withInput(input).withSync(1));
        //发送解析请求
        try {
            CreateExtractTaskResponse rsp = mpcClient.createExtractTask(req);
            JSONObject resultObject = (JSONObject) JSON.toJSON(rsp);
            if ("SUCCEED".equalsIgnoreCase(resultObject.getString("status"))) {
                JSONObject metadataObject = resultObject.getJSONObject("metadata");
                mediaMetaData.setStatus(true);
                mediaMetaData.setDuration(metadataObject.getIntValue("duration"));
                mediaMetaData.setSize(metadataObject.getLongValue("size"));
                mediaMetaData.setFormat(metadataObject.getString("format"));
                if (metadataObject.containsKey("video")) {
                    JSONArray videoArray = metadataObject.getJSONArray("video");
                    Iterator it = videoArray.iterator();
                    while (it.hasNext()) {
                        JSONObject videoObjcet = (JSONObject) it.next();
                        mediaMetaData.setCodec(videoObjcet.getString("codec"));
                        mediaMetaData.setFrameRate(videoObjcet.getIntValue("frameRate"));
                        mediaMetaData.setWidth(videoObjcet.getIntValue("width"));
                        mediaMetaData.setHeight(videoObjcet.getIntValue("height"));
                        mediaMetaData.setBitrate(videoObjcet.getLongValue("bitrate"));
                    }
                }
            } else {
                mediaMetaData.setStatus(false);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return mediaMetaData;
    }

    /**
     * 创建视频截图任务
     *
     * @param siteid            桶名称
     * @param filename          华为云文件名称
     * @param thumbnailfilename 截图文件名称
     * @param width             截图宽度
     * @param height            截图高度
     * @param dot               截图位置
     * @return
     * @throws YosException
     */
    public boolean createThumbnailsTask(String siteid, String filename, String thumbnailfilename, int width, int height, int dot) throws YosException {
        String bucketname = getBucketname(siteid);
        //设置转码源文件地址
        ObsObjInfo input = new ObsObjInfo().withBucket(bucketname).withLocation(Parameter.get("attachment_huawei_mpc_endpoint")).withObject(filename);
        // 设置转码后的文件存放地址
        ObsObjInfo output = new ObsObjInfo().withBucket(bucketname).withLocation(Parameter.get("attachment_huawei_mpc_endpoint")).withObject("/");

        CreateThumbnailsTaskRequest req = new CreateThumbnailsTaskRequest().withBody(new CreateThumbReq().withInput(input).withOutput(output)
                //设置截图类型,此处理按时间点截图
                .withThumbnailPara(new ThumbnailPara().withType(ThumbnailPara.TypeEnum.DOTS)
                        //设置截图输出文件名称
                        .withOutputFilename(thumbnailfilename)
                        //设置截图的时间点
                        .withDots(Collections.singletonList(dot))
                        //设置截图的宽
                        .withWidth(width)
                        //设置截图的高
                        .withHeight(height)).withSync(1).withOriginalDir(1));
        //发送媒体处理服务请求
        CreateThumbnailsTaskResponse rsp = mpcClient.createThumbnailsTask(req);
        //返回消息
        JSONObject resultObject = (JSONObject) JSON.toJSON(rsp);
        return "FINISHED".equalsIgnoreCase(resultObject.getStringValue("status"));
    }


    /**
     * 创建视频动图
     *
     * @param siteid   桶名称
     * @param filename 视频文件名称
     * @param width    动图宽
     * @param height   动图长
     * @return 创建动图任务id
     * @throws YosException
     */
    public String createAnimatedGraphicsTask(String siteid, String filename, int width, int height) throws YosException {
        String bucketname = getBucketname(siteid);
        //设置转码源文件地址
        ObsObjInfo input = new ObsObjInfo().withBucket(bucketname).withLocation(Parameter.get("attachment_huawei_mpc_endpoint")).withObject(filename);
        // 设置转码后的文件存放地址
        ObsObjInfo output = new ObsObjInfo().withBucket(bucketname).withLocation(Parameter.get("attachment_huawei_mpc_endpoint")).withObject("/");

        CreateAnimatedGraphicsTaskRequest req = new CreateAnimatedGraphicsTaskRequest().withBody(new CreateAnimatedGraphicsTaskReq().withInput(input).withOutput(output)
                .withOutputParam(new AnimatedGraphicsOutputParam().
                        //设置动图格式
                                withFormat(AnimatedGraphicsOutputParam.FormatEnum.GIF)
                        //设置动图帧率
                        .withFrameRate(15)
                        //设置起始时间，单位毫秒
                        .withStart(0)
                        .withEnd(3000)
                        //设置截图的宽
                        .withWidth(width)
                        //设置截图的高
                        .withHeight(height)));
        //发送媒体处理服务请求
        CreateAnimatedGraphicsTaskResponse rsp = mpcClient.createAnimatedGraphicsTask(req);
        //返回消息
        JSONObject resultObject = (JSONObject) JSON.toJSON(rsp);
        if (resultObject.containsKey("taskId")) {
            return resultObject.getString("taskId");
        }
        return "";
    }

    /**
     * 视频动图查询
     *
     * @param taskId 创建动图任务id
     * @return 动图文件名称
     * @throws YosException
     */
    public String queryAnimatedGraphicsTask(String taskId) throws YosException {
        if (taskId.equalsIgnoreCase("")) {
            return "";
        }
        ListAnimatedGraphicsTaskRequest req = new ListAnimatedGraphicsTaskRequest().withTaskId(Collections.singletonList(taskId));
        // 发送查询动图任务请求给媒体处理服务
        ListAnimatedGraphicsTaskResponse rsp = mpcClient.listAnimatedGraphicsTask(req);
        // 打印返回消息
        JSONObject resultObject = (JSONObject) JSON.toJSON(rsp);
        if (resultObject.containsKey("tasks") && !resultObject.getJSONArray("tasks").isEmpty()) {
            JSONArray tasksArray = resultObject.getJSONArray("tasks");
            for (Object o : tasksArray) {
                JSONObject taskobject = (JSONObject) o;
                if (taskobject.getString("status").equalsIgnoreCase("SUCCEED")) {
                    return taskobject.getJSONObject("output").getString("fileName");
                }
            }
        }
        return "";
    }
}
