package objectregister;

import common.YosException;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public class sys_systemapp_forms implements YosObject {

    @Override
    public String table_comment() {
        return "系统应用表单注册表";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("formid", "数据ID");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> list = new ArrayList<>();
        list.add(new VarcharCol("form", "表单名称", 50));
        list.add(new VarcharCol("formname", "表单描述", 200));
        list.add(new BigIntCol("systemappid", "应用ID"));
        return list;
    }

    @Override
    public void DataInit() throws YosException {

    }
}
