package objectregister;

import common.YosException;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public class sys_systemapp_formcols implements YosObject {

    @Override
    public String table_comment() {
        return "系统应用表单栏位设置表";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("formcolid", "数据ID");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> list = new ArrayList<>();
        list.add(new BigIntCol("formid", "表单ID"));
        list.add(new VarcharCol("columnname", "字段名称", 50));
        list.add(new VarcharCol("title", "字段标题", 50));
        list.add(new LongTextCol("script", "执行脚本"));
        list.add(new SmallIntCol("required", "是否必填", 0));
        list.add(new SmallIntCol("hidden", "是否隐藏", 0));
        return list;
    }
    @Override
    public void DataInit() throws YosException {

    }
}
