/*
 * Decompiled with CFR 0.152.
 */
package objectregister.javapoet;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import common.YosException;
import common.data.Row;
import common.data.RowsMap;
import common.data.db.DBConnect;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.io.File;
import java.util.ArrayList;
import javax.lang.model.element.Modifier;

public class ObjectRegister {
    public static String filepath = "./YOS_CORE/src/core";
    public static String packagename = "objectregister";
    private TypeSpec.Builder builder;
    private DBConnect dbConnect = new DBConnect();
    private Row tableRow;
    private RowsMap columnRowsMap;

    public static void main(String[] args) throws YosException {
        new ObjectRegister(filepath, packagename, "sys_report");
    }

    public ObjectRegister(String filepath, String packagename, String table_name) throws YosException {
        this.tableRow = this.dbConnect.runSqlQuery(0, "select table_comment,uniquecolumnname from sys_object where table_name='" + table_name + "'");
        this.columnRowsMap = this.dbConnect.runSqlQuery("select * from sys_objectcols where table_name='" + table_name + "'").toRowsMap("column_name");
        this.builder = TypeSpec.classBuilder((String)table_name);
        this.builder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        this.builder.addSuperinterface(YosObject.class);
        this.builder.addMethod(this.addTable_comment());
        this.builder.addMethod(this.addUniquecolumn());
        this.builder.addMethod(this.addTable_cols());
        try {
            TypeSpec testCode = this.builder.build();
            JavaFile javaFile = JavaFile.builder((String)packagename, (TypeSpec)testCode).build();
            File file = new File(filepath);
            javaFile.writeTo(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private MethodSpec addTable_comment() {
        MethodSpec methodSpec = MethodSpec.methodBuilder((String)"table_comment").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addCode("return \"" + this.tableRow.getString("table_comment") + "\";", new Object[0]).build();
        return methodSpec;
    }

    private MethodSpec addUniquecolumn() throws YosException {
        String uniquecolumnname = this.tableRow.getString("uniquecolumnname");
        String column_title = this.columnRowsMap.get(uniquecolumnname).get(0).getString("column_title");
        MethodSpec methodSpec = MethodSpec.methodBuilder((String)"uniquecolumn").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(YosObject.UniqueCol.class).addCode("return new UniqueCol(\"" + uniquecolumnname + "\", \"" + column_title + "\");", new Object[0]).build();
        return methodSpec;
    }

    private MethodSpec addTable_cols() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"table_cols").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ArrayList.class), (TypeName[])new TypeName[]{ClassName.get(YosObjectCol.class)}));
        this.columnRowsMap.remove(this.tableRow.getString("uniquecolumnname"));
        builder.addCode("ArrayList<YosObjectCol> arrayList = new ArrayList<>();\n", new Object[0]);
        for (String column_name : this.columnRowsMap.keySet()) {
            Row columnRow = this.columnRowsMap.get(column_name).getRow(0);
            String column_title = columnRow.getString("column_title");
            String column_comment = columnRow.getString("column_comment");
            int numeric_precision = columnRow.getInteger("numeric_precision");
            int numeric_scale = columnRow.getInteger("numeric_scale");
            boolean is_nullable = columnRow.getBoolean("is_nullable");
            boolean uniqued = columnRow.getBoolean("uniqued");
            boolean savedatalog = columnRow.getBoolean("savedatalog");
            String column_default = columnRow.getString("column_default");
            int sequence = columnRow.getInteger("sequence");
            switch (columnRow.getString("column_type")) {
                case "varchar": {
                    builder.addCode("arrayList.add(new VarcharCol(\"" + column_name + "\", \"" + column_title + "\", \"" + column_comment + "\", " + numeric_precision + ", " + is_nullable + ", " + uniqued + ", " + savedatalog + ", \"" + column_default + "\", " + sequence + "));\n", new Object[0]);
                    break;
                }
                case "text": {
                    builder.addCode("arrayList.add(new TextCol(\"" + column_name + "\", \"" + column_title + "\", \"" + column_comment + "\", " + is_nullable + ", " + savedatalog + ", \"" + column_default + "\", " + sequence + "));\n", new Object[0]);
                    break;
                }
                case "longtext": {
                    builder.addCode("arrayList.add(new LongTextCol(\"" + column_name + "\", \"" + column_title + "\", \"" + column_comment + "\", " + is_nullable + ", " + savedatalog + ", \"" + column_default + "\", " + sequence + "));\n", new Object[0]);
                    break;
                }
                case "json": {
                    builder.addCode("arrayList.add(new LongTextCol(\"" + column_name + "\", \"" + column_title + "\", \"" + column_comment + "\", " + is_nullable + ", " + savedatalog + ", " + sequence + "));\n", new Object[0]);
                    break;
                }
                case "date": {
                    builder.addCode("arrayList.add(new DateCol(\"" + column_name + "\", \"" + column_title + "\", \"" + column_comment + "\", " + is_nullable + ", " + savedatalog + ", \"" + column_default + "\", " + sequence + "));\n", new Object[0]);
                    break;
                }
                case "datetime": {
                    builder.addCode("arrayList.add(new DateTimeCol(\"" + column_name + "\", \"" + column_title + "\", \"" + column_comment + "\", " + is_nullable + ", " + savedatalog + ", \"" + column_default + "\", " + sequence + "));\n", new Object[0]);
                    break;
                }
                case "int": {
                    if (column_default.equals("")) {
                        builder.addCode("arrayList.add(new IntCol(\"" + column_name + "\", \"" + column_title + "\", \"" + column_comment + "\", " + is_nullable + ", " + uniqued + ", " + savedatalog + ", " + sequence + "));\n", new Object[0]);
                        break;
                    }
                    builder.addCode("arrayList.add(new IntCol(\"" + column_name + "\", \"" + column_title + "\", \"" + column_comment + "\", " + is_nullable + ", " + uniqued + ", " + savedatalog + ", " + column_default + ", " + sequence + "));\n", new Object[0]);
                    break;
                }
                case "bigint": {
                    if (column_default.equals("")) {
                        builder.addCode("arrayList.add(new BigIntCol(\"" + column_name + "\", \"" + column_title + "\", \"" + column_comment + "\", " + is_nullable + ", " + uniqued + ", " + savedatalog + ", " + sequence + "));\n", new Object[0]);
                        break;
                    }
                    builder.addCode("arrayList.add(new BigIntCol(\"" + column_name + "\", \"" + column_title + "\", \"" + column_comment + "\", " + is_nullable + ", " + uniqued + ", " + savedatalog + ", " + column_default + ", " + sequence + "));\n", new Object[0]);
                    break;
                }
                case "smallint": {
                    if (column_default.equals("")) {
                        builder.addCode("arrayList.add(new SmallIntCol(\"" + column_name + "\", \"" + column_title + "\", \"" + column_comment + "\", " + is_nullable + ", " + uniqued + ", " + savedatalog + ", " + sequence + "));\n", new Object[0]);
                        break;
                    }
                    builder.addCode("arrayList.add(new SmallIntCol(\"" + column_name + "\", \"" + column_title + "\", \"" + column_comment + "\", " + is_nullable + ", " + uniqued + ", " + savedatalog + ", " + column_default + ", " + sequence + "));\n", new Object[0]);
                    break;
                }
                case "decimal": {
                    if (column_default.equals("")) {
                        builder.addCode("arrayList.add(new DecimalCol(\"" + column_name + "\", \"" + column_title + "\", \"" + column_comment + "\", " + numeric_precision + ", " + numeric_scale + ", , " + is_nullable + ", " + savedatalog + ", " + sequence + "));\n", new Object[0]);
                        break;
                    }
                    builder.addCode("arrayList.add(new DecimalCol(\"" + column_name + "\", \"" + column_title + "\", \"" + column_comment + "\", " + numeric_precision + ", " + numeric_scale + ", , " + is_nullable + ", " + savedatalog + ", " + column_default + ", " + sequence + "));\n", new Object[0]);
                }
            }
        }
        builder.addCode("return arrayList;", new Object[0]);
        return builder.build();
    }
}

