package restcontroller.system.message;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.annotation.API;
import common.annotation.CACHEING;
import common.annotation.CACHEING_CLEAN;
import common.annotation.cm;
import common.data.InsertSQL;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.YosException;
import common.parameter.parameter;
import common.websocket.WebSocket;
import restcontroller.R;

import java.util.ArrayList;

@API(title = "系统消息")
public class Message extends Controller {

    public Message(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "系统消息查询", apiversion = R.ID10021701.v1.class)
    @CACHEING
    public String queryMessage() throws YosException {
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("t1.message like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t1.title like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
        }
        if (content.containsKey("isread") && !"".equals(content.getString("isread"))) {
            where.append("and t1.isread ='").append(content.getBoolean("isread") ? "1" : "0").append("' ");
        }

        SQLFactory factory = null;
        if (content.containsKey("type") && !"".equals(content.getString("type"))) {
            factory = new SQLFactory(this, "消息查询分类", pageSize, pageNumber, pageSorting);
            factory.addParameter("type", content.getString("type"));
        } else {
            factory = new SQLFactory(this, "消息查询全部", pageSize, pageNumber, pageSorting);
        }
        factory.addParameter("siteid", siteid);
        factory.addParameter("userid", userid);
        factory.addParameter_SQL("where", where);
        Rows rows = dbConnect.runSqlQuery(factory.getSQL());

        for (Row row : rows) {
            try {
                JSONArray array = row.getJSONArray("systemappids");
                for (Object o : array) {
                    JSONObject object = (JSONObject) o;
                    if (object.getStringValue("systemclient").equalsIgnoreCase(systemclient)) {
                        row.put("systemappid", object.getLongValue("systemappid"));
                        break;
                    }
                }
            } catch (Exception e) {
                row.put("systemappid", 0);
            }
        }

        rows.removeColumn(new String[]{"systemappids"});
        return getSucReturnObject().setData(rows).toString();
    }

    @API(title = "系统消息阅读", apiversion = R.ID10021801.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = Message.class, method = {"queryMessage", "unReadMessageCount"})})
    public String readMessage() throws YosException {
        SQLFactory read = new SQLFactory(this, "消息阅读");
        read.addParameter("siteid", siteid);
        read.addParameter("userid", userid);
        read.addParameter("messageid", content.getLong("messageid"));

        SQLFactory factory = new SQLFactory(this, "消息详情");
        factory.addParameter("siteid", siteid);
        factory.addParameter("userid", userid);
        factory.addParameter("messageid", content.getLong("messageid"));
        Rows rows = dbConnect.runSqlQuery(factory.getSQL());
        for (Row row : rows) {
            try {
                JSONArray array = row.getJSONArray("systemappids");
                for (Object o : array) {
                    JSONObject object = (JSONObject) o;
                    if (object.getStringValue("systemclient").equalsIgnoreCase(systemclient)) {
                        row.put("systemappid", object.getLongValue("systemappid"));
                        break;
                    }
                }
            } catch (Exception e) {
                row.put("systemappid", 0);
            }
        }
        dbConnect.runSqlUpdate(read.getSQL());
        return getSucReturnObject().setData(rows.get(0)).toString();
    }


    @API(title = "系统消息全部阅读", apiversion = R.ID10021901.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = Message.class, method = {"queryMessage", "unReadMessageCount"})})
    public String readAllMessage() throws YosException {
        if (content.containsKey("type")) {
            dbConnect.runSqlUpdate("update sys_Message set isread=1 ,readdate=now() where siteid='" + siteid + "' and type='" + content.getString("type") + "' and userid=" + userid + " and isread=0");
        } else {
            dbConnect.runSqlUpdate("update sys_Message set isread=1 ,readdate=now() where siteid='" + siteid + "' and userid=" + userid + " and isread=0");
        }
        return getSucReturnObject().toString();
    }

    @API(title = "未读系统消息数量查询", apiversion = R.ID10022001.v1.class)
    @CACHEING
    public String unReadMessageCount() throws YosException {
        if (content.containsKey("type")) {
            SQLFactory unread = new SQLFactory(this, "未阅读消息数量查询_类型");
            unread.addParameter("siteid", siteid);
            unread.addParameter("userid", userid);
            unread.addParameter("type", content.getString("type"));
            Rows rows = dbConnect.runSqlQuery(unread.getSQL());
            return getSucReturnObject().setData(rows.get(0)).toString();
        } else {
            SQLFactory unread = new SQLFactory(this, "未阅读消息数量查询");
            unread.addParameter("siteid", siteid);
            unread.addParameter("userid", userid);
            Rows rows = dbConnect.runSqlQuery(unread.getSQL());
            return getSucReturnObject().setData(rows.get(0)).toString();
        }
    }

    @API(title = "站点系统消息发送", apiversion = R.ID10022101.v1.class)
    public String sendSiteMessage() throws YosException {
        JSONArray siteidArray = content.getJSONArray("siteids");
        String title = content.getString("title");
        String message = content.getString("message");
        boolean issave = content.getBooleanValue("issave");//是否保存消息
        ArrayList<String> SQlist = new ArrayList<>();
        for (Object siteidObject : siteidArray) {
            Rows sys_usersiteRows = dbConnect.runSqlQuery("select usersiteid,userid from sys_usersite where siteid='" + siteidObject + "'");

            JSONObject methodobject = new JSONObject();
            methodobject.put("class", "remind");//提醒
            methodobject.put("type", "系统");//消息类型
            methodobject.put("title", title);
            methodobject.put("text", message);

            for (Row sys_usersiteRow : sys_usersiteRows) {
                long usersiteid = sys_usersiteRow.getLong("usersiteid");
                boolean isread = false;
                if (parameter.websocketClients.containsKey(usersiteid)) {
                    for (WebSocket webClientSocket : parameter.websocketClients.get(usersiteid).values()) {
                        webClientSocket.sendSystemMessage(methodobject);
                        isread = true;
                    }
                }
                if (issave) {
                    long userid = sys_usersiteRow.getLong("userid");
                    InsertSQL insertSQL = SQLFactory.createInsertSQL(this, "sys_message");
                    insertSQL.setValue("messageid", createTableID("sys_message"));
                    insertSQL.setValue("siteid", siteidObject.toString());
                    insertSQL.setValue("userid", userid);
                    insertSQL.setValue("type", "系统");
                    insertSQL.setValue("title", title);
                    insertSQL.setValue("message", message);
                    insertSQL.setDateValue("createdate");
                    if (isread) {
                        insertSQL.setValue("isread", true);
                        insertSQL.setDateValue("readdate");
                    } else {
                        insertSQL.setValue("isread", false);
                    }
                    SQlist.add(insertSQL.getSQL());
                }
            }
        }
        if (!SQlist.isEmpty()) {
            dbConnect.runSqlUpdate(SQlist);
        }
        return getSucReturnObject().toString();
    }
}
