package objectregister;

import common.BaseClass;
import common.YosException;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.util.ArrayList;

public class sys_users extends BaseClass implements YosObject {
    @Override
    public String table_comment() {
        return "用户表";
    }

    @Override
    public UniqueCol uniquecolumn() {
        return new UniqueCol("userid", "用户ID");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> list = new ArrayList<>();
        list.add(new DateTimeCol("passwordchangedate", "密码修改时间"));
        return list;
    }

    @Override
    public void DataInit() throws YosException {
        boolean isneedtrigger = dbConnect.runSqlQuery("select * from sys_objectcols where table_name='sys_users' and column_name='passwordchangedate'").isNotEmpty();
        boolean isallreadyhavetrigger = dbConnect.runSqlQuery("select * from information_schema.TRIGGERS where TRIGGER_SCHEMA='" + dbConnect.getDBName() + "' and TRIGGER_NAME='update_user_password'").isNotEmpty();

        if (isneedtrigger && !isallreadyhavetrigger) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" create TRIGGER update_user_password before update on sys_users FOR EACH ROW begin ");
            stringBuffer.append(" IF NEW.password != OLD.password ");
            stringBuffer.append(" THEN SET NEW.passwordchangedate=now();");
            stringBuffer.append(" END IF");
            stringBuffer.append("; end; ");
            dbConnect.runSqlUpdate(stringBuffer.toString());
        } else if (!isneedtrigger && isallreadyhavetrigger) {
            dbConnect.runSqlUpdate("DROP TRIGGER update_user_password;");
        }
    }
}
