/*
 * Decompiled with CFR 0.152.
 */
package common.data.db.initialization;

import common.YosException;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.SQLFactory;
import common.data.db.DBConnect;
import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import common.parameter.properties;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import org.reflections.Reflections;

public class DBInitialization {
    private static HashMap<String, String> sys_tableMap = new HashMap();
    private static RowsMap sys_table_colsMap = new RowsMap();

    public static void main(String[] args) throws YosException {
        DBInitialization.SchemaInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SchemaInit() {
        try {
            Properties p = properties.getYosProperties();
            Connection conn = null;
            Statement statement = null;
            try {
                Class.forName(p.getProperty("system.db.driver"));
                String url = p.getProperty("system.db.url");
                String dbname = url.substring(url.lastIndexOf("/") + 1);
                url = url.replace(url.substring(url.lastIndexOf("/")), "/INFORMATION_SCHEMA");
                conn = DriverManager.getConnection(url, p.getProperty("system.db.username"), p.getProperty("system.db.password"));
                conn.setAutoCommit(false);
                conn.setTransactionIsolation(2);
                statement = conn.prepareStatement("select count(0)as count from INFORMATION_SCHEMA.SCHEMATA where SCHEMA_NAME='" + dbname + "'");
                ResultSet resultSet = statement.executeQuery();
                boolean havedb = false;
                if (resultSet.next()) {
                    havedb = resultSet.getLong("count") > 0L;
                }
                resultSet.close();
                if (!havedb) {
                    statement = conn.prepareStatement("CREATE DATABASE IF NOT EXISTS " + dbname + " DEFAULT CHARACTER SET utf8mb4 DEFAULT COLLATE utf8mb4_0900_ai_ci;");
                    statement.executeUpdate();
                    conn.commit();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                        statement = null;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                try {
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            DBInitialization.ObjectInit();
        }
        catch (YosException e) {
            e.printStackTrace();
        }
    }

    private static void ObjectInit() throws YosException {
        DBConnect dbConnect = new DBConnect();
        Rows tablerows = dbConnect.runSqlQuery("select table_name,table_comment from sys_object ");
        for (Row row : tablerows) {
            sys_tableMap.put(row.getString("table_name").toLowerCase(), row.getString("table_comment").toLowerCase());
        }
        sys_table_colsMap = dbConnect.runSqlQuery("select * from sys_objectcols").toRowsMap("table_name");
        Reflections reflections = new Reflections(new Object[0]);
        Set subTypes = reflections.getSubTypesOf(YosObject.class);
        ArrayList<String> sqlist = new ArrayList<String>();
        for (Class yosObject : subTypes) {
            try {
                Constructor cla = yosObject.getDeclaredConstructor(new Class[0]);
                DBInitialization.getObjectChangeSQL((YosObject)cla.newInstance(new Object[0]), sqlist);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (sqlist.size() > 0) {
            dbConnect.runSqlUpdate(sqlist);
        }
    }

    private static void getObjectChangeSQL(YosObject yosObject, ArrayList<String> sqlist) throws YosException {
        YosObject.UniqueCol uniqueCol = null;
        uniqueCol = yosObject.uniquecolumn() == null ? new YosObject.UniqueCol(yosObject.getClass().getSimpleName() + "id", "\u6570\u636eID") : yosObject.uniquecolumn();
        ArrayList<YosObjectCol> table_cols = yosObject.table_cols();
        table_cols.add(uniqueCol);
        String table_name = yosObject.getClass().getSimpleName().toLowerCase();
        String table_comment = yosObject.table_comment();
        if (sys_tableMap.containsKey(table_name)) {
            if (!sys_tableMap.get(table_name).equalsIgnoreCase(table_comment)) {
                SQLFactory modifyTable = new SQLFactory(new DBInitialization(), "\u8868\u4fee\u6539");
                modifyTable.addParameter("table_name", table_name);
                modifyTable.addParameter("table_comment", table_comment);
                sqlist.add(modifyTable.getSQL());
            }
            RowsMap columnRowsMap = sys_table_colsMap.get(table_name).toRowsMap("column_name");
            ArrayList<YosObjectCol> changeColList = new ArrayList<YosObjectCol>();
            for (YosObjectCol yosObjectCol : table_cols) {
                if (columnRowsMap.containsKey(yosObjectCol.getColumn_name())) {
                    Row column = columnRowsMap.get(yosObjectCol.getColumn_name()).get(0);
                    if (yosObjectCol.getColumn_comment().equalsIgnoreCase(column.getString("column_comment")) && yosObjectCol.getIs_nullable() == column.getBoolean("is_nullable") && yosObjectCol.getColumn_default().equals(column.getString("column_default")) && yosObjectCol.getColumn_title().equalsIgnoreCase(column.getString("column_title"))) continue;
                    SQLFactory modifyCol = new SQLFactory(new DBInitialization(), "\u5b57\u6bb5\u4fee\u6539");
                    modifyCol.addParameter("table_name", table_name);
                    modifyCol.addParameter("column_name", yosObjectCol.getColumn_name());
                    modifyCol.addParameter("column_title", yosObjectCol.getColumn_title());
                    modifyCol.addParameter("column_default", yosObjectCol.getColumn_default());
                    modifyCol.addParameter("numeric_precision", yosObjectCol.getNumeric_precision());
                    modifyCol.addParameter("numeric_scale", yosObjectCol.getNumeric_scale());
                    modifyCol.addParameter("column_comment", yosObjectCol.getColumn_comment());
                    modifyCol.addParameter("is_nullable", yosObjectCol.getIs_nullable() != false ? 1 : 0);
                    modifyCol.addParameter("savedatalog", yosObjectCol.getSavedatalog() != false ? 1 : 0);
                    modifyCol.addParameter("uniqued", yosObjectCol.getUniqued() != false ? 1 : 0);
                    sqlist.add(modifyCol.getSQL());
                    yosObjectCol.setColstatus(YosObject.ChangeStatus.C);
                    changeColList.add(yosObjectCol);
                    continue;
                }
                SQLFactory insertCol = new SQLFactory(new DBInitialization(), "\u5b57\u6bb5\u65b0\u589e");
                insertCol.addParameter("table_name", table_name);
                insertCol.addParameter("column_name", yosObjectCol.getColumn_name());
                insertCol.addParameter("column_title", yosObjectCol.getColumn_title());
                insertCol.addParameter("column_default", yosObjectCol.getColumn_default());
                insertCol.addParameter("numeric_precision", yosObjectCol.getNumeric_precision());
                insertCol.addParameter("numeric_scale", yosObjectCol.getNumeric_scale());
                insertCol.addParameter("column_type", (Object)yosObjectCol.getColumn_type());
                insertCol.addParameter("column_comment", yosObjectCol.getColumn_comment());
                insertCol.addParameter("is_nullable", yosObjectCol.getIs_nullable() != false ? 1 : 0);
                insertCol.addParameter("savedatalog", yosObjectCol.getSavedatalog() != false ? 1 : 0);
                insertCol.addParameter("uniqued", yosObjectCol.getUniqued() != false ? 1 : 0);
                insertCol.addParameter("sequence", yosObjectCol.getSequence());
                sqlist.add(insertCol.getSQL());
                yosObjectCol.setColstatus(YosObject.ChangeStatus.A);
                changeColList.add(yosObjectCol);
            }
            if (!sys_tableMap.get(table_name).equals(table_comment) || !changeColList.isEmpty()) {
                DBInitialization.applydbchanges(yosObject, YosObject.ChangeStatus.C, changeColList, sqlist);
            }
        } else if (!sys_tableMap.containsKey(table_name)) {
            SQLFactory insertTable = new SQLFactory(new DBInitialization(), "\u8868\u65b0\u589e");
            insertTable.addParameter("table_name", table_name);
            insertTable.addParameter("table_comment", table_comment);
            insertTable.addParameter("uniquecolumnname", uniqueCol.getColumn_name());
            sqlist.add(insertTable.getSQL());
            for (YosObjectCol yosObjectCol : table_cols) {
                SQLFactory insertCol = new SQLFactory(new DBInitialization(), "\u5b57\u6bb5\u65b0\u589e");
                insertCol.addParameter("table_name", table_name);
                insertCol.addParameter("column_name", yosObjectCol.getColumn_name());
                insertCol.addParameter("column_title", yosObjectCol.getColumn_title());
                insertCol.addParameter("column_default", yosObjectCol.getColumn_default());
                insertCol.addParameter("numeric_precision", yosObjectCol.getNumeric_precision());
                insertCol.addParameter("numeric_scale", yosObjectCol.getNumeric_scale());
                insertCol.addParameter("column_type", (Object)yosObjectCol.getColumn_type());
                insertCol.addParameter("column_comment", yosObjectCol.getColumn_comment());
                insertCol.addParameter("is_nullable", yosObjectCol.getIs_nullable() != false ? 1 : 0);
                insertCol.addParameter("savedatalog", yosObjectCol.getSavedatalog() != false ? 1 : 0);
                insertCol.addParameter("uniqued", yosObjectCol.getUniqued() != false ? 1 : 0);
                insertCol.addParameter("sequence", yosObjectCol.getSequence());
                sqlist.add(insertCol.getSQL());
            }
            DBInitialization.applydbchanges(yosObject, YosObject.ChangeStatus.A, table_cols, sqlist);
        }
    }

    private static void applydbchanges(YosObject yosObject, YosObject.ChangeStatus tablestatus, ArrayList<YosObjectCol> yosObjectCollist, ArrayList<String> sqllist) throws YosException {
        DBConnect dbConnect = new DBConnect();
        String table_name = yosObject.getClass().getSimpleName();
        String table_comment = yosObject.table_comment();
        switch (tablestatus) {
            case C: {
                sqllist.add("alter table " + yosObject.getClass().getSimpleName() + " comment '" + table_comment + "';");
                for (YosObjectCol yosObjectCol : yosObjectCollist) {
                    YosObject.ChangeStatus colstatus = yosObjectCol.getColstatus();
                    String column_name = yosObjectCol.getColumn_name();
                    String column_type = yosObjectCol.getColumn_type().toString();
                    int numeric_precision = yosObjectCol.getNumeric_precision();
                    int numeric_scale = yosObjectCol.getNumeric_scale();
                    String column_default = yosObjectCol.getColumn_default();
                    boolean is_nullable = yosObjectCol.getIs_nullable();
                    String column_comment = yosObjectCol.getColumn_comment();
                    boolean uniqued = yosObjectCol.getUniqued();
                    String oldindexname = table_name + "_" + column_name + "_uindex";
                    String indexname = column_name + "_uindex";
                    boolean isallreadyhaveoldindex = dbConnect.runSqlQuery("select t1.name from INFORMATION_SCHEMA.INNODB_INDEXES t1 inner join INFORMATION_SCHEMA.INNODB_TABLES t2 on t1.TABLE_ID=t2.TABLE_ID where t2.NAME='" + dbConnect.getDBName() + "/" + table_name + "' and t1.NAME='" + oldindexname + "'").isNotEmpty();
                    boolean isallreadyhaveindex = dbConnect.runSqlQuery("select t1.name from INFORMATION_SCHEMA.INNODB_INDEXES t1 inner join INFORMATION_SCHEMA.INNODB_TABLES t2 on t1.TABLE_ID=t2.TABLE_ID where t2.NAME='" + dbConnect.getDBName() + "/" + table_name + "' and t1.NAME='" + indexname + "'").isNotEmpty();
                    String type = DBInitialization.getColumn_type(column_type, numeric_precision, numeric_scale);
                    boolean isallreadycolhave = !dbConnect.runSqlQuery("SELECT * FROM INFORMATION_SCHEMA.`COLUMNS` WHERE TABLE_SCHEMA = '" + dbConnect.getDBName() + "' and TABLE_NAME='" + table_name + "' and COLUMN_NAME='" + column_name + "'").isEmpty();
                    switch (colstatus) {
                        case C: 
                        case A: {
                            if (isallreadycolhave) {
                                sqllist.add("alter table " + table_name + " modify " + column_name + " " + type + (column_default.equals("") ? " " : " default '" + column_default + "' ") + (is_nullable ? "null" : "not null") + " comment '" + column_comment + "';");
                            } else {
                                sqllist.add("alter table " + table_name + " add " + column_name + " " + type + (column_default.equals("") ? " " : " default '" + column_default + "' ") + (is_nullable ? "null" : "not null") + " comment '" + column_comment + "';");
                            }
                            if (uniqued && !isallreadyhaveindex) {
                                sqllist.add("create unique index " + indexname + " on " + table_name + " (" + column_name + ");");
                                break;
                            }
                            if (!uniqued && isallreadyhaveindex) {
                                sqllist.add("drop index " + indexname + " on " + table_name + ";");
                                break;
                            }
                            if (uniqued || !isallreadyhaveoldindex) break;
                            sqllist.add("drop index " + oldindexname + " on " + table_name + ";");
                            break;
                        }
                    }
                }
                break;
            }
            case A: {
                String column_name;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("create table ").append(table_name);
                stringBuffer.append("(");
                for (YosObjectCol yosObjectCol : yosObjectCollist) {
                    column_name = yosObjectCol.getColumn_name();
                    String column_type = yosObjectCol.getColumn_type().toString();
                    int numeric_precision = yosObjectCol.getNumeric_precision();
                    int numeric_scale = yosObjectCol.getNumeric_scale();
                    String column_default = yosObjectCol.getColumn_default();
                    boolean is_nullable = yosObjectCol.getIs_nullable();
                    String column_comment = yosObjectCol.getColumn_comment();
                    String type = DBInitialization.getColumn_type(column_type, numeric_precision, numeric_scale);
                    stringBuffer.append(column_name + " " + type + (column_default.equals("") ? " " : " default '" + column_default + "' ") + (is_nullable ? "null" : "not null") + " comment '" + column_comment + "',");
                }
                stringBuffer.replace(stringBuffer.length() - 1, stringBuffer.length(), "");
                stringBuffer.append(")");
                stringBuffer.append("comment '" + table_comment + "';");
                sqllist.add(stringBuffer.toString());
                for (YosObjectCol yosObjectCol : yosObjectCollist) {
                    column_name = yosObjectCol.getColumn_name();
                    boolean uniqued = yosObjectCol.getUniqued();
                    String oldindexname = table_name + "_" + column_name + "_uindex";
                    String indexname = column_name + "_uindex";
                    boolean isallreadyhaveoldindex = dbConnect.runSqlQuery("select t1.name from INFORMATION_SCHEMA.INNODB_INDEXES t1 inner join INFORMATION_SCHEMA.INNODB_TABLES t2 on t1.TABLE_ID=t2.TABLE_ID where t2.NAME='" + dbConnect.getDBName() + "/" + table_name + "' and t1.NAME='" + oldindexname + "'").isNotEmpty();
                    boolean isallreadyhaveindex = dbConnect.runSqlQuery("select t1.name from INFORMATION_SCHEMA.INNODB_INDEXES t1 inner join INFORMATION_SCHEMA.INNODB_TABLES t2 on t1.TABLE_ID=t2.TABLE_ID where t2.NAME='" + dbConnect.getDBName() + "/" + table_name + "' and t1.NAME='" + indexname + "'").isNotEmpty();
                    if (uniqued && !isallreadyhaveindex) {
                        sqllist.add("create unique index " + indexname + " on " + table_name + " (" + column_name + ");");
                        continue;
                    }
                    if (!uniqued && isallreadyhaveindex) {
                        sqllist.add("drop index " + indexname + " on " + table_name + ";");
                        continue;
                    }
                    if (uniqued || !isallreadyhaveoldindex) continue;
                    sqllist.add("drop index " + oldindexname + " on " + table_name + ";");
                }
                break;
            }
        }
        sqllist.add("update sys_object set status=null,changedate=now() where table_name='" + table_name + "'");
        sqllist.add("update sys_objectcols set status=null where table_name='" + table_name + "'");
        if (dbConnect.runSqlQuery("select *from INFORMATION_SCHEMA.KEY_COLUMN_USAGE where TABLE_NAME='" + table_name + "' and CONSTRAINT_NAME='PRIMARY'").isEmpty()) {
            String uniquecolumnname;
            String string = uniquecolumnname = yosObject.uniquecolumn() != null ? yosObject.uniquecolumn().getColumn_name() : yosObject.getClass().getSimpleName() + "id";
            if (!uniquecolumnname.equalsIgnoreCase("")) {
                sqllist.add("alter table " + table_name + " add constraint " + table_name + "_pk primary key (" + uniquecolumnname + ");");
            }
        }
    }

    private static String getColumn_type(String column_type, int numeric_precision, int numeric_scale) {
        if (column_type.equals("varchar")) {
            return "varchar(" + numeric_precision + ")";
        }
        if (column_type.equals("decimal")) {
            return "decimal(" + numeric_precision + "," + numeric_scale + ")";
        }
        return column_type;
    }
}

