/*
 * Decompiled with CFR 0.152.
 */
package common.data.db;

import com.alibaba.fastjson.JSON;
import com.mysql.cj.jdbc.result.ResultSetMetaData;
import com.mysql.cj.result.Field;
import common.YosException;
import common.data.FieldMeta;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.db.DBConnectPool;
import common.data.db.SQLLog;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public class DBConnect {
    private boolean createsqllog = false;
    private String databasekey;
    private ArrayList<SQLLog> sqlLogList = new ArrayList();
    public static HashMap<String, String> dbprodnamemap = new HashMap();

    public DBConnect() {
        this.databasekey = "default";
    }

    public DBConnect(String databasekey) {
        this.databasekey = databasekey;
    }

    public String getDBName() throws YosException {
        if (this.databasekey.equals("default")) {
            return this.runSqlQuery(0, "select database() as dbname").getString("dbname");
        }
        return this.runSqlQuery(0, "select dbname from sys_datasource where datakey='" + this.databasekey + "'").getString("dbname");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDBProduct() throws YosException {
        String name = "";
        Connection conn = new DBConnectPool().getConnect(this.databasekey);
        try {
            name = conn.getMetaData().getDatabaseProductName();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                new DBConnectPool().close(this.databasekey, conn);
            }
        }
        return name;
    }

    public void setCreatesqllog(boolean createsqllog) {
        this.createsqllog = createsqllog;
    }

    public ArrayList<SQLLog> getSqlLogList() {
        return this.sqlLogList;
    }

    public Row runSqlQuery(int index, SQLFactory sqlFactory) throws YosException {
        return this.runSqlQuery(sqlFactory).get(index);
    }

    public Row runSqlQuery(int index, String SQL) throws YosException {
        return this.runSqlQuery(SQL).get(index);
    }

    public Rows runSqlQuery(SQLFactory sqlFactory) throws YosException {
        return this.runSqlQuery(sqlFactory.getSQL());
    }

    private String getDBProdName(Connection conn) {
        try {
            if (!dbprodnamemap.containsKey(this.databasekey)) {
                dbprodnamemap.put(this.databasekey, conn.getMetaData().getDatabaseProductName());
            }
            return dbprodnamemap.get(this.databasekey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public Rows runSqlQuery(String SQL) throws YosException {
        long starttimes = Calendar.getInstance().getTimeInMillis();
        Connection conn = new DBConnectPool().getConnect(this.databasekey);
        if (conn == null) {
            if (this.createsqllog) {
                this.sqlLogList.add(new SQLLog(SQL, this.databasekey + "\u8fde\u63a5\u5931\u8d25"));
            }
            throw new YosException(this.databasekey + "\u8fde\u63a5\u5931\u8d25");
        }
        Rows rows = new Rows();
        ResultSet resultSet = null;
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement(SQL);
            resultSet = statement.executeQuery();
            java.sql.ResultSetMetaData rsmd = resultSet.getMetaData();
            int colCount = rsmd.getColumnCount();
            ArrayList<String> colNameList = new ArrayList<String>();
            HashMap<String, FieldMeta> getFieldMetaMap = new HashMap<String, FieldMeta>();
            for (int i = 0; i < colCount; ++i) {
                Field[] fields;
                FieldMeta fieldmeta = new FieldMeta();
                fieldmeta.setTable_name(rsmd.getTableName(i + 1));
                fieldmeta.setColumn_name(rsmd.getColumnName(i + 1));
                fieldmeta.setPrecision(rsmd.getPrecision(i + 1));
                fieldmeta.setScale(rsmd.getScale(i + 1));
                if (this.getDBProdName(conn).equals("MySQL") && (fields = ((ResultSetMetaData)rsmd).getFields()).length > i) {
                    fieldmeta.setTable_alias(fields[i].getTableName());
                }
                String Columnlabel = rsmd.getColumnLabel(i + 1);
                fieldmeta.setColumn_label(Columnlabel);
                colNameList.add(Columnlabel);
                switch (rsmd.getColumnTypeName(i + 1).toLowerCase()) {
                    case "int": 
                    case "smallint": {
                        fieldmeta.setFieldtype(Integer.class);
                        break;
                    }
                    case "bigint": {
                        fieldmeta.setFieldtype(Long.class);
                        break;
                    }
                    case "float": 
                    case "numeric": 
                    case "decimal": {
                        fieldmeta.setFieldtype(BigDecimal.class);
                        break;
                    }
                    case "date": 
                    case "datetime": {
                        fieldmeta.setFieldtype(Date.class);
                        break;
                    }
                    case "boolean": {
                        fieldmeta.setFieldtype(Boolean.class);
                        break;
                    }
                    case "json": {
                        fieldmeta.setFieldtype(JSON.class);
                        break;
                    }
                    default: {
                        fieldmeta.setFieldtype(String.class);
                    }
                }
                getFieldMetaMap.put(Columnlabel, fieldmeta);
            }
            boolean addrowindex = !colNameList.contains("rowindex");
            int rowindex = 1;
            while (resultSet.next()) {
                Row row = new Row();
                for (int i = 0; i < colCount; ++i) {
                    Object value;
                    String key = colNameList.get(i);
                    Class clazz = getFieldMetaMap.get(key).getFieldtype();
                    if (clazz == Integer.class) {
                        value = resultSet.getInt(colNameList.get(i));
                    } else if (clazz == Long.class) {
                        value = resultSet.getLong(colNameList.get(i));
                    } else if (clazz == BigDecimal.class) {
                        value = resultSet.getBigDecimal(colNameList.get(i));
                    } else if (clazz == Boolean.class) {
                        value = resultSet.getBoolean(colNameList.get(i));
                    } else if (clazz == JSON.class) {
                        value = JSON.parse((String)resultSet.getString(colNameList.get(i)));
                    } else if (clazz == Date.class) {
                        value = resultSet.getString(colNameList.get(i));
                        if (value != null) {
                            value = ((String)value).replace(" 00:00:00.0", "");
                        }
                    } else {
                        Object objvalue = resultSet.getObject(colNameList.get(i));
                        Object object = value = objvalue == null ? "" : objvalue;
                    }
                    if ("total".equals(key)) {
                        rows.totalRows = (Long)value;
                        continue;
                    }
                    if ("pageTotal".equals(key)) {
                        if (value instanceof Long) {
                            rows.totalPage = (Long)value;
                            continue;
                        }
                        if (value instanceof BigDecimal) {
                            rows.totalPage = ((BigDecimal)value).longValue();
                            continue;
                        }
                        if (value == null) continue;
                        rows.totalPage = Long.parseLong(value.toString());
                        continue;
                    }
                    row.put(key, value);
                }
                if (addrowindex) {
                    row.put("rowindex", rowindex++);
                }
                rows.add(row);
            }
            rows.setFieldList(colNameList);
            rows.setFieldMetaMap(getFieldMetaMap);
            if (rows.totalRows == 0L) {
                rows.totalRows = rows.size();
                rows.totalPage = 1L;
            }
        }
        catch (Exception e) {
            try {
                conn.close();
                conn = null;
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            if (this.createsqllog) {
                this.sqlLogList.add(new SQLLog(SQL, this.databasekey + "\u67e5\u8be2\u8bed\u53e5\u6267\u884c\u9519\u8bef\uff1a" + e.getMessage()));
            }
            throw new YosException(this.databasekey + "\u67e5\u8be2\u8bed\u53e5\u6267\u884c\u9519\u8bef\uff1a" + SQL + System.lineSeparator() + e.getMessage());
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    throw new YosException(e.getMessage());
                }
            }
            this.close(conn, statement);
        }
        if (this.createsqllog) {
            this.sqlLogList.add(new SQLLog(SQL, Calendar.getInstance().getTimeInMillis() - starttimes, rows.size()));
        }
        return rows;
    }

    public void runSqlUpdate(SQLFactory sqlFactory) throws YosException {
        this.runSqlUpdate(sqlFactory.getSQL());
    }

    public int runSqlUpdate(String SQL) throws YosException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(SQL);
        return this.runSqlUpdate(list);
    }

    public int runSqlUpdate(ArrayList<String> SQLlist) throws YosException {
        int affectedrows = 0;
        long starttimes = Calendar.getInstance().getTimeInMillis();
        Connection conn = new DBConnectPool().getConnect(this.databasekey);
        if (conn == null) {
            if (this.createsqllog) {
                for (String SQL : SQLlist) {
                    this.sqlLogList.add(new SQLLog(SQL, this.databasekey + "\u8fde\u63a5\u5931\u8d25"));
                }
            }
            throw new YosException(this.databasekey + "\u8fde\u63a5\u5931\u8d25");
        }
        PreparedStatement statement = null;
        try {
            for (String sql : SQLlist) {
                statement = conn.prepareStatement(sql);
                affectedrows += statement.executeUpdate();
            }
            conn.commit();
        }
        catch (SQLException e) {
            String[] s;
            String errmsg = e.getMessage();
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                throw new YosException(e1.getMessage());
            }
            try {
                conn.close();
                conn = null;
            }
            catch (SQLException e1) {
                throw new YosException(e1.getMessage());
            }
            if (this.createsqllog) {
                for (String SQL : SQLlist) {
                    this.sqlLogList.add(new SQLLog(SQL, this.databasekey + "\u66f4\u65b0\u8bed\u53e5\u6267\u884c\u9519\u8bef\uff1a" + e.getMessage()));
                }
            }
            if (errmsg.startsWith("Duplicate entry") && errmsg.endsWith(".PRIMARY'")) {
                errmsg = errmsg.replace("Duplicate entry '", "").replace("' for key '", ",").replace(".PRIMARY'", "");
                s = errmsg.split(",");
                throw new YosException("\u8868" + s[1] + "\u4e3b\u952e ID\u3010" + s[0] + "\u3011\u91cd\u590d\uff01");
            }
            if (errmsg.startsWith("Duplicate entry")) {
                errmsg = errmsg.replace("Duplicate entry '", "").replace("' for key '", ",").replace("'", "");
                s = errmsg.split(",");
                throw new YosException("\u6570\u636e\u3010" + s[0] + "\u3011\u89e6\u53d1\u4e86\u552f\u4e00\u7d22\u5f15" + s[1]);
            }
            throw new YosException(this.databasekey + "\u66f4\u65b0\u8bed\u53e5\u6267\u884c\u9519\u8bef\uff1a" + JSON.toJSON(SQLlist) + System.lineSeparator() + errmsg);
        }
        finally {
            this.close(conn, statement);
        }
        if (this.createsqllog) {
            for (String SQL : SQLlist) {
                this.sqlLogList.add(new SQLLog(SQL, Calendar.getInstance().getTimeInMillis() - starttimes, affectedrows));
            }
        }
        return affectedrows;
    }

    private void close(Connection conn, PreparedStatement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (conn != null) {
            new DBConnectPool().close(this.databasekey, conn);
        }
    }

    public String getDateTime_Str() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(calendar.getTime());
    }
}

