package utility.huawei.obs;

import beans.parameter.Parameter;
import com.huaweicloud.sdk.ces.v1.CesClient;
import com.huaweicloud.sdk.ces.v1.model.Datapoint;
import com.huaweicloud.sdk.ces.v1.model.ShowMetricDataRequest;
import com.huaweicloud.sdk.ces.v1.model.ShowMetricDataResponse;
import com.huaweicloud.sdk.ces.v1.region.CesRegion;
import com.huaweicloud.sdk.core.auth.BasicCredentials;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.exception.ConnectionException;
import com.huaweicloud.sdk.core.exception.ServiceResponseException;
import common.BaseClass;
import common.YosException;
import common.data.InsertSQL;
import common.data.Rows;
import common.data.SQLFactory;
import common.data.UpdateSQL;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class BucketCESManage extends BaseClass {
    protected String bucketname;
    protected CesClient cesClient;
    protected ArrayList<String> sqllist1;
    protected ArrayList<String> sqllist2;
    protected long fromtime;
    protected long totime;
    protected String yeaterday;

    protected String siteid;

    public BucketCESManage(String siteid) throws YosException {
        this.siteid = siteid;
        this.bucketname = getBucketname();
        ICredential auth = new BasicCredentials().withAk(Parameter.get("attachment_huawei_obs_ak")).withSk(Parameter.get("attachment_huawei_obs_sk"));
        cesClient = CesClient.newBuilder().withCredential(auth).withRegion(CesRegion.valueOf(Parameter.get("attachment_huawei_obs_location"))).build();
        sqllist1 = new ArrayList<>();
        sqllist2 = new ArrayList<>();
    }

    private String getBucketname() {
        try {
            Rows rows = SQLFactory.createQuerySQL(dbConnect, "sys_site", bucketname).setWhere("siteid", siteid).query();
            if (rows.isNotEmpty()) {
                this.bucketname = rows.get(0).getString("bucketname").toLowerCase();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return this.bucketname;
    }


    public void getData() throws YosException {
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DATE, -1);
        yeaterday = new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime());
        Rows rows = SQLFactory.createQuerySQL(dbConnect, "sys_obsdatalog", "sys_obsdatalogid").setWhere("siteid", siteid).setWhere("createdate", yeaterday).query();
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        fromtime = calendar.getTimeInMillis();
        calendar.add(Calendar.DATE, 1);
        totime = calendar.getTimeInMillis();
        if (rows.size() < 6) {
            getDownload_traffic();
            if (!sqllist1.isEmpty()) {
                dbConnect.runSqlUpdate(sqllist1);
            }
            getUpload_traffic();
            if (!sqllist2.isEmpty()) {
                dbConnect.runSqlUpdate(sqllist2);
            }
        }
    }

    /**
     * 总下载流量
     */
    private void getDownload_traffic() throws YosException {
        ShowMetricDataRequest request = new ShowMetricDataRequest();
        request.withNamespace("SYS.OBS");
        request.withMetricName("download_traffic");
        request.withDim0("bucket_name," + bucketname);
        request.withFilter(ShowMetricDataRequest.FilterEnum.fromValue("sum"));
        request.withPeriod(14400);
        request.withFrom(fromtime);
        request.withTo(totime);
        try {
            ShowMetricDataResponse response = cesClient.showMetricData(request);
            List<Datapoint> list = response.getDatapoints();
            if (!list.isEmpty()) {
                for (Datapoint datapoint : list) {
                    double downloadbytes = datapoint.getSum();
                    long time = datapoint.getTimestamp();

                    Calendar datetime = Calendar.getInstance();
                    datetime.setTimeInMillis(time);
                    String createdate = new SimpleDateFormat("yyyy-MM-dd").format(datetime.getTime());
                    String createtime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(datetime.getTime());

                    InsertSQL insertSQL = SQLFactory.createInsertSQL(dbConnect, "sys_obsdatalog");
                    insertSQL.setSiteid(siteid).setUniqueid(createTableID("sys_obsdatalog"));
                    insertSQL.setValue("bucketname", bucketname);
                    insertSQL.setValue("timestamp", time);
                    insertSQL.setValue("createdate", createdate);
                    insertSQL.setValue("createtime", createtime);
                    insertSQL.setWhere("not exists(select * from sys_obsdatalog where siteid = '" + siteid + "' and timestamp = '" + time + "')");

                    UpdateSQL updateSQL = SQLFactory.createUpdateSQL(dbConnect, "sys_obsdatalog");
                    updateSQL.setValue("downloadbytes", downloadbytes);
                    updateSQL.setWhere("siteid", siteid).setWhere("timestamp", time);

                    sqllist1.add(insertSQL.getSQL());
                    sqllist1.add(updateSQL.getSQL());
                }
            }
        } catch (ConnectionException e) {
            e.printStackTrace();
        } catch (ServiceResponseException e) {
            e.printStackTrace();
            System.out.println(e.getHttpStatusCode());
            System.out.println(e.getErrorCode());
            System.out.println(e.getErrorMsg());
        }
    }

    /**
     * 总上传流量
     */
    private void getUpload_traffic() throws YosException {
        ShowMetricDataRequest request = new ShowMetricDataRequest();
        request.withNamespace("SYS.OBS");
        request.withMetricName("upload_traffic");
        request.withDim0("bucket_name," + bucketname);
        request.withFilter(ShowMetricDataRequest.FilterEnum.fromValue("sum"));
        request.withPeriod(14400);
        request.withFrom(fromtime);
        request.withTo(totime);
        try {
            ShowMetricDataResponse response = cesClient.showMetricData(request);
            List<Datapoint> list = response.getDatapoints();
            if (!list.isEmpty()) {
                for (Datapoint datapoint : list) {
                    double uploadbytes = datapoint.getSum();
                    long time = datapoint.getTimestamp();

                    Calendar datetime = Calendar.getInstance();
                    datetime.setTimeInMillis(time);

                    String createdate = new SimpleDateFormat("yyyy-MM-dd").format(datetime.getTime());
                    String createtime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(datetime.getTime());

                    InsertSQL insertSQL = SQLFactory.createInsertSQL(dbConnect, "sys_obsdatalog");
                    insertSQL.setSiteid(siteid).setUniqueid(createTableID("sys_obsdatalog"));
                    insertSQL.setValue("bucketname", bucketname);
                    insertSQL.setValue("timestamp", time);
                    insertSQL.setValue("createdate", createdate);
                    insertSQL.setValue("createtime", createtime);
                    insertSQL.setWhere("not exists(select * from sys_obsdatalog where siteid = '" + siteid + "' and timestamp = '" + time + "')");

                    UpdateSQL updateSQL = SQLFactory.createUpdateSQL(dbConnect, "sys_obsdatalog");
                    updateSQL.setValue("uploadbytes", uploadbytes);
                    updateSQL.setWhere("siteid", siteid).setWhere("timestamp", time);

                    sqllist2.add(insertSQL.getSQL());
                    sqllist2.add(updateSQL.getSQL());
                }
            }
        } catch (ConnectionException e) {
            e.printStackTrace();
        } catch (ServiceResponseException e) {
            e.printStackTrace();
            System.out.println(e.getHttpStatusCode());
            System.out.println(e.getErrorCode());
            System.out.println(e.getErrorMsg());
        }
    }
}
