package service;

import beans.yl.MessageMonitoringStation;
import common.ServiceController;
import common.YosException;
import common.data.QuerySQL;
import common.data.Row;
import common.data.Rows;
import common.data.SQLFactory;

/**
 * 数据异常监控
 */
public class DataValidate extends ServiceController {
    @Override
    public void serviceRun() throws YosException {
        try {
            QuerySQL querySQL = SQLFactory.createQuerySQL(dbConnect, "sys_datawarn", "title", "sqlstr");
            querySQL.setWhere("isused", 1);
            querySQL.setWhere("type", "error");
            querySQL.setOrderBy("sequence");
            Rows rows = querySQL.query();
            for (Row row : rows) {
                String title = row.getString("title");
                try {
                    Rows errdatas = dbConnect.runSqlQuery(row.getString("sqlstr"));
                    int errcount = errdatas.size();
                    if (errcount > 0) {
                        MessageMonitoringStation.send("[" + title + "],异常数 " + errcount);
                    }
                } catch (Exception e) {
                    MessageMonitoringStation.send("[" + title + "]查询出错，请检查");
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}
