package restcontroller.system;

import beans.parameter.Parameter;
import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.annotation.CACHEING;
import common.data.*;
import restcontroller.R;

import java.util.ArrayList;

@API(title = "行政区域查询")
public class tools extends Controller {
    public tools(JSONObject content) throws YosException {
        super(content);
    }

    @API(title = "省份查询", accesstoken = false, apiversion = R.ID10002801.v1.class)
    @CACHEING(life = 3600)
    public String query_arealist() throws YosException {
        Rows provincerows = dbConnect.runSqlQuery("select provinceid,province from  t_province order by provinceid");
        RowsMap cityrowsMap = dbConnect.runSqlQuery("select cityid,city,provinceid from t_city order by cityid").toRowsMap("provinceid");
        RowsMap countyrowsMap = dbConnect.runSqlQuery("select countyid,county,cityid from t_county order by countyid").toRowsMap("cityid");

        JSONObject provinceObject = new JSONObject(true);
        for (Row provincerow : provincerows) {
            JSONObject cityObject = new JSONObject(true);
            for (Row cityrow : cityrowsMap.get(provincerow.getString("provinceid"))) {
                ArrayList<String> countylist = countyrowsMap.get(cityrow.getString("cityid")).toArrayList("county");
                if (countylist.isEmpty()) {
                    countylist.add("市辖区");
                }
                cityObject.put(cityrow.getString("city"), countylist);
            }
            provinceObject.put(provincerow.getString("province"), cityObject);
        }
        return getSucReturnObject().setData(provinceObject).toString();
    }

    @API(title = "前端日志记录", accesstoken = false, apiversion = R.ID10022501.v1.class)
    public String saveWebClientErrLog() throws YosException {
        if ("true".equals(Parameter.get("system_client_logsave"))) {
            String keyname = content.getString("keyname");
            String log = content.getString("log");
            dbConnect.runSqlUpdate("insert into sys_log(logid,type,keyname,msg,createtime) values(" + createTableID("sys_log") + ",'前端','" + keyname + "','" + log + "',now())");
        }
        return getSucReturnObject().toString();
    }

    @API(title = "根据rowindex查询指定的字段值", apiversion = R.ID10002901.v1.class)
    public String querylistdatabyrowindex() throws YosException {
        int rowindex = content.getIntValue("rowindex");
        String listqueryid = content.getStringValue("listqueryid");
        String fieldname = content.getStringValue("fieldname");
        JSONObject object = new JSONObject();

        if (QuerySQL.QuerySQLMap.containsKey(listqueryid)) {
            QuerySQL querySQL = QuerySQL.QuerySQLMap.get(listqueryid);
            Rows rows = querySQL.query(rowindex);
            if (rows.isNotEmpty()) {
                long totalrows = rows.getTotalRows();
                int pagesize = querySQL.pageSize_s;
                if (fieldname.equals("")) {
                    object.put("data", rows.get(0).getLong(querySQL.uniquecolumnname));
                } else {
                    object.put("data", rows.get(0).get(fieldname));
                }
                object.put("pageNumber", (rowindex + pagesize - 1) / pagesize);
                object.put("pageSize", pagesize);
                object.put("total", totalrows);
                object.put("pageTotal", (totalrows + pagesize - 1) / pagesize);
            }
        }
        return getSucReturnObject().setData(object).toString();
    }
}
