package restcontroller.sysmanage.develop.appregistry;

import com.alibaba.fastjson.JSONObject;
import common.Controller;
import common.YosException;
import common.annotation.API;
import common.annotation.CACHEING;
import common.annotation.CACHEING_CLEAN;
import common.annotation.cm;
import common.data.Row;
import common.data.Rows;
import common.data.RowsMap;
import common.data.SQLFactory;
import restcontroller.R;

import java.util.ArrayList;

@API(title = "管理端-开发-系统应用注册管理")
public class appregistry extends Controller {

    public appregistry(JSONObject content) throws YosException {
        super(content);
    }

    /**
     * 模块列表查询
     *
     * @return
     */
    @API(title = "系统模块列表查询", apiversion = R.ID10004601.v1.class)
    public String query_modulelist() throws YosException {
        /**
         * 过滤条件设置
         */
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("t1.systemmodulename like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t2.systemclientname like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or t3.systemname like'%").append(whereObject.getString("condition")).append("%' ");
                where.append("or exists(select * from sys_systemapp t4 where t4.systemmoduleid=t1.systemmoduleid and t4.systemappname like'%" + whereObject.getString("condition") + "%') ");
                where.append("or exists(select * from sys_systemapp t5 where t5.systemmoduleid=t1.systemmoduleid and exists(select * from sys_apiapps t6 where t6.systemappid=t5.systemappid and t6.apiid='" + whereObject.getString("condition") + "' )) ");
                where.append("or exists(select * from sys_systemapp t7 where t7.systemmoduleid=t1.systemmoduleid and exists(select * from sys_objectapps t8 where t8.systemappid=t7.systemappid and t8.table_name='" + whereObject.getString("condition") + "' )) ");
                where.append(")");
            }
        }
        SQLFactory sqlFactory = new SQLFactory(this, "模块列表查询", pageSize, pageNumber, pageSorting);
        sqlFactory.addParameter_SQL("where", where);
        Rows rows = dbConnect.runSqlQuery(sqlFactory);
        RowsMap map = dbConnect.runSqlQuery("SELECT systemmoduleid,systemappname FROM sys_systemapp order by sequence").toRowsMap("systemmoduleid");

        for (Row row : rows) {
            row.put("apps", map.get(row.getString("systemmoduleid")).toArray("systemappname"));
            row.put("iconurl", getSystemModuleIconUrl(row.getLong("systemmoduleid"), "icon"));
            row.put("iconurl_mainnav", getSystemModuleIconUrl(row.getLong("systemmoduleid"), "mainnavicon"));
        }
        return getSucReturnObject().setData(rows).toString();
    }


    @API(title = "模块信息调整", apiversion = R.ID10004701.v1.class)
    public String update_module() throws YosException {
        long systemmoduleid = content.getLong("systemmoduleid");
        String systemmodulename = content.getStringValue("systemmodulename");
        int sequence = content.getIntValue("sequence");
        dbConnect.runSqlUpdate("update sys_systemmodule set systemmodulename='" + systemmodulename + "',sequence=" + sequence + " where systemmoduleid=" + systemmoduleid);
        return getSucReturnObject().toString();
    }


    /**
     * 应用列表查询
     *
     * @return
     */
    @API(title = "系统应用列表查询", apiversion = R.ID10004801.v1.class)
    @CACHEING
    public String query_applist() throws YosException {
        long systemmoduleid = content.getLong("systemmoduleid");
        /**
         * 过滤条件设置
         */
        StringBuffer where = new StringBuffer(" 1=1 ");
        if (content.containsKey("where")) {
            JSONObject whereObject = content.getJSONObject("where");
            if (whereObject.containsKey("condition") && !"".equals(whereObject.getString("condition"))) {
                where.append(" and(");
                where.append("t1.systemappname like'%").append(whereObject.getString("condition")).append("%' ");
                where.append(")");
            }
            if (whereObject.containsKey("systemappname") && !"".equals(whereObject.getString("systemappname"))) {
                where.append(" and t1.systemappname like'%").append(whereObject.getString("systemappname")).append("%' ");
            }
        }
        SQLFactory sqlFactory = new SQLFactory(this, "应用列表查询", pageSize, pageNumber, pageSorting);
        sqlFactory.addParameter("systemmoduleid", systemmoduleid);
        sqlFactory.addParameter_SQL("where", where);
        Rows rows = dbConnect.runSqlQuery(sqlFactory);
        return getSucReturnObject().setData(rows).toString();
    }

    /**
     * 应用新增或修改
     *
     * @return
     */
    @API(title = "应用新增或修改", apiversion = R.ID10004901.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = appregistry.class, method = {"query_applist"})})
    public String insertormodify_app() throws YosException {
        long systemmoduleid = content.getLong("systemmoduleid");
        if (dbConnect.runSqlQuery("select*from sys_systemmodule where systemmoduleid=" + systemmoduleid).isEmpty()) {
            return getErrReturnObject().setErrMsg("系统模块不存在").toString();
        }
        String systemapp = content.getString("systemapp");
        if (systemapp.equals("") || !String.valueOf(systemapp.charAt(0)).matches("^[a-zA-Z]*")) {
            return getErrReturnObject().setErrMsg("应用名称必须以英文字母开头").toString();
        }
        if (!systemapp.replace("_", "").matches("^[a-zA-Z0-9]*")) {
            return getErrReturnObject().setErrMsg("应用名称必须为英文字母或英文数字组合").toString();
        }
        String systemappname = content.getString("systemappname");
        String apppath = content.getString("apppath");
        String apppath_index = content.getString("apppath_index");

        boolean isused = content.getBooleanValue("isused");

        String showplace = content.getString("showplace");
        boolean isneedauth = content.getBooleanValue("isneedauth");
        boolean isdatatag = content.getBooleanValue("isdatatag");
        boolean isdatateam = content.getBooleanValue("isdatateam");
        boolean isdatafollowup = content.getBooleanValue("isdatafollowup");
        boolean selectfileinattachment = content.getBooleanValue("selectfileinattachment");

        if (content.getBooleanValue("isasync")) {
            long systemappid = 0;
            Rows sys_systemapprows = dbConnect.runSqlQuery("select *from sys_systemapp where systemmoduleid=" + systemmoduleid + " and systemapp='" + systemapp + "'");

            ArrayList<String> SQLlist = new ArrayList<>();
            if (sys_systemapprows.isEmpty()) {
                SQLFactory appcheckSQl = new SQLFactory(this, "应用名称重复检查");
                appcheckSQl.addParameter("systemapp", systemapp);
                Rows rows = dbConnect.runSqlQuery(appcheckSQl.getSQL());
                if (!rows.isEmpty()) {
                    String str = rows.get(0).getString("systemname") + "-->" + rows.get(0).getString("systemclientname") + "-->" + rows.get(0).getString("systemmodulename") + "-->" + rows.get(0).getString("systemappname");
                    return getErrReturnObject().setErrMsg("应用名称" + systemapp + "已存在:" + str).toString();
                }

                systemappid = createTableID("sys_systemapp");
                SQLFactory appinsertsql = new SQLFactory(this, "应用新增");
                appinsertsql.addParameter("systemmoduleid", systemmoduleid);
                appinsertsql.addParameter("systemappid", systemappid);
                appinsertsql.addParameter("systemapp", systemapp);
                appinsertsql.addParameter("systemappname", systemappname);
                appinsertsql.addParameter("apppath", apppath);
                appinsertsql.addParameter("apppath_index", apppath_index);
                appinsertsql.addParameter("siteids", "");
                appinsertsql.addParameter("remarks", "");
                appinsertsql.addParameter("showplace", showplace);
                appinsertsql.addParameter("isneedauth", isneedauth);
                appinsertsql.addParameter("isdatafollowup", isdatafollowup);
                appinsertsql.addParameter("isdatateam", isdatateam);
                appinsertsql.addParameter("isdatatag", isdatatag);
                appinsertsql.addParameter("selectfileinattachment", selectfileinattachment);
                SQLlist.add(appinsertsql.getSQL());
            } else {
                systemappid = sys_systemapprows.get(0).getLong("systemappid");
                String siteids = sys_systemapprows.get(0).getString("siteids");
                String remarks = sys_systemapprows.get(0).getString("remarks");

                SQLFactory appupdatesql = new SQLFactory(this, "应用修改");
                appupdatesql.addParameter("systemappid", systemappid);
                appupdatesql.addParameter("systemappname", systemappname);
                appupdatesql.addParameter("apppath", apppath);
                appupdatesql.addParameter("apppath_index", apppath_index);
                appupdatesql.addParameter("siteids", siteids);
                appupdatesql.addParameter("isused", isused);
                appupdatesql.addParameter("remarks", remarks);
                appupdatesql.addParameter("showplace", showplace);
                appupdatesql.addParameter("isneedauth", isneedauth);
                appupdatesql.addParameter("isdatafollowup", isdatafollowup);
                appupdatesql.addParameter("isdatateam", isdatateam);
                appupdatesql.addParameter("isdatatag", isdatatag);
                appupdatesql.addParameter("selectfileinattachment", selectfileinattachment);
                SQLlist.add(appupdatesql.getSQL());
            }
            dbConnect.runSqlUpdate(SQLlist);
            return getSucReturnObject().toString();
        } else {
            long systemappid = content.getLongValue("systemappid");
            String siteids = content.getString("siteids");
            String remarks = content.getStringValue("remarks");
            ArrayList<String> SQLlist = new ArrayList<>();

            if (systemappid <= 0 || dbConnect.runSqlQuery("select systemappid from sys_systemapp where systemmoduleid=" + systemmoduleid + " and systemappid=" + systemappid).isEmpty()) {

                SQLFactory appcheckSQl = new SQLFactory(this, "应用名称重复检查");
                appcheckSQl.addParameter("systemapp", systemapp);
                Rows rows = appcheckSQl.runSqlQuery(dbConnect);
                if (!rows.isEmpty()) {
                    String str = rows.get(0).getString("systemname") + "-->" + rows.get(0).getString("systemclientname") + "-->" + rows.get(0).getString("systemmodulename") + "-->" + rows.get(0).getString("systemappname");
                    return getErrReturnObject().setErrMsg("应用名称" + systemapp + "已存在:" + str).toString();
                }

                systemappid = createTableID("sys_systemapp");
                SQLFactory appinsertsql = new SQLFactory(this, "应用新增");
                appinsertsql.addParameter("systemmoduleid", systemmoduleid);
                appinsertsql.addParameter("systemappid", systemappid);
                appinsertsql.addParameter("systemapp", systemapp);
                appinsertsql.addParameter("systemappname", systemappname);
                appinsertsql.addParameter("apppath", apppath);
                appinsertsql.addParameter("apppath_index", apppath_index);
                appinsertsql.addParameter("siteids", siteids);
                appinsertsql.addParameter("remarks", remarks);
                appinsertsql.addParameter("showplace", showplace);
                appinsertsql.addParameter("isneedauth", isneedauth);
                appinsertsql.addParameter("isdatafollowup", isdatafollowup);
                appinsertsql.addParameter("isdatateam", isdatateam);
                appinsertsql.addParameter("isdatatag", isdatatag);
                appinsertsql.addParameter("selectfileinattachment", selectfileinattachment);
                SQLlist.add(appinsertsql.getSQL());
                //新增应用时，默认增加增删改查功能
                String[] options = new String[]{"read", "insert", "update", "delete"};
                String[] optionnames = new String[]{"查询", "新增", "修改", "删除"};
                for (int i = 0; i < options.length; i++) {
                    if (!content.getBooleanValue("readonly") || i == 0) {
                        long optionid = createTableID("sys_systemapp_options");
                        SQLFactory optioninsertsql = new SQLFactory(this, "功能新增");
                        optioninsertsql.addParameter("systemappid", systemappid);
                        optioninsertsql.addParameter("optionid", optionid);
                        optioninsertsql.addParameter("option", options[i]);
                        optioninsertsql.addParameter("optionname", optionnames[i]);
                        optioninsertsql.addParameter("siteids", siteids);
                        SQLlist.add(optioninsertsql.getSQL());
                    } else {
                        break;
                    }
                }
            } else {
                SQLFactory appupdatesql = new SQLFactory(this, "应用修改");
                appupdatesql.addParameter("systemappid", systemappid);
                appupdatesql.addParameter("systemappname", systemappname);
                appupdatesql.addParameter("apppath", apppath);
                appupdatesql.addParameter("apppath_index", apppath_index);
                appupdatesql.addParameter("siteids", siteids);
                appupdatesql.addParameter("isused", isused);
                appupdatesql.addParameter("remarks", remarks);
                appupdatesql.addParameter("showplace", showplace);
                appupdatesql.addParameter("isneedauth", isneedauth);
                appupdatesql.addParameter("isdatafollowup", isdatafollowup);
                appupdatesql.addParameter("isdatateam", isdatateam);
                appupdatesql.addParameter("isdatatag", isdatatag);
                appupdatesql.addParameter("selectfileinattachment", selectfileinattachment);
                SQLlist.add(appupdatesql.getSQL());
            }
            dbConnect.runSqlUpdate(SQLlist);
            return query_applist();
        }
    }

    /**
     * 应用删除
     *
     * @return
     */
    @API(title = "应用删除", apiversion = R.ID10005001.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = appregistry.class, method = {"query_applist", "query_optionlist", "query_hiddenfieldlist"})})
    public String delete_app() throws YosException {
        long systemmoduleid = content.getLong("systemmoduleid");
        long systemappid = content.getLong("systemappid");

        ArrayList<String> list = new ArrayList<>();
        list.add("delete from sys_roleappoptionauth where optionid in(select optionid from sys_systemapp_options where systemappid=" + systemappid + ")");
        list.add("delete from sys_systemapp_options where systemappid=" + systemappid);
        list.add("delete from sys_systemapp_wedgits where systemappid=" + systemappid);
        list.add("delete from sys_systemapp_grids where systemappid=" + systemappid);
        list.add("delete from sys_systemapp_tablecols where tableid in(select tableid from sys_systemapp_tables where systemappid=" + systemappid + ")");
        list.add("delete from sys_systemapp_tables where systemappid=" + systemappid);
        list.add("delete from sys_roleapphiddenfieldlimit where hiddenfieldid in(select hiddenfieldid from sys_systemapp_hiddenfield where systemappid=" + systemappid + ")");
        list.add("delete from sys_systemapp_hiddenfield where systemappid=" + systemappid);
        list.add("delete from sys_systemapp where systemappid=" + systemappid);
        dbConnect.runSqlUpdate(list);
        return query_applist();
    }

    /**
     * 应用功能列表查询
     *
     * @return
     */
    @API(title = "应用功能列表查询", apiversion = R.ID10005101.v1.class)
    @CACHEING
    public String query_optionlist() throws YosException {
        long systemappid = content.getLong("systemappid");
        boolean querycurrencyoption = content.getBooleanValue("querycurrencyoption");//是否查询通用功能
        if (querycurrencyoption) {
            Rows rows = dbConnect.runSqlQuery("select `option`, optionname from sys_systemapp_options t1 where t1.systemappid =0 and not exists(select *from sys_systemapp_options t2 where t2.`option`=t1.`option` and t2.systemappid=" + systemappid + ")");
            return getSucReturnObject().setData(rows).toString();
        } else {
            SQLFactory sqlFactory = new SQLFactory(this, "功能查询");
            sqlFactory.addParameter("systemappid", systemappid);
            Rows rows = dbConnect.runSqlQuery(sqlFactory);
            return getSucReturnObject().setData(rows).toString();
        }
    }

    /**
     * 应用功能新增或修改
     *
     * @return
     */
    @API(title = "应用功能新增或修改", apiversion = R.ID10005201.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = appregistry.class, method = {"query_optionlist"})})
    public String insertormodify_option() throws YosException {
        String option = content.getString("option");
        String optionname = content.getString("optionname");

        boolean isused = content.getBooleanValue("isused");
        if (option.equals("") || !String.valueOf(option.charAt(0)).matches("^[a-zA-Z]*")) {
            return getErrReturnObject().setErrMsg("功能名称必须以英文字母开头").toString();
        }
        if (!option.replace("_", "").matches("^[a-zA-Z0-9]*")) {
            return getErrReturnObject().setErrMsg("功能名称必须为英文字母或英文数字组合").toString();
        }
        if (content.getBooleanValue("isasync")) {
            String systemapp = content.getString("systemapp");
            long systemappid = 0L;
            Rows sys_systemappRows = dbConnect.runSqlQuery("select *from sys_systemapp where systemapp='" + systemapp + "'");
            if (sys_systemappRows.isEmpty()) {
                return getErrReturnObject().setErrMsg("应用" + systemapp + "不存在").toString();
            }
            systemappid = sys_systemappRows.get(0).getLong("systemappid");

            long optionid = 0L;
            Rows sys_systemapp_optionsRows = dbConnect.runSqlQuery("select*from sys_systemapp_options where systemappid=" + systemappid + " and `option`='" + option + "'");

            SQLFactory sqlFactory;
            if (sys_systemapp_optionsRows.isEmpty()) {
                optionid = createTableID("sys_systemapp_options");
                sqlFactory = new SQLFactory(this, "功能新增");
                sqlFactory.addParameter("systemappid", systemappid);
                sqlFactory.addParameter("optionid", optionid);
                sqlFactory.addParameter("option", option);
                sqlFactory.addParameter("optionname", optionname);
                sqlFactory.addParameter("siteids", "");
            } else {
                optionid = sys_systemapp_optionsRows.get(0).getLong("optionid");
                String siteids = sys_systemapp_optionsRows.get(0).getString("siteids");
                sqlFactory = new SQLFactory(this, "功能修改");
                sqlFactory.addParameter("optionid", optionid);
                sqlFactory.addParameter("option", option);
                sqlFactory.addParameter("optionname", optionname);
                sqlFactory.addParameter("siteids", siteids);
                sqlFactory.addParameter("isused", isused);
            }
            dbConnect.runSqlUpdate(sqlFactory);
        } else {
            long systemappid = content.getLong("systemappid");
            long optionid = content.getLongValue("optionid");//新增时传0
            String siteids = content.getString("siteids");

            SQLFactory sqlFactory;
            if (optionid <= 0 || dbConnect.runSqlQuery("select optionid from sys_systemapp_options where optionid=" + optionid).isEmpty()) {
                optionid = createTableID("sys_systemapp_options");
                sqlFactory = new SQLFactory(this, "功能新增");
                sqlFactory.addParameter("systemappid", systemappid);
                sqlFactory.addParameter("optionid", optionid);
                sqlFactory.addParameter("option", option);
                sqlFactory.addParameter("optionname", optionname);
                sqlFactory.addParameter("siteids", siteids);
            } else {
                sqlFactory = new SQLFactory(this, "功能修改");
                sqlFactory.addParameter("optionid", optionid);
                sqlFactory.addParameter("option", option);
                sqlFactory.addParameter("optionname", optionname);
                sqlFactory.addParameter("siteids", siteids);
                sqlFactory.addParameter("isused", isused);
            }
            dbConnect.runSqlUpdate(sqlFactory);
        }
        return getSucReturnObject().toString();
    }

    /**
     * 应用功能删除
     *
     * @return
     */
    @API(title = "应用功能删除", apiversion = R.ID10005301.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = appregistry.class, method = {"query_optionlist"})})
    public String delete_option() throws YosException {
        long systemappid = content.getLong("systemappid");
        long optionid = content.getLong("optionid");
        ArrayList<String> list = new ArrayList<>();
        list.add("delete from sys_systemapp_options where optionid=" + optionid);
        list.add("delete from sys_roleappoptionauth where optionid=" + optionid);
        dbConnect.runSqlUpdate(list);
        return getSucReturnObject().toString();
    }


    /**
     * 应用隐藏栏查询
     *
     * @return
     */
    @API(title = "应用隐藏栏查询", apiversion = R.ID10005401.v1.class)
    @CACHEING
    public String query_hiddenfieldlist() throws YosException {
        long systemappid = content.getLong("systemappid");
        SQLFactory sqlFactory = new SQLFactory(this, "隐藏栏查询");
        sqlFactory.addParameter("systemappid", systemappid);
        Rows rows = dbConnect.runSqlQuery(sqlFactory);
        return getSucReturnObject().setData(rows).toString();
    }

    /**
     * 应用隐藏栏新增修改
     *
     * @return
     */
    @API(title = "应用隐藏栏新增修改", apiversion = R.ID10005501.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = appregistry.class, method = {"query_hiddenfieldlist"})})
    public String insertormodify_hiddenfield() throws YosException {
        long systemappid = content.getLong("systemappid");
        long hiddenfieldid = content.getLongValue("hiddenfieldid");//新增时传0
        String field = content.getString("field");
        if (field.equals("") || !String.valueOf(field.charAt(0)).matches("^[a-zA-Z]*")) {
            return getErrReturnObject().setErrMsg("字段名称必须以英文字母开头").toString();
        }
        if (!field.replace("_", "").matches("^[a-zA-Z0-9]*")) {
            return getErrReturnObject().setErrMsg("字段名称必须为英文字母或英文数字组合").toString();
        }
        String fieldname = content.getString("fieldname");
        SQLFactory sqlFactory;
        if (hiddenfieldid <= 0 || dbConnect.runSqlQuery("select hiddenfieldid from sys_systemapp_hiddenfield where hiddenfieldid=" + hiddenfieldid).isEmpty()) {
            hiddenfieldid = createTableID("sys_systemapp_hiddenfield");
            sqlFactory = new SQLFactory(this, "隐藏栏新增");
            sqlFactory.addParameter("systemappid", systemappid);
            sqlFactory.addParameter("hiddenfieldid", hiddenfieldid);
            sqlFactory.addParameter("field", field);
            sqlFactory.addParameter("fieldname", fieldname);
        } else {
            sqlFactory = new SQLFactory(this, "隐藏栏修改");
            sqlFactory.addParameter("hiddenfieldid", hiddenfieldid);
            sqlFactory.addParameter("field", field);
            sqlFactory.addParameter("fieldname", fieldname);
        }
        dbConnect.runSqlUpdate(sqlFactory);
        return query_hiddenfieldlist();
    }

    /**
     * 应用隐藏栏位删除
     *
     * @return
     */
    @API(title = "应用隐藏栏位删除", apiversion = R.ID10005601.v1.class)
    @CACHEING_CLEAN(cms = {@cm(clazz = appregistry.class, method = {"query_hiddenfieldlist"})})
    public String delete_hiddenfield() throws YosException {
        long hiddenfieldid = content.getLong("hiddenfieldid");
        ArrayList<String> list = new ArrayList<>();
        list.add("delete from sys_roleapphiddenfieldlimit where hiddenfieldid='" + hiddenfieldid + "'");
        list.add("delete from sys_systemapp_hiddenfield where hiddenfieldid=" + hiddenfieldid);
        dbConnect.runSqlUpdate(list);
        return query_hiddenfieldlist();
    }
}
