package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_workwechataccount implements YosObject {
  @Override
  public String table_comment() {
    return "企业微信账号绑定";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_workwechataccountid", "数据ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new VarcharCol("accountno", "企业微信账号", "企业微信账号", 500, true, false, false, "", 1));
    arrayList.add(new VarcharCol("siteid", "站点ID", "站点ID", 50, true, false, false, "", 1));
    arrayList.add(new VarcharCol("systemclient", "企业微信操作端名称", "企业微信操作端名称", 500, true, false, false, "", 1));
    arrayList.add(new BigIntCol("userid", "账号ID", "账号ID", true, false, false, 1));
    return arrayList;
  }
}
