package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_workreportpreset implements YosObject {
  @Override
  public String table_comment() {
    return "工作汇报内容预设表";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_workreportpresetid", "工作汇报内容预设表ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new IntCol("sequence", "排序", "排序", true, false, false, 3));
    arrayList.add(new SmallIntCol("editable", "是否允许编辑", "是否允许编辑", false, false, false, 0, 3));
    arrayList.add(new VarcharCol("siteid", "站点", "站点ID", 50, false, false, false, "", 2));
    arrayList.add(new SmallIntCol("issql", "是否sql", "是否sql", false, false, false, 3));
    arrayList.add(new VarcharCol("title", "标题", "标题", 200, true, false, false, "", 3));
    arrayList.add(new LongTextCol("content", "汇报内容", "issql为1时，该值为sql语句", false, false, "", 3));
    return arrayList;
  }
}
