package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_workreportmodel implements YosObject {
  @Override
  public String table_comment() {
    return "工作汇报模板";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_workreportmodelid", "工作汇报模板ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new LongTextCol("hrids", "汇报人员范围", "汇报人员范围", true, false,"", 3));
    arrayList.add(new LongTextCol("sys_workreportpresetids", "汇报内容预设id", "汇报内容预设id", true, false,"", 3));
    arrayList.add(new VarcharCol("reportname", "模板名称", "模板名称", 50, false, false, false, "", 3));
    arrayList.add(new VarcharCol("siteid", "站点", "站点ID", 50, false, false, false, "", 2));
    arrayList.add(new LongTextCol("reporttodeps", "组织内指定上级", "一级主管、二级主管、三级主管", true, false,"", 3));
    arrayList.add(new LongTextCol("reporttohrids", "指定汇报对象", "指定汇报对象", true, false,"", 3));
    arrayList.add(new SmallIntCol("isused", "是否启用", "是否启用", false, false, false, 3));
    return arrayList;
  }
}
