package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_workreport_read implements YosObject {
  @Override
  public String table_comment() {
    return "工作汇报阅读记录";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_workreport_readid", "工作汇报阅读记录ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new DateTimeCol("firstreadtime", "第一次阅读时间", "第一次阅读时间", true, false, "", 3));
    arrayList.add(new BigIntCol("hrid", "阅读人员ID", "阅读人员ID", true, false, false, 3));
    arrayList.add(new BigIntCol("sys_workreportid", "工作汇报ID", "工作汇报ID", false, false, false, 3));
    arrayList.add(new VarcharCol("siteid", "站点", "站点ID", 50, false, false, false, "", 2));
    arrayList.add(new DateTimeCol("lastreadtime", "最后一次阅读时间", "最后一次阅读时间", true, false, "", 3));
    arrayList.add(new BigIntCol("userid", "阅读人员账号id", "阅读人员账号id", false, false, false, 3));
    return arrayList;
  }
}
