package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_workreport implements YosObject {
  @Override
  public String table_comment() {
    return "工作汇报";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_workreportid", "工作汇报ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new VarcharCol("createby", "创建人", "创建人", 50, true, false, false, "", 1003));
    arrayList.add(new VarcharCol("reportname", "汇报名称", "汇报名称、模板名称", 50, false, false, false, "", 3));
    arrayList.add(new BigIntCol("hrid", "汇报人员ID", "汇报人员ID", true, false, false, 3));
    arrayList.add(new BigIntCol("sys_workreportmodelid", "工作汇报模板ID", "工作汇报模板ID", false, false, false, 3));
    arrayList.add(new BigIntCol("changeuserid", "修改人账号ID", "修改人账号ID", true, false, false, 1007));
    arrayList.add(new VarcharCol("changeby", "修改人", "修改人", 50, true, false, false, "", 1008));
    arrayList.add(new VarcharCol("siteid", "站点", "站点ID", 50, false, false, false, "", 2));
    arrayList.add(new DateTimeCol("createdate", "创建时间", "创建时间", true, false, "", 1004));
    arrayList.add(new DateTimeCol("changedate", "修改时间", "修改时间", true, false, "", 1009));
    arrayList.add(new BigIntCol("userid", "汇报人员账号id", "汇报人员账号id", false, false, false, 3));
    return arrayList;
  }
}
