package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_wechatapp implements YosObject {
  @Override
  public String table_comment() {
    return "微信应用注册";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("wechatappid", "数据ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new VarcharCol("work_messagingclasspath", "企业微信消息接收处理类路径", "企业微信消息接收处理类路径", 500, true, false, false, "", 1));
    arrayList.add(new VarcharCol("work_encodingaeskey", "企业微信encodingaeskey", "企业微信encodingaeskey", 500, true, false, false, "", 1));
    arrayList.add(new VarcharCol("work_corpsecret", "企业微信corpsecret", "企业微信corpsecret", 500, true, false, false, "", 1));
    arrayList.add(new VarcharCol("work_token", "企业微信token", "企业微信token", 500, true, false, false, "", 1));
    arrayList.add(new VarcharCol("secret", "AppSecret", "AppSecret", 50, true, false, false, "", 4));
    arrayList.add(new VarcharCol("systemclient", "操作端", "操作端", 50, false, false, false, "", 1));
    arrayList.add(new VarcharCol("mch_id", "商户ID", "商户ID", 50, true, false, false, "", 3));
    arrayList.add(new VarcharCol("work_agentid", "企业微信work_agentid", "企业微信work_agentid", 500, true, false, false, "", 1));
    arrayList.add(new VarcharCol("mch_key", "为商户平台设置的密钥key", "为商户平台设置的密钥key", 50, true, false, false, "", 2));
    arrayList.add(new VarcharCol("appid", "AppID", "AppID", 50, true, false, false, "", 5));
    arrayList.add(new VarcharCol("work_corpid", "企业微信corpid", "企业微信corpid", 500, true, false, false, "", 1));
    arrayList.add(new VarcharCol("remarks", "备注说明", "备注说明", 500, true, false, false, "", 6));
    return arrayList;
  }
}
