package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_webportal implements YosObject {
  @Override
  public String table_comment() {
    return "网址管理";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_webportalid", "数据ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new VarcharCol("classname", "分类名称", "分类名称", 50, true, false, false, "", 1));
    arrayList.add(new VarcharCol("systemname", "系统名称", "系统名称", 50, true, false, false, "", 1));
    arrayList.add(new VarcharCol("remarks", "备注说明", "备注说明", 500, true, false, false, "", 1));
    arrayList.add(new TextCol("url", "系统网址", "系统网址", true, false, "", 1));
    return arrayList;
  }
}
