package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_usersitelog implements YosObject {
  @Override
  public String table_comment() {
    return "站点授权记录表";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_usersitelogid", "数据ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new DateTimeCol("enddate", "失效日期", "失效日期", true, false, "", 1));
    arrayList.add(new DateTimeCol("begdate", "授权日期", "授权日期", true, false, "", 1));
    arrayList.add(new VarcharCol("siteid", "siteid", "siteid", 50, true, false, false, "", 1));
    arrayList.add(new BigIntCol("userid", "userid", "userid", true, false, false, 1));
    return arrayList;
  }
}
