package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_usersite implements YosObject {
  @Override
  public String table_comment() {
    return "用户站点授权表";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("usersiteid", "用户站点授权id");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new VarcharCol("createby", "授权人", "授权人", 50, true, false, false, "", 4));
    arrayList.add(new VarcharCol("accesstoken", "最新端token", "最新端token", 200, true, false, false, "", 8));
    arrayList.add(new DateTimeCol("createdate", "授权时间", "授权时间", true, false, "", 5));
    arrayList.add(new VarcharCol("siteid", "站点", "站点", 50, true, false, false, "", 2));
    arrayList.add(new IntCol("usertype", "用户类型", "用户类型", true, false, false, 3));
    arrayList.add(new VarcharCol("sessionid", "sessionid", "sessionid", 500, true, false, false, "", 6));
    arrayList.add(new VarcharCol("systemclient", "最新端token操作端", "最新端token操作端", 50, true, false, false, "", 7));
    arrayList.add(new BigIntCol("userid", "用户id", "用户id", true, false, false, 1));
    return arrayList;
  }
}
