package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;

import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_userrole implements YosObject {
    @Override
    public String table_comment() {
        return "用户角色授权表";
    }

    @Override
    public YosObject.UniqueCol uniquecolumn() {
        return new UniqueCol("userroleid", "用户角色id");
    }

    @Override
    public ArrayList<YosObjectCol> table_cols() {
        ArrayList<YosObjectCol> arrayList = new ArrayList<>();
        arrayList.add(new VarcharCol("createby", "授权人", "授权人", 50, true, false, false, "", 4));
        arrayList.add(new BigIntCol("roleid", "角色id", "角色id", false, false, false, 3));
        arrayList.add(new VarcharCol("changeby", "修改人", "修改人", 50, true, false, false, "", 6));
        arrayList.add(new DateTimeCol("createdate", "授权时间", "授权时间", true, false, "", 5));
        arrayList.add(new VarcharCol("siteid", "站点", "站点", 50, false, false, false, "", 1));
        arrayList.add(new DateTimeCol("changedate", "修改时间", "修改时间", true, false, "", 7));
        arrayList.add(new BigIntCol("userid", "用户id", "用户id", false, false, false, 2));
        arrayList.add(new BigIntCol("changeuserid", "修改人账号ID", "修改人账号ID", true, false, false, 2));
        return arrayList;
    }
}
