package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_userclientconfig implements YosObject {
  @Override
  public String table_comment() {
    return "客户端配置信息查询";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_userclientconfigid", "数据ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new VarcharCol("siteid", "站点ID", "站点ID", 50, true, false, false, "", 1));
    arrayList.add(new VarcharCol("systemclient", "操作端名称", "操作端名称", 50, true, false, false, "", 1));
    arrayList.add(new LongTextCol("config", "客户端配置信息", "客户端配置信息", true, false, "", 1));
    arrayList.add(new BigIntCol("userid", "用户ID", "用户ID", true, false, false, 1));
    return arrayList;
  }
}
