package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_task_comment implements YosObject {
  @Override
  public String table_comment() {
    return "任务评价表";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_task_commentid", "任务评价表ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new VarcharCol("createby", "发表人", "发表人", 50, true, false, false, "", 5));
    arrayList.add(new VarcharCol("siteid", "站点ID", "站点ID", 50, false, false, false, "", 1));
    arrayList.add(new DateTimeCol("createdate", "发表时间", "发表时间", true, false, "", 6));
    arrayList.add(new BigIntCol("createuserid", "发表人账号ID", "发表人账号ID", true, false, false, 4));
    arrayList.add(new BigIntCol("sys_taskid", "任务表ID", "任务表ID", false, false, false, 2));
    arrayList.add(new VarcharCol("content", "评价内容", "评价内容", 1000, true, false, false, "", 3));
    return arrayList;
  }
}
