package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_task implements YosObject {
  @Override
  public String table_comment() {
    return "任务表";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_taskid", "任务表ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new BigIntCol("changeuserid", "修改人账号ID", "修改人账号ID", true, false, false, 17));
    arrayList.add(new VarcharCol("finishnotes", "任务完成说明", "任务完成说明", 500, true, false, false, "", 3));
    arrayList.add(new VarcharCol("changeby", "修改人", "修改人", 50, true, false, false, "", 18));
    arrayList.add(new DateTimeCol("createdate", "创建时间", "创建时间", true, false, "", 14));
    arrayList.add(new DateTimeCol("endtime", "任务到期时间", "任务到期时间", true, false, "", 6));
    arrayList.add(new DateTimeCol("changedate", "修改时间", "修改时间", true, false, "", 19));
    arrayList.add(new DateTimeCol("starttime", "任务开始时间", "任务开始时间", true, false, "", 5));
    arrayList.add(new BigIntCol("ownerid", "数据id", "数据id", true, false, false, 9));
    arrayList.add(new VarcharCol("ownertable", "数据表", "数据表", 50, true, false, false, "", 10));
    arrayList.add(new VarcharCol("type", "任务类型", "任务类型", 50, true, false, false, "", 2));
    arrayList.add(new VarcharCol("title", "任务标题", "任务标题", 200, true, false, false, "", 3));
    arrayList.add(new VarcharCol("systemappids", "跳转应用id", "跳转应用id[1,2,3]", 50, true, false, false, "", 8));
    arrayList.add(new VarcharCol("createby", "创建人", "创建人", 50, true, false, false, "", 13));
    arrayList.add(new IntCol("remindday", "提醒时间", "提醒时间", true, false, false, 3));
    arrayList.add(new VarcharCol("siteid", "站点ID", "站点ID", 50, false, false, false, "", 1));
    arrayList.add(new BigIntCol("createuserid", "创建人账号ID", "创建人账号ID", true, false, false, 12));
    arrayList.add(new BigIntCol("createdepid", "创建人部门ID", "创建人部门ID", false, false, false, 11));
    arrayList.add(new VarcharCol("remarks", "任务说明", "任务说明", 500, true, false, false, "", 4));
    arrayList.add(new VarcharCol("status", "任务状态", "任务状态", 50, true, false, false, "", 7));
    return arrayList;
  }
}
