package objectregister;

import common.data.db.initialization.base.YosObject;
import common.data.db.initialization.base.YosObjectCol;
import java.lang.Override;
import java.lang.String;
import java.util.ArrayList;

public final class sys_systemtagmutex implements YosObject {
  @Override
  public String table_comment() {
    return "系统标签互斥表";
  }

  @Override
  public YosObject.UniqueCol uniquecolumn() {
    return new UniqueCol("sys_systemtagmutexid", "系统标签互斥表ID");
  }

  @Override
  public ArrayList<YosObjectCol> table_cols() {
    ArrayList<YosObjectCol> arrayList = new ArrayList<>();
    arrayList.add(new BigIntCol("tagid", "标签id", "标签id", true, false, false, 3));
    arrayList.add(new BigIntCol("sys_systemtagid", "系统标签预设表ID", "系统标签预设表ID", false, false, false, 3));
    arrayList.add(new BigIntCol("createuserid", "创建人账号ID", "创建人账号ID", true, false, false, 3));
    arrayList.add(new BigIntCol("mutextagid", "互斥标签id", "互斥标签id", true, false, false, 3));
    return arrayList;
  }
}
